/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode.ui;

import androidx.activity.result.contract.ActivityResultContract;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.ui.view.barcode.InternalBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.helpers.SBWrapperBarcodeValueFilter;
import io.scanbot.sdk_wrapper.barcode.results.SBWrapperBarcodeScannerResult;
import io.scanbot.sdk_wrapper.interfaces.SBWrapperResultDelegate;
import io.scanbot.sdk_wrapper.ui.SBWrapperRtuUI;
import io.scanbot.sdk_wrapper.utils.SBWrapperCommonUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScanner;", "Lio/scanbot/sdk_wrapper/ui/SBWrapperRtuUI;", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui/view/barcode/InternalBarcodeScannerActivity$InternalResult;", "wrapperConfiguration", "Lorg/json/JSONObject;", "resultContract", "Landroidx/activity/result/contract/ActivityResultContract;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;", "(Lorg/json/JSONObject;Landroidx/activity/result/contract/ActivityResultContract;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)V", "extraConfiguration", "", "handleResult", "activityResult", "barcode-sdk-wrapper_release"})
public final class SBWrapperRtuBarcodeScanner
extends SBWrapperRtuUI<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult> {
    @Nullable
    private final SBWrapperResultDelegate resultDelegate;

    public SBWrapperRtuBarcodeScanner(@NotNull JSONObject wrapperConfiguration, @NotNull ActivityResultContract<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult> resultContract, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)wrapperConfiguration, (String)"wrapperConfiguration");
        Intrinsics.checkNotNullParameter(resultContract, (String)"resultContract");
        String string = wrapperConfiguration.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapperConfiguration.toString()");
        super(wrapperConfiguration, BarcodeScannerConfiguration.Companion.fromJson(string), resultContract, 1000, "BarcodeScanner");
        this.resultDelegate = resultDelegate;
        this.extraConfiguration();
    }

    @Override
    protected void extraConfiguration() {
        SBWrapper.INSTANCE.setRTU_BARCODE_CONFIGURATION_BARCODE_VALUE_FILTER(SBWrapperCommonUtils.INSTANCE.extractBarcodeValueFilter(this.getWrapperConfiguration()));
        if (SBWrapper.INSTANCE.getRTU_BARCODE_CONFIGURATION_BARCODE_VALUE_FILTER() != null) {
            ((BarcodeScannerConfiguration)this.getConfiguration()).setBarcodeFilter((IBarcodeFilter)new SBWrapperBarcodeValueFilter());
        }
    }

    @Override
    protected void handleResult(@NotNull InternalBarcodeScannerActivity.InternalResult activityResult) {
        Intrinsics.checkNotNullParameter((Object)activityResult, (String)"activityResult");
        if (activityResult.getResultOk()) {
            if (activityResult.getResult() != null) {
                Object object = activityResult.getResult();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.scanbot.sdk.barcode.entity.BarcodeScanningResult");
                SBWrapperBarcodeScannerResult $this$handleResult_u24lambda_u240 = SBWrapperBarcodeScannerResult.Companion.fromNativeBarcodeResult((BarcodeScanningResult)object);
                boolean bl = false;
                String barcodeResultAsJSON = SBWrapper.INSTANCE.getGson().toJson((Object)$this$handleResult_u24lambda_u240);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, this.resultDelegate, new JSONObject(barcodeResultAsJSON), null, 4, null);
            } else {
                SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release(this.resultDelegate, "Cannot parse Barcode Scanner result");
            }
        } else {
            SBWrapperResultDelegate.Companion.sendCanceledOnMainThread$barcode_sdk_wrapper_release(this.resultDelegate);
        }
    }
}

