/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.extensions;

import android.net.Uri;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u0001H\u0000\u00a8\u0006\u0004"}, d2={"toSnakeUpperCase", "", "toValidUriOrNull", "Landroid/net/Uri;", "barcode-sdk-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBWrapperStringExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBWrapperStringExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBWrapperStringExtensionKt\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,26:1\n29#2:27\n29#2:28\n*S KotlinDebug\n*F\n+ 1 SBWrapperStringExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBWrapperStringExtensionKt\n*L\n20#1:27\n22#1:28\n*E\n"})
public final class SBWrapperStringExtensionKt {
    @NotNull
    public static final String toSnakeUpperCase(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<this>");
        string = new Regex("([a-z])([A-Z])").replace((CharSequence)string, "$1_$2");
        string = new Regex("(?!^)([A-Z])([A-Z][a-z])").replace((CharSequence)string, "$1_$2");
        string = new Regex("([0-9])([a-zA-Z][a-z])").replace((CharSequence)string, "$1_$2");
        String string2 = new Regex("([a-z])([0-9])").replace((CharSequence)string, "$1_$2").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string2;
    }

    @Nullable
    public static final Uri toValidUriOrNull(@Nullable String string) {
        boolean bl = string == null || StringsKt.isBlank((CharSequence)string);
        if (bl) {
            string = null;
        } else if (!StringsKt.startsWith$default((String)string, (String)"content:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string, (String)"file:", (boolean)false, (int)2, null)) {
            string = Uri.parse((String)("file:///" + string));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parse(this)");
        } else {
            string = Uri.parse((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parse(this)");
        }
        return string;
    }
}

