/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode.operations.setup;

import android.app.Application;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDKInitializer;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBBWrapper;
import io.scanbot.sdk_wrapper.barcode.operations.setup.SBBSdkConfiguration;
import io.scanbot.sdk_wrapper.barcode.operations.setup.SBBSdkInitializerExtensionKt;
import io.scanbot.sdk_wrapper.enums.SBSDKType;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.interfaces.SBResultDelegate;
import io.scanbot.sdk_wrapper.utils.SBStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J'\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk_wrapper/barcode/operations/setup/SBBSetupOperations;", "", "()V", "cleanup", "", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;", "initializeSdk", "application", "Landroid/app/Application;", "configurationAsJSON", "Lorg/json/JSONObject;", "(Landroid/app/Application;Lorg/json/JSONObject;Lio/scanbot/sdk_wrapper/interfaces/SBResultDelegate;)Lkotlin/Unit;", "barcode-sdk-wrapper_release"})
public final class SBBSetupOperations {
    @NotNull
    public static final SBBSetupOperations INSTANCE = new SBBSetupOperations();

    private SBBSetupOperations() {
    }

    @JvmStatic
    @Nullable
    public static final Unit initializeSdk(final @NotNull Application application, final @NotNull JSONObject jSONObject, final @NotNull SBResultDelegate sBResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        Function0 function02 = function0;
        function0 = new Function0(){

            public final void a() {
                Unit unit;
                SBWrapper sBWrapper = SBWrapper.INSTANCE;
                sBWrapper.setApplication$barcode_sdk_wrapper_release(application);
                sBWrapper.setSdkType$barcode_sdk_wrapper_release(SBSDKType.BS);
                sBWrapper.setLoggerTag$barcode_sdk_wrapper_release("ScanbotBarcodeSDKWrapper");
                Object object = SBWrapper.gson.fromJson(jSONObject.toString(), SBBSdkConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                SBBSdkConfiguration sBBSdkConfiguration = (SBBSdkConfiguration)object;
                SdkLicenseInfo sdkLicenseInfo = SBBSdkInitializerExtensionKt.fromWrapperConfig(new ScanbotBarcodeScannerSDKInitializer(), sBBSdkConfiguration).initialize(application);
                if (sBBSdkConfiguration.getStorageBaseDirectory() != null) {
                    SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
                    Uri uri = sBBSdkConfiguration.getStorageBaseDirectoryUri();
                    Intrinsics.checkNotNull((Object)uri);
                    sBStorageUtils.setBaseNativeStorageDirectory$barcode_sdk_wrapper_release(UriKt.toFile((Uri)uri));
                    Uri uri2 = sBBSdkConfiguration.getStorageBaseDirectoryUri();
                    Intrinsics.checkNotNull((Object)uri2);
                    Uri uri3 = uri2.buildUpon().appendPath("scanbot_sdk_wrapper").build();
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"build(...)");
                    sBStorageUtils.setBaseWrapperDirectory$barcode_sdk_wrapper_release(UriKt.toFile((Uri)uri3));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    sBBSdkConfiguration = application;
                    SBStorageUtils sBStorageUtils = SBStorageUtils.INSTANCE;
                    sBStorageUtils.setBaseNativeStorageDirectory$barcode_sdk_wrapper_release(new File(sBBSdkConfiguration.getFilesDir(), "scanbot-sdk"));
                    sBStorageUtils.setBaseWrapperDirectory$barcode_sdk_wrapper_release(new File(sBBSdkConfiguration.getFilesDir(), "scanbot_sdk_wrapper"));
                }
                LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$barcode_sdk_wrapper_release(), "Wrapper v6.2.2.3");
                sBWrapper.setWrapperInitializationAndSendResult$barcode_sdk_wrapper_release(sdkLicenseInfo, sBResultDelegate);
            }
        };
        return (Unit)SBWrapper.INSTANCE.runFunction$barcode_sdk_wrapper_release(null, sBResultDelegate, false, false, function02);
    }

    @JvmStatic
    public static final void cleanup(final @NotNull SBResultDelegate sBResultDelegate) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)sBResultDelegate, (String)"resultDelegate");
        Object object = SBBWrapper.INSTANCE.getLicenseInfoOrReject$barcode_sdk_wrapper_release(sBResultDelegate);
        if (object == null) {
            return;
        }
        SdkLicenseInfo sdkLicenseInfo = object;
        object = function0;
        function0 = new Function0(){

            private static final void a(SBResultDelegate object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"$resultDelegate");
                try {
                    SBBWrapper.INSTANCE.getBarcodeFileStorage$barcode_sdk_wrapper_release().cleanupBarcodeImagesDirectory();
                    SBStorageUtils.INSTANCE.cleanupWrapperStorage$barcode_sdk_wrapper_release();
                    SBResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release((SBResultDelegate)object, "Cleanup successfully done.");
                }
                catch (Exception exception) {
                    SBExceptions.SBWrapperUnexpectedError sBWrapperUnexpectedError;
                    SBResultDelegate sBResultDelegate2 = object;
                    object = sBWrapperUnexpectedError;
                    sBWrapperUnexpectedError = new SBExceptions.SBWrapperUnexpectedError(exception.getMessage());
                    SBResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release(sBResultDelegate2, (Exception)object);
                }
            }

            public final void a() {
                SBWrapper sBWrapper = SBWrapper.INSTANCE;
                LoggerProvider.getLogger().i(sBWrapper.getLoggerTag$barcode_sdk_wrapper_release(), "Cleaning storage folder ...");
                sBWrapper.getThreadPool$barcode_sdk_wrapper_release().execute(() -> a.a(sBResultDelegate));
            }
        };
        SBWrapper.runFunction$barcode_sdk_wrapper_release$default(SBWrapper.INSTANCE, sdkLicenseInfo, sBResultDelegate, false, false, (Function0)object, 12, null);
    }
}

