/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.operations.pdf_extraction;

import android.app.Application;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.Keep;
import androidx.core.net.UriKt;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBUriExtensionKt;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0081\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0006\u0010\r\u001a\u00020\u001eJ\u0013\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lio/scanbot/sdk_wrapper/operations/pdf_extraction/SBWrapperExtractFromPdfArguments;", "", "pdfFilePath", "", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "scaling", "", "(Ljava/lang/String;Landroid/graphics/Bitmap$CompressFormat;IF)V", "getCompressFormat", "()Landroid/graphics/Bitmap$CompressFormat;", "deleteTmpPdfFile", "", "pdfFile", "Ljava/io/File;", "getPdfFile", "()Ljava/io/File;", "pdfFile$delegate", "Lkotlin/Lazy;", "getQuality", "()I", "getScaling", "()F", "component1", "component2", "component3", "component4", "copy", "", "equals", "other", "hashCode", "toString", "barcode-sdk-wrapper_release"})
@Keep
public final class SBWrapperExtractFromPdfArguments {
    @NotNull
    private final String pdfFilePath;
    @NotNull
    private final Bitmap.CompressFormat compressFormat;
    private final int quality;
    private final float scaling;
    private transient boolean deleteTmpPdfFile;
    @NotNull
    private final transient Lazy pdfFile$delegate;

    public SBWrapperExtractFromPdfArguments(@NotNull String string, @NotNull Bitmap.CompressFormat compressFormat, int n2, float f2) {
        SBWrapperExtractFromPdfArguments sBWrapperExtractFromPdfArguments = this;
        Intrinsics.checkNotNullParameter((Object)string, (String)"pdfFilePath");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        this.pdfFilePath = string;
        this.compressFormat = compressFormat;
        this.quality = n2;
        sBWrapperExtractFromPdfArguments.scaling = f2;
        sBWrapperExtractFromPdfArguments.pdfFile$delegate = LazyKt.lazy((Function0)new Function0(){

            public final File a() {
                Uri uri = SBStringExtensionKt.toValidUriOrNull(pdfFilePath);
                if (uri != null) {
                    Object object = object.this;
                    if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                        object = UriKt.toFile((Uri)uri);
                    } else {
                        ((SBWrapperExtractFromPdfArguments)object).deleteTmpPdfFile = true;
                        Application application = SBWrapper.INSTANCE.getApplication$barcode_sdk_wrapper_release();
                        Intrinsics.checkNotNull((Object)application);
                        ContentResolver contentResolver = application.getContentResolver();
                        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                        object = SBUriExtensionKt.contentToFile(uri, contentResolver);
                    }
                    if (object != null) {
                        return object;
                    }
                }
                throw new SBExceptions.SBWrapperUriParsingError(null, null, 3, null);
            }
        });
    }

    public /* synthetic */ SBWrapperExtractFromPdfArguments(String string, Bitmap.CompressFormat compressFormat, int n2, float f2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = "";
        }
        if ((n3 & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        if ((n3 & 4) != 0) {
            n2 = 90;
        }
        if ((n3 & 8) != 0) {
            f2 = 2.0f;
        }
        this(string, compressFormat, n2, f2);
    }

    private final String component1() {
        return this.pdfFilePath;
    }

    public static /* synthetic */ SBWrapperExtractFromPdfArguments copy$default(SBWrapperExtractFromPdfArguments sBWrapperExtractFromPdfArguments, String string, Bitmap.CompressFormat compressFormat, int n2, float f2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = sBWrapperExtractFromPdfArguments.pdfFilePath;
        }
        if ((n3 & 2) != 0) {
            compressFormat = sBWrapperExtractFromPdfArguments.compressFormat;
        }
        if ((n3 & 4) != 0) {
            n2 = sBWrapperExtractFromPdfArguments.quality;
        }
        if ((n3 & 8) != 0) {
            f2 = sBWrapperExtractFromPdfArguments.scaling;
        }
        return sBWrapperExtractFromPdfArguments.copy(string, compressFormat, n2, f2);
    }

    public SBWrapperExtractFromPdfArguments() {
        this(null, null, 0, 0.0f, 15, null);
    }

    @NotNull
    public final Bitmap.CompressFormat getCompressFormat() {
        return this.compressFormat;
    }

    public final int getQuality() {
        return this.quality;
    }

    public final float getScaling() {
        return this.scaling;
    }

    @NotNull
    public final File getPdfFile() {
        return (File)this.pdfFile$delegate.getValue();
    }

    public final void deleteTmpPdfFile() {
        if (this.deleteTmpPdfFile) {
            try {
                this.getPdfFile().delete();
            }
            catch (Exception exception) {}
        }
    }

    @NotNull
    public final Bitmap.CompressFormat component2() {
        return this.compressFormat;
    }

    public final int component3() {
        return this.quality;
    }

    public final float component4() {
        return this.scaling;
    }

    @NotNull
    public final SBWrapperExtractFromPdfArguments copy(@NotNull String string, @NotNull Bitmap.CompressFormat compressFormat, int n2, float f2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"pdfFilePath");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        return new SBWrapperExtractFromPdfArguments(string, compressFormat, n2, f2);
    }

    @NotNull
    public String toString() {
        SBWrapperExtractFromPdfArguments sBWrapperExtractFromPdfArguments = sBWrapperExtractFromPdfArguments2;
        SBWrapperExtractFromPdfArguments sBWrapperExtractFromPdfArguments2 = sBWrapperExtractFromPdfArguments.compressFormat;
        int n2 = sBWrapperExtractFromPdfArguments.quality;
        float f2 = sBWrapperExtractFromPdfArguments.scaling;
        return "SBWrapperExtractFromPdfArguments(pdfFilePath=" + sBWrapperExtractFromPdfArguments2.pdfFilePath + ", compressFormat=" + (Bitmap.CompressFormat)sBWrapperExtractFromPdfArguments2 + ", quality=" + n2 + ", scaling=" + f2 + ")";
    }

    public int hashCode() {
        return ((this.pdfFilePath.hashCode() * 31 + this.compressFormat.hashCode()) * 31 + Integer.hashCode(this.quality)) * 31 + Float.hashCode(this.scaling);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SBWrapperExtractFromPdfArguments)) {
            return false;
        }
        object = (SBWrapperExtractFromPdfArguments)object;
        if (!Intrinsics.areEqual((Object)this.pdfFilePath, (Object)((SBWrapperExtractFromPdfArguments)object).pdfFilePath)) {
            return false;
        }
        if (this.compressFormat != ((SBWrapperExtractFromPdfArguments)object).compressFormat) {
            return false;
        }
        if (this.quality != ((SBWrapperExtractFromPdfArguments)object).quality) {
            return false;
        }
        return Float.compare(this.scaling, ((SBWrapperExtractFromPdfArguments)object).scaling) == 0;
    }
}

