/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.barcode.configuration;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import io.scanbot.genericdocument.entity.GenericDocument;
import io.scanbot.genericdocument.entity.GenericDocumentJson;
import io.scanbot.genericdocument.entity.GenericDocumentUtilKt;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.common.ByteArrayJsonKt;
import io.scanbot.sdk.common.JsonKt;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeFormat;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB9\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010 \u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\t\u0010$\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003JI\u0010&\u001a\u00020\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\t\u0010'\u001a\u00020\rH\u00d6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010+\u001a\u00020\rH\u00d6\u0001J\u0006\u0010,\u001a\u00020\bJ\t\u0010-\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;", "Landroid/os/Parcelable;", "source", "", "", "", "(Ljava/util/Map;)V", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "type", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeFormat;", "count", "", "text", "textWithExtension", "rawBytes", "", "parsedDocument", "Lio/scanbot/genericdocument/entity/GenericDocument;", "(Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeFormat;ILjava/lang/String;Ljava/lang/String;[BLio/scanbot/genericdocument/entity/GenericDocument;)V", "getCount", "()I", "getParsedDocument", "()Lio/scanbot/genericdocument/entity/GenericDocument;", "getRawBytes", "()[B", "getText", "()Ljava/lang/String;", "getTextWithExtension", "getType", "()Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeFormat;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "describeContents", "equals", "", "other", "hashCode", "toJson", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "rtu-ui-v2-barcode-common_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class BarcodeItem
implements Parcelable {
    @Nullable
    private final BarcodeFormat type;
    private final int count;
    @NotNull
    private final String text;
    @NotNull
    private final String textWithExtension;
    @NotNull
    private final byte[] rawBytes;
    @Nullable
    private final GenericDocument parsedDocument;
    public static final int $stable = 8;
    @NotNull
    public static final Parcelable.Creator<BarcodeItem> CREATOR;

    public BarcodeItem(@Nullable BarcodeFormat type, int count2, @NotNull String text, @NotNull String textWithExtension, @NotNull byte[] rawBytes, @Nullable GenericDocument parsedDocument) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textWithExtension, (String)"textWithExtension");
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        this.type = type;
        this.count = count2;
        this.text = text;
        this.textWithExtension = textWithExtension;
        this.rawBytes = rawBytes;
        this.parsedDocument = parsedDocument;
    }

    @Nullable
    public final BarcodeFormat getType() {
        return this.type;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getTextWithExtension() {
        return this.textWithExtension;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Nullable
    public final GenericDocument getParsedDocument() {
        return this.parsedDocument;
    }

    public BarcodeItem(@NotNull Map<String, ? extends Object> source) {
        GenericDocument genericDocument;
        BarcodeFormat barcodeFormat;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        if (!Intrinsics.areEqual((Object)MapsKt.getValue(source, (Object)"type"), (Object)JSONObject.NULL)) {
            Object object = MapsKt.getValue(source, (Object)"type");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            barcodeFormat = BarcodeFormat.Companion.fromJson((String)object);
        } else {
            barcodeFormat = null;
        }
        Object object = MapsKt.getValue(source, (Object)"count");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        int n = ((Number)object).intValue();
        Object object2 = MapsKt.getValue(source, (Object)"text");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object2;
        Object object3 = MapsKt.getValue(source, (Object)"textWithExtension");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object3;
        Object object4 = MapsKt.getValue(source, (Object)"rawBytes");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        byte[] byArray = ByteArrayJson.INSTANCE.fromBase64((String)object4);
        if (!Intrinsics.areEqual((Object)MapsKt.getValue(source, (Object)"parsedDocument"), (Object)JSONObject.NULL)) {
            Object object5 = MapsKt.getValue(source, (Object)"parsedDocument");
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            genericDocument = GenericDocumentJson.fromJson((Map)((Map)object5));
        } else {
            genericDocument = null;
        }
        this(barcodeFormat, n, string, string2, byArray, genericDocument);
    }

    public BarcodeItem(@NotNull JSONObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this(JsonKt.toMap((JSONObject)json));
    }

    @NotNull
    public final JSONObject toJson() {
        Object object;
        Object object2;
        JSONObject obj = new JSONObject();
        if (this.type != null) {
            BarcodeFormat barcodeFormat = this.type;
            Intrinsics.checkNotNull((Object)((Object)barcodeFormat));
            object2 = barcodeFormat.toJson();
        } else {
            object2 = JSONObject.NULL;
        }
        obj.put("type", object2);
        obj.put("count", this.count);
        obj.put("text", (Object)this.text);
        obj.put("textWithExtension", (Object)this.textWithExtension);
        obj.put("rawBytes", (Object)ByteArrayJsonKt.toBase64((byte[])this.rawBytes));
        if (this.parsedDocument != null) {
            GenericDocument genericDocument = this.parsedDocument;
            Intrinsics.checkNotNull((Object)genericDocument);
            object = GenericDocumentUtilKt.toJson((GenericDocument)genericDocument);
        } else {
            object = JSONObject.NULL;
        }
        obj.put("parsedDocument", object);
        return obj;
    }

    @Nullable
    public final BarcodeFormat component1() {
        return this.type;
    }

    public final int component2() {
        return this.count;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final String component4() {
        return this.textWithExtension;
    }

    @NotNull
    public final byte[] component5() {
        return this.rawBytes;
    }

    @Nullable
    public final GenericDocument component6() {
        return this.parsedDocument;
    }

    @NotNull
    public final BarcodeItem copy(@Nullable BarcodeFormat type, int count2, @NotNull String text, @NotNull String textWithExtension, @NotNull byte[] rawBytes, @Nullable GenericDocument parsedDocument) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textWithExtension, (String)"textWithExtension");
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        return new BarcodeItem(type, count2, text, textWithExtension, rawBytes, parsedDocument);
    }

    public static /* synthetic */ BarcodeItem copy$default(BarcodeItem barcodeItem, BarcodeFormat barcodeFormat, int n, String string, String string2, byte[] byArray, GenericDocument genericDocument, int n2, Object object) {
        if ((n2 & 1) != 0) {
            barcodeFormat = barcodeItem.type;
        }
        if ((n2 & 2) != 0) {
            n = barcodeItem.count;
        }
        if ((n2 & 4) != 0) {
            string = barcodeItem.text;
        }
        if ((n2 & 8) != 0) {
            string2 = barcodeItem.textWithExtension;
        }
        if ((n2 & 0x10) != 0) {
            byArray = barcodeItem.rawBytes;
        }
        if ((n2 & 0x20) != 0) {
            genericDocument = barcodeItem.parsedDocument;
        }
        return barcodeItem.copy(barcodeFormat, n, string, string2, byArray, genericDocument);
    }

    @NotNull
    public String toString() {
        return "BarcodeItem(type=" + this.type + ", count=" + this.count + ", text=" + this.text + ", textWithExtension=" + this.textWithExtension + ", rawBytes=" + Arrays.toString(this.rawBytes) + ", parsedDocument=" + this.parsedDocument + ")";
    }

    public int hashCode() {
        int result = this.type == null ? 0 : this.type.hashCode();
        result = result * 31 + Integer.hashCode(this.count);
        result = result * 31 + this.text.hashCode();
        result = result * 31 + this.textWithExtension.hashCode();
        result = result * 31 + Arrays.hashCode(this.rawBytes);
        result = result * 31 + (this.parsedDocument == null ? 0 : this.parsedDocument.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BarcodeItem)) {
            return false;
        }
        BarcodeItem barcodeItem = (BarcodeItem)other;
        if (this.type != barcodeItem.type) {
            return false;
        }
        if (this.count != barcodeItem.count) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)barcodeItem.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textWithExtension, (Object)barcodeItem.textWithExtension)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rawBytes, (Object)barcodeItem.rawBytes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.parsedDocument, (Object)barcodeItem.parsedDocument);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        BarcodeFormat barcodeFormat = this.type;
        if (barcodeFormat == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(barcodeFormat.name());
        }
        out.writeInt(this.count);
        out.writeString(this.text);
        out.writeString(this.textWithExtension);
        out.writeByteArray(this.rawBytes);
        out.writeParcelable((Parcelable)this.parsedDocument, flags);
    }

    static {
        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<BarcodeItem> {
            @NotNull
            public final BarcodeItem[] newArray(int size) {
                return new BarcodeItem[size];
            }

            @NotNull
            public final BarcodeItem createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new BarcodeItem(parcel.readInt() == 0 ? null : BarcodeFormat.valueOf(parcel.readString()), parcel.readInt(), parcel.readString(), parcel.readString(), parcel.createByteArray(), (GenericDocument)parcel.readParcelable(BarcodeItem.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
    }
}

