/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsDirectoryException;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsException;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b1\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u001a\u001a\u00020\u0018\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u0012\u0006\u0010\"\u001a\u00020\u001f\u00a2\u0006\u0004\bW\u0010XJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0017\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0005\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010&\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020(0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010.\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u00102\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b0\u00101\u001a\u0004\b/\u0010-R\u001a\u00105\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u00101\u001a\u0004\b3\u0010-R\u001a\u00108\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u00101\u001a\u0004\b6\u0010-R\u001a\u0010;\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u00101\u001a\u0004\b9\u0010-R\u001a\u0010>\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b=\u00101\u001a\u0004\b<\u0010-R\u001a\u0010A\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b@\u00101\u001a\u0004\b?\u0010-R\u001a\u0010D\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bC\u00101\u001a\u0004\bB\u0010-R\u001a\u0010G\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bF\u00101\u001a\u0004\bE\u0010-R\u001a\u0010J\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bI\u00101\u001a\u0004\bH\u0010-R\u001a\u0010M\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bL\u00101\u001a\u0004\bK\u0010-R\u001a\u0010P\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bO\u00101\u001a\u0004\bN\u0010-R\u001a\u0010S\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bR\u00101\u001a\u0004\bQ\u0010-R\u001a\u0010V\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bU\u00101\u001a\u0004\bT\u0010-\u00a8\u0006Y"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "Ljava/io/File;", "a", "(Lio/scanbot/sdk/blob/BlobType;)Ljava/io/File;", "Lio/scanbot/sdk/entity/Blob;", "blob", "Landroid/net/Uri;", "blobUri", "", "(Lio/scanbot/sdk/entity/Blob;Landroid/net/Uri;)V", "(Lio/scanbot/sdk/entity/Blob;)V", "", "blobs", "", "allBlobsAvailable", "(Ljava/util/Collection;)Z", "isBlobAvailable", "(Lio/scanbot/sdk/entity/Blob;)Z", "fetch", "forceFetch", "(Lio/scanbot/sdk/blob/BlobType;)V", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Landroid/content/res/AssetManager;", "b", "Landroid/content/res/AssetManager;", "assetManager", "Lio/scanbot/sdk/blob/BlobFactory;", "c", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "Lio/scanbot/sdk/util/log/Logger;", "d", "Lio/scanbot/sdk/util/log/Logger;", "logger", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "allLanguagesWithAvailableOcrBlobs", "getOcrBlobsDirectory", "()Ljava/io/File;", "ocrBlobsDirectory", "getBanksDataFile", "getBanksDataFile$annotations", "()V", "banksDataFile", "getBarcodeDetectionModelFile", "getBarcodeDetectionModelFile$annotations", "barcodeDetectionModelFile", "getBarcodeBinarizationModelFile", "getBarcodeBinarizationModelFile$annotations", "barcodeBinarizationModelFile", "getBlurEstimatorModelFile", "getBlurEstimatorModelFile$annotations", "blurEstimatorModelFile", "getMrzCascadeFile", "getMrzCascadeFile$annotations", "mrzCascadeFile", "getMrzTrainedDataFile", "getMrzTrainedDataFile$annotations", "mrzTrainedDataFile", "getFilterPredictionModelFile", "getFilterPredictionModelFile$annotations", "filterPredictionModelFile", "getCheckDigitPredictionModelFile", "getCheckDigitPredictionModelFile$annotations", "checkDigitPredictionModelFile", "getDcModelsFolderFile", "getDcModelsFolderFile$annotations", "dcModelsFolderFile", "getIdCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile$annotations", "idCardScannerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile$annotations", "genericTextRecognizerModelsFolderFile", "getDocumentDetectorModelFile", "getDocumentDetectorModelFile$annotations", "documentDetectorModelFile", "getImageProcessorModelsFolderFile", "getImageProcessorModelsFolderFile$annotations", "imageProcessorModelsFolderFile", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "sdk-base_release"})
public final class BlobManager {
    @NotNull
    public final BlobStoreStrategy a;
    @NotNull
    public final AssetManager b;
    @NotNull
    public final BlobFactory c;
    @NotNull
    public final Logger d;

    /*
     * WARNING - void declaration
     */
    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        BlobManager blobManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobFactory");
        this.a = var1_1;
        this.b = var2_2;
        blobManager.c = var3_3;
        blobManager.d = LoggerProvider.getLogger();
    }

    @Deprecated(message="banksDataFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBanksDataFile$annotations() {
    }

    @Deprecated(message="barcodeDetectionModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeDetectionModelFile$annotations() {
    }

    @Deprecated(message="barcodeBinarizationModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeBinarizationModelFile$annotations() {
    }

    @Deprecated(message="blurEstimatorModel file is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBlurEstimatorModelFile$annotations() {
    }

    @Deprecated(message="cascadeFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMrzCascadeFile$annotations() {
    }

    @Deprecated(message="mrzTrainedData is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMrzTrainedDataFile$annotations() {
    }

    @Deprecated(message="filterPredictionModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getFilterPredictionModelFile$annotations() {
    }

    @Deprecated(message="check_digit_model files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCheckDigitPredictionModelFile$annotations() {
    }

    @Deprecated(message="dc_forms_models files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDcModelsFolderFile$annotations() {
    }

    @Deprecated(message="idCardScannerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getIdCardScannerModelsFolderFile$annotations() {
    }

    @Deprecated(message="genericTextRecognizerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getGenericTextRecognizerModelsFolderFile$annotations() {
    }

    @Deprecated(message="documentDetectorModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDocumentDetectorModelFile$annotations() {
    }

    @Deprecated(message="imageProcessorModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getImageProcessorModelsFolderFile$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final File a(BlobType blobType) throws IOException {
        void var1_1;
        File this_ = ((BlobManager)((Object)this_)).a.getLocalFileFor((BlobType)var1_1);
        if (this_.exists()) {
            return this_;
        }
        throw new BlobsException("Can't get file for blob type: " + (BlobType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Blob blob, Uri blobUri) throws IOException {
        String string = blobUri.getPath();
        if (string != null) {
            void var1_1;
            InputStream inputStream = this.b.open(string);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
            FileUtilsKt.copyToFileAndClose(inputStream, new File(var1_1.getLocalPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Blob blob) throws IOException {
        void var1_1;
        File file = new File(var1_1.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new BlobsDirectoryException("Can't create destination directory");
        }
    }

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) throws IOException {
        Collection<Blob> collection = blobs;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        Iterator<Blob> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isBlobAvailable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        Throwable throwable2;
        block6: {
            boolean bl;
            block5: {
                block4: {
                    void var1_1;
                    File file;
                    Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                    File file2 = file;
                    file2(var1_1.getLocalPath());
                    InputStream inputStream = ((BlobManager)((Object)inputStream)).b.open(var1_1.getRemotePath());
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                    try {
                        if (!file.exists()) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    long l = inputStream.available();
                    if (l != file2.length()) break block4;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            inputStream.close();
            return bl;
        }
        inputStream.close();
        throw throwable2;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        BlobManager blobManager = this_;
        EnumSet<Language> this_ = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(this_, (String)"noneOf(...)");
        File[] fileArray = blobManager.a.getOcrDataDirectory().listFiles();
        if (fileArray == null) {
            return this_;
        }
        for (Object object : fileArray) {
            if (object.isDirectory()) continue;
            File file = object;
            Intrinsics.checkNotNull((Object)file);
            object = Language.Companion.languageByTessTag(FilesKt.getNameWithoutExtension((File)file));
            if (object == null) continue;
            this_.add((Language)((Object)object));
        }
        return this_;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File this_ = ((BlobManager)((Object)this_)).a.getOcrDataDirectory();
        if (!this_.exists() && !this_.mkdirs()) {
            throw new BlobsDirectoryException("Can't get OCR blobs directory");
        }
        return this_;
    }

    @NotNull
    public final File getBanksDataFile() {
        return this.a.getLocalFileFor(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeDetectionModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_DETECTION_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() {
        return this.a.getLocalFileFor(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getMrzTrainedDataFile() {
        return this.a.getLocalFileFor(BlobType.MRZ_TRAINEDDATA);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getCheckDigitPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.CHECK_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getGenericTextRecognizerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() {
        return this.a.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch(@NotNull Blob blob) throws IOException {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"blob");
        if (this_.isBlobAvailable((Blob)v0)) {
            return;
        }
        BlobManager blobManager = this_;
        void v2 = var1_1;
        this_.a((Blob)var1_1);
        BlobManager this_ = Uri.parse((String)v2.getRemotePath());
        Intrinsics.checkNotNull((Object)this_);
        blobManager.a((Blob)v2, (Uri)this_);
    }

    public final void forceFetch(@NotNull BlobType blobType) throws IOException {
        Iterator<Blob> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"blobType");
        iterator = this.c.getBlobsForType((BlobType)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            this.fetch(iterator.next());
        }
    }
}

