/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import io.scanbot.sdk.util.CursorUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/util/FileChooserUtils;", "", "()V", "CONTENT_SCHEME", "", "DOWNLOADS_AUTHORITY", "EXTERNALSTORAGE_AUTHORITY", "FILE_SCHEME", "MEDIA_AUTHORITY", "PUBLIC_DOWNLOADS_LINK", "getDataColumn", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nFileChooserUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,141:1\n37#2,2:142\n37#2,2:144\n*S KotlinDebug\n*F\n+ 1 FileChooserUtils.kt\nio/scanbot/sdk/util/FileChooserUtils\n*L\n41#1:142,2\n55#1:144,2\n*E\n"})
public final class FileChooserUtils {
    @NotNull
    public static final FileChooserUtils INSTANCE = new FileChooserUtils();
    @NotNull
    private static final String CONTENT_SCHEME = "content";
    @NotNull
    private static final String FILE_SCHEME = "file";
    @NotNull
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    @NotNull
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    @NotNull
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    @NotNull
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";

    private FileChooserUtils() {
    }

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final String getPath(@Nullable Context context, @NotNull Uri uri) {
        String[] stringArray;
        void v0 = stringArray;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"uri");
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)v0)) {
            if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray)) {
                String string = DocumentsContract.getDocumentId((Uri)stringArray);
                Intrinsics.checkNotNull((Object)string);
                var0 = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                if (StringsKt.equals((String)"primary", (String)var0[0], (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + var0[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument((Uri)stringArray)) {
                    Long l = Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray));
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
                    Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_LINK), (long)l);
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"withAppendedId(...)");
                    return FileChooserUtils.getDataColumn((Context)var0, uri2, null, null);
                }
                if (FileChooserUtils.isMediaDocument((Uri)stringArray)) {
                    String string = DocumentsContract.getDocumentId((Uri)stringArray);
                    Intrinsics.checkNotNull((Object)string);
                    stringArray = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                    Uri uri3 = null;
                    if (Intrinsics.areEqual((Object)"image", (Object)stringArray[0])) {
                        uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String[] stringArray2 = var0;
                    var0 = stringArray[1];
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = var0;
                    return FileChooserUtils.getDataColumn((Context)stringArray2, uri3, "_id=?", stringArray);
                }
            }
        } else {
            if (StringsKt.equals((String)CONTENT_SCHEME, (String)stringArray.getScheme(), (boolean)true)) {
                return FileChooserUtils.getDataColumn((Context)var0, (Uri)stringArray, null, null);
            }
            if (StringsKt.equals((String)FILE_SCHEME, (String)stringArray.getScheme(), (boolean)true)) {
                return stringArray.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getDataColumn(@Nullable Context context, @Nullable Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Object object;
        void var1_1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        if (context == null) {
            object = var1_1 != null ? var1_1.getPath() : null;
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (var1_1 != null) {
            void var3_4;
            void var2_3;
            if ((object = object.getContentResolver()) == null) {
                object = var1_1.getPath();
                if (object == null) {
                    object = "";
                } else {
                    Intrinsics.checkNotNull((Object)object);
                }
                return object;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            object = object2.query((Uri)var1_1, stringArray2, (String)var2_3, (String[])var3_4, null);
            if (object != null) {
                Object object3 = object;
                int n = object3.getColumnIndexOrThrow("_data");
                object3.moveToFirst();
                String string = object3.getString(n);
                CursorUtil.closeQuietly((Cursor)object);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }
        if ((object = var1_1 != null ? var1_1.getPath() : null) == null) {
            object = "";
        }
        return object;
    }

    @JvmStatic
    public static final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)EXTERNALSTORAGE_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isDownloadsDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)DOWNLOADS_AUTHORITY, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isMediaDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)MEDIA_AUTHORITY, (Object)uri2.getAuthority());
    }
}

