/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.VideoStabilizationUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
@SuppressLint(value={"RestrictedApi"})
public final class a {
    public static final String y = "SupportedSurfaceCombination";
    public final List<SurfaceCombination> a;
    public final List<SurfaceCombination> b;
    public final List<SurfaceCombination> c;
    public final List<SurfaceCombination> d;
    public final Map<SupportedSurfaceCombination.FeatureSettings, List<SurfaceCombination>> e;
    public final List<SurfaceCombination> f;
    public final List<SurfaceCombination> g;
    public final String h;
    public final CamcorderProfileHelper i;
    public final CameraCharacteristicsCompat j;
    public final ExtraSupportedSurfaceCombinationsContainer k;
    public final int l;
    public boolean m;
    public boolean n;
    public boolean o;
    public boolean p;
    public boolean q;
    public boolean r;
    @VisibleForTesting
    public SurfaceSizeDefinition s;
    public List<Integer> t;
    @NonNull
    public final DisplayInfoManager u;
    public final TargetAspectRatio v;
    public final ResolutionCorrector w;
    public final DynamicRangeResolver x;

    /*
     * WARNING - void declaration
     */
    public a(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        DynamicRangeResolver dynamicRangeResolver;
        int[] nArray;
        int n2;
        void var1_1;
        Object object;
        block15: {
            block14: {
                void var4_5;
                a a2 = this;
                this.a = new ArrayList<SurfaceCombination>();
                this.b = new ArrayList<SurfaceCombination>();
                this.c = new ArrayList<SurfaceCombination>();
                this.d = new ArrayList<SurfaceCombination>();
                this.e = new HashMap<SupportedSurfaceCombination.FeatureSettings, List<SurfaceCombination>>();
                this.f = new ArrayList<SurfaceCombination>();
                this.g = new ArrayList<SurfaceCombination>();
                this.m = false;
                this.n = false;
                this.o = false;
                this.p = false;
                this.q = false;
                this.r = false;
                this.t = new ArrayList<Integer>();
                this.v = new TargetAspectRatio();
                this.w = new ResolutionCorrector();
                object = (String)Preconditions.checkNotNull((Object)object);
                this.h = object;
                a2.i = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)var4_5);
                a2.k = new ExtraSupportedSurfaceCombinationsContainer();
                this.u = DisplayInfoManager.getInstance((Context)var1_1);
                object = cameraManagerCompat.getCameraCharacteristicsCompat((String)object);
                this.j = object;
                Integer n3 = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (n3 == null) break block14;
                n2 = n3;
                break block15;
            }
            n2 = 2;
        }
        try {
            this.l = n2;
            nArray = (int[])object.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        object = nArray;
        if (nArray != null) {
            for (Object object2 : object) {
                if (object2 == 3) {
                    this.m = true;
                    continue;
                }
                if (object2 == 6) {
                    this.n = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || object2 != 16) continue;
                this.q = true;
            }
        }
        a a3 = this;
        object = dynamicRangeResolver;
        a3.x = new DynamicRangeResolver(this.j);
        a3.f();
        if (a3.q) {
            this.h();
        }
        if (this.o = var1_1.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.c();
        }
        if (object.is10BitDynamicRangeSupported()) {
            this.b();
        }
        if (this.p = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.j)) {
            this.e();
        }
        if (this.r = VideoStabilizationUtil.isPreviewStabilizationSupported((CameraCharacteristicsCompat)this.j)) {
            this.d();
        }
        a a4 = this;
        a4.g();
        a4.a();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public final List<SurfaceCombination> a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings) {
        ArrayList<SurfaceCombination> arrayList;
        void var1_1;
        if (this.e.containsKey(var1_1)) {
            return this.e.get(var1_1);
        }
        List<SurfaceCombination> list = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        if (var1_1.getRequiredMaxBitDepth() == 8) {
            int n2 = var1_1.getCameraMode();
            if (n2 != 1) {
                if (n2 != 2) {
                    List<SurfaceCombination> list2 = var1_1.isPreviewStabilizationOn() ? this.d : this.a;
                    ((ArrayList)list).addAll(list2);
                } else {
                    ((ArrayList)list).addAll(this.b);
                    ((ArrayList)list).addAll(this.a);
                }
            } else {
                list = this.c;
            }
        } else if (var1_1.getRequiredMaxBitDepth() == 10 && var1_1.getCameraMode() == 0) {
            ((ArrayList)list).addAll(this.f);
        }
        this.e.put((SupportedSurfaceCombination.FeatureSettings)var1_1, list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(CameraCharacteristicsCompat characteristics, int imageFormat, Size size) {
        int n2 = 0;
        try {
            void var2_2;
            void var1_1;
            CameraCharacteristicsCompat cameraCharacteristicsCompat;
            n2 = (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration((int)var1_1, (Size)var2_2));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static int a(Range<Integer> range) {
        Range<Integer> range2;
        return (Integer)range.getUpper() - (Integer)range2.getLower() + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int a(Range<Integer> firstRange, Range<Integer> secondRange) {
        Range<Integer> range;
        void var1_1;
        Preconditions.checkState((!firstRange.contains((Comparable)((Integer)var1_1.getUpper())) && !range.contains((Comparable)((Integer)var1_1.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)var1_1.getUpper()) {
            return (Integer)range.getLower() - (Integer)var1_1.getUpper();
        }
        return (Integer)var1_1.getLower() - (Integer)range.getUpper();
    }

    /*
     * WARNING - void declaration
     */
    public static Range<Integer> a(Range<Integer> targetFps, Range<Integer> storedRange, Range<Integer> newRange) {
        double d2;
        void var2_2;
        Range<Integer> range;
        void var1_1;
        double d3 = androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1.intersect(range));
        double d4 = androidx.camera.camera2.internal.a.a((Range<Integer>)newRange.intersect(range));
        double d5 = d3;
        double d6 = d4 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var2_2);
        double d7 = d5 / (double)androidx.camera.camera2.internal.a.a((Range<Integer>)var1_1);
        if (d2 > d5) {
            if (d6 >= 0.5 || d6 >= d7) {
                return var2_2;
            }
        } else if (d4 == d3) {
            if (d6 > d7) {
                return var2_2;
            }
            if (d6 == d7 && (Integer)var2_2.getLower() > (Integer)var1_1.getLower()) {
                return var2_2;
            }
        } else if (d7 < 0.5 && d6 > d7) {
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Range<Integer> a(@Nullable Range<Integer> targetFrameRate, int maxFps) {
        block11: {
            void var2_2;
            Range range;
            Range<Integer> range2;
            if (targetFrameRate == null || range2.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) break block11;
            Range[] rangeArray = (Range[])rangeArray.j.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (rangeArray == null) {
                return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
            }
            Range range3 = range;
            range = new Range((Comparable)Integer.valueOf(Math.min((Integer)range2.getLower(), (int)var2_2)), (Comparable)Integer.valueOf(Math.min((Integer)range2.getUpper(), (int)var2_2)));
            range2 = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
            int n2 = 0;
            for (Range range4 : rangeArray) {
                block9: {
                    block10: {
                        if (var2_2 < (Integer)range4.getLower()) continue;
                        if (range2.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                            range2 = range4;
                        }
                        if (range4.equals((Object)range3)) {
                            range2 = range4;
                            break;
                        }
                        int n3 = androidx.camera.camera2.internal.a.a((Range<Integer>)range4.intersect(range3));
                        if (n2 == 0) {
                            n2 = n3;
                            break block9;
                        }
                        if (n3 < n2) break block10;
                        Range range5 = range3;
                        Range range6 = range5;
                        range2 = androidx.camera.camera2.internal.a.a((Range<Integer>)range5, range2, (Range<Integer>)range4);
                        try {
                            n2 = androidx.camera.camera2.internal.a.a((Range<Integer>)range6.intersect(range2));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (n2 != 0 || androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) >= androidx.camera.camera2.internal.a.a(range2, (Range<Integer>)range3) && (androidx.camera.camera2.internal.a.a((Range<Integer>)range4, (Range<Integer>)range3) != androidx.camera.camera2.internal.a.a(range2, (Range<Integer>)range3) || (Integer)range4.getLower() <= (Integer)range2.getUpper() && androidx.camera.camera2.internal.a.a((Range<Integer>)range4) >= androidx.camera.camera2.internal.a.a(range2))) continue;
                        }
                    }
                    range4 = range2;
                }
                range2 = range4;
            }
            return range2;
        }
        return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<Integer> b(Range<Integer> newTargetFramerate, Range<Integer> storedTargetFramerate) {
        Range range;
        if (storedTargetFramerate != null) {
            void var2_2;
            if (range != null) {
                try {
                    range = var2_2.intersect(range);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            range = var2_2;
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    public final int a(int currentMaxFps, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return Math.min(currentMaxFps, androidx.camera.camera2.internal.a.a(this.j, (int)var2_2, (Size)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final SupportedSurfaceCombination.FeatureSettings a(int cameraMode, @NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges, boolean isPreviewStabilizationOn) {
        void var3_5;
        void var1_1;
        void var2_2;
        int n2 = androidx.camera.camera2.internal.a.a(var2_2);
        if (cameraMode != 0 && n2 == 10) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.h;
            objectArray[1] = CameraMode.toLabelString((int)var1_1);
            throw new IllegalArgumentException(String.format("Camera device id is %s. 10 bit dynamic range is not currently supported in %s camera mode.", objectArray2));
        }
        return SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)n2, (boolean)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        void var1_1;
        void var3_3;
        CompareSizesByArea compareSizesByArea;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        CompareSizesByArea compareSizesByArea2 = attachedSurfaces.iterator();
        while (compareSizesByArea2.hasNext()) {
            arrayList2.add(compareSizesByArea2.next().getSurfaceConfig());
        }
        compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea();
        for (UseCaseConfig useCaseConfig : var3_3.keySet()) {
            List list = (List)var3_3.get(useCaseConfig);
            boolean bl = list != null && !list.isEmpty();
            UseCaseConfig useCaseConfig2 = useCaseConfig;
            Preconditions.checkArgument((boolean)bl, (Object)("No available output size is found for " + useCaseConfig + "."));
            useCaseConfig = (Size)Collections.min(list, compareSizesByArea2);
            int n2 = useCaseConfig2.getInputFormat();
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1.getCameraMode(), (int)n2, (Size)useCaseConfig, (SurfaceSizeDefinition)this.b(n2)));
        }
        return this.a((SupportedSurfaceCombination.FeatureSettings)var1_1, arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Range<Integer> a(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs, @NonNull List<Integer> useCasesPriorityOrder) {
        Iterator iterator;
        Range<Integer> range = null;
        Iterator<AttachedSurfaceInfo> iterator2 = attachedSurfaces.iterator();
        while (iterator2.hasNext()) {
            range = this.b((Range<Integer>)iterator2.next().getTargetFrameRate(), range);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            range = this.b((Range<Integer>)((UseCaseConfig)var2_2.get((Integer)iterator.next())).getTargetFrameRate(null), range);
        }
        return range;
    }

    public final int b(@NonNull List<AttachedSurfaceInfo> attachedSurfaces) {
        int n2 = Integer.MAX_VALUE;
        Iterator<AttachedSurfaceInfo> iterator = attachedSurfaces.iterator();
        while (iterator.hasNext()) {
            int n3 = n2;
            AttachedSurfaceInfo attachedSurfaceInfo = iterator.next();
            n2 = attachedSurfaceInfo.getImageFormat();
            n2 = this.a(n3, n2, attachedSurfaceInfo.getSize());
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Map<UseCaseConfig<?>, List<Size>> a(@NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, @NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, @Nullable Range<Integer> targetFpsRange) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigsSupportedSizeMap.keySet()) {
            void var1_1;
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap3;
            ArrayList<Size> arrayList;
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>();
            HashMap<SurfaceConfig.ConfigSize, Set> hashMap4 = hashMap3;
            hashMap3 = new HashMap<SurfaceConfig.ConfigSize, Set>();
            for (Size size : (List)var1_1.get(useCaseConfig)) {
                Set set;
                void var3_3;
                void var2_2;
                int n2 = useCaseConfig.getInputFormat();
                SurfaceConfig.ConfigSize configSize = SurfaceConfig.transformSurfaceConfig((int)var2_2.getCameraMode(), (int)n2, (Size)size, (SurfaceSizeDefinition)this.b(n2)).getConfigSize();
                int n3 = Integer.MAX_VALUE;
                if (var3_3 != null) {
                    n3 = androidx.camera.camera2.internal.a.a(this.j, n2, size);
                }
                if ((set = (Set)hashMap4.get(configSize)) == null) {
                    HashSet hashSet;
                    set = hashSet;
                    hashSet = new HashSet();
                    hashMap4.put(configSize, set);
                }
                if (set.contains(n3)) continue;
                arrayList2.add(size);
                set.add(n3);
            }
            hashMap2.put(useCaseConfig, arrayList2);
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<List<SurfaceConfig>, Integer> a(int cameraMode, List<AttachedSurfaceInfo> attachedSurfaces, List<Size> possibleSizeList, List<UseCaseConfig<?>> newUseCaseConfigs, List<Integer> useCasesPriorityOrder, int currentConfigFramerateCeiling, @Nullable Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @Nullable Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap) {
        int n2;
        void var3_3;
        ArrayList<SurfaceConfig> arrayList;
        ArrayList<SurfaceConfig> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            void var7_7;
            arrayList2.add(attachedSurfaceInfo.getSurfaceConfig());
            if (var7_7 == null) continue;
            var7_7.put(arrayList2.size() - 1, attachedSurfaceInfo);
        }
        for (int i2 = 0; i2 < var3_3.size(); ++i2) {
            void var8_9;
            void var1_1;
            void var5_5;
            void var4_4;
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)var3_3.get(i2);
            attachedSurfaceInfo = (UseCaseConfig)var4_4.get((Integer)var5_5.get(i2));
            int n3 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.b(n3);
            arrayList2.add(SurfaceConfig.transformSurfaceConfig((int)var1_1, (int)n3, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (var8_9 != null) {
                var8_9.put(arrayList2.size() - 1, attachedSurfaceInfo);
            }
            n2 = this.a(n2, attachedSurfaceInfo.getInputFormat(), size);
        }
        return new Pair(arrayList2, (Object)n2);
    }

    public static int a(@NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        Iterator<DynamicRange> iterator = resolvedDynamicRanges.values().iterator();
        while (iterator.hasNext()) {
            if (((DynamicRange)iterator.next()).getBitDepth() != 10) continue;
            return 10;
        }
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Integer> c(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        Object object = arrayList;
        arrayList = new ArrayList();
        Iterator<UseCaseConfig<?>> iterator = newUseCaseConfigs.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getSurfaceOccupancyPriority(0);
            if (((ArrayList)object).contains(n2)) continue;
            ((ArrayList)object).add(n2);
        }
        ArrayList arrayList4 = object;
        Collections.sort(arrayList4);
        Collections.reverse(arrayList4);
        object = arrayList4.iterator();
        while (object.hasNext()) {
            void var1_1;
            int n3 = (Integer)object.next();
            for (UseCaseConfig useCaseConfig : var1_1) {
                if (n3 != useCaseConfig.getSurfaceOccupancyPriority(0)) continue;
                arrayList3.add(var1_1.indexOf(useCaseConfig));
            }
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public final List<List<Size>> a(List<List<Size>> supportedOutputSizesList) {
        int n2 = 1;
        Object object = supportedOutputSizesList.iterator();
        while (object.hasNext()) {
            n2 = object.next().size() * n2;
        }
        if (n2 != 0) {
            void var1_2;
            int n3;
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((ArrayList)object).add(arrayList3);
            }
            n3 = n2 / ((List)var1_2.get(0)).size();
            int n4 = n2;
            for (int i2 = 0; i2 < var1_2.size(); ++i2) {
                List list = (List)var1_2.get(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((List)((ArrayList)object).get(i3)).add((Size)list.get(i3 % n4 / n3));
                }
                if (i2 < var1_2.size() - 1) {
                    n4 = n3 / ((List)var1_2.get(i2 + 1)).size();
                } else {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
            return object;
        }
        throw new IllegalArgumentException("Failed to find supported resolutions.");
    }

    /*
     * WARNING - void declaration
     */
    public final Size a(StreamConfigurationMap map, int imageFormat, boolean highResolutionIncluded) {
        void var2_2;
        Size[] sizeArray;
        Object object = imageFormat == 34 ? sizeArray.getOutputSizes(SurfaceTexture.class) : sizeArray.getOutputSizes((int)var2_2);
        if (object != null && ((Size[])object).length != 0) {
            void var3_3;
            CompareSizesByArea compareSizesByArea;
            CompareSizesByArea compareSizesByArea2 = object;
            object = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea();
            Size size = (Size)Collections.max(Arrays.asList(compareSizesByArea2), object);
            Size size2 = SizeUtil.RESOLUTION_ZERO;
            if (Build.VERSION.SDK_INT >= 23 && var3_3 != false && (sizeArray = SupportedSurfaceCombination.Api23Impl.getHighResolutionOutputSizes((StreamConfigurationMap)sizeArray, (int)var2_2)) != null && sizeArray.length > 0) {
                size2 = Collections.max(Arrays.asList(sizeArray), object);
            }
            return Collections.max(Arrays.asList(size, size2), object);
        }
        return null;
    }

    public final void f() {
        a a2 = this_;
        a a3 = this_;
        boolean bl = a3.m;
        a2.a.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)((a)((Object)this_)).l, (boolean)bl, (boolean)a3.n));
        a a4 = this_;
        String this_ = a4.h;
        a2.a.addAll(((a)((Object)this_)).k.get(this_, a4.l));
    }

    public final void h() {
        this.b.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
    }

    public final void c() {
        this.c.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
    }

    public final void b() {
        this.f.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
    }

    public final void e() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.g.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
    }

    public final void d() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.d.addAll(GuaranteedConfigurationsUtil.getPreviewStabilizationSupportedCombinationList());
        }
    }

    public final void a() {
    }

    public final void g() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Size size;
        a a2 = this_;
        a this_ = size;
        size = new Size(1920, 1080);
        Size size2 = a2.j();
        HashMap hashMap4 = hashMap3;
        hashMap3 = new HashMap();
        HashMap hashMap5 = hashMap2;
        hashMap2 = new HashMap();
        HashMap hashMap6 = hashMap;
        hashMap = new HashMap();
        a2.s = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)this_, hashMap4, (Size)size2, hashMap5, hashMap6);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, @NonNull Size targetSize, int format) {
        void var1_1;
        Size size;
        void var3_3;
        if (!this_.o) {
            return;
        }
        a a2 = this_;
        a this_ = a2.a(a2.j.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var3_3, false);
        Integer n2 = (int)var3_3;
        if (this_ != null) {
            size = Collections.min(Arrays.asList(size, this_), new CompareSizesByArea());
        }
        var1_1.put(n2, size);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(@NonNull Map<Integer, Size> sizeMap, int format) {
        void var2_2;
        a a2 = this_;
        a this_ = a2.a(a2.j.getStreamConfigurationMapCompat().toStreamConfigurationMap(), (int)var2_2, true);
        if (this_ != null) {
            void var1_1;
            var1_1.put((int)var2_2, this_);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void b(@NonNull Map<Integer, Size> sizeMap, int format) {
        if (Build.VERSION.SDK_INT >= 31 && ((a)((Object)n2)).q) {
            void var1_1;
            void var2_2;
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)((a)((Object)n2)).j.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION);
            if (streamConfigurationMap == null) {
                return;
            }
            a a2 = n2;
            Integer n2 = (int)var2_2;
            var1_1.put(n2, a2.a(streamConfigurationMap, (int)var2_2, true));
            return;
        }
    }

    public final void n() {
        a a2 = this_;
        a2.u.refresh();
        if (a2.s == null) {
            ((a)((Object)this_)).g();
        } else {
            Size size;
            a a3 = this_;
            Size size2 = size;
            size = new Size(1920, 1080);
            Size size3 = size2;
            a a4 = this_;
            Map this_ = a4.s.getS1440pSizeMap();
            size2 = a4.s.getRecordSize();
            Map map = a4.s.getMaximumSizeMap();
            Map map2 = a4.s.getUltraMaximumSizeMap();
            a3.s = SurfaceSizeDefinition.create((Size)a3.s.getAnalysisSize(), (Map)((a)((Object)this_)).s.getS720pSizeMap(), (Size)size3, (Map)this_, (Size)size2, (Map)map, (Map)map2);
        }
    }

    @NonNull
    public final Size j() {
        CamcorderProfile camcorderProfile;
        int n2;
        block3: {
            try {
                a a2 = this;
                n2 = Integer.parseInt(a2.h);
                camcorderProfile = null;
                if (!a2.i.hasProfile(n2, 1)) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                return this.k();
            }
            camcorderProfile = this.i.get(n2, 1);
        }
        if (camcorderProfile != null) {
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n3 = camcorderProfile2.videoFrameWidth;
            return new Size(n3, camcorderProfile2.videoFrameHeight);
        }
        return this.a(n2);
    }

    @NonNull
    public final Size k() {
        CompareSizesByArea compareSizesByArea;
        Size[] this_ = this_.j.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
        if (this_ == null) {
            return SizeUtil.RESOLUTION_480P;
        }
        CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
        compareSizesByArea = new CompareSizesByArea(true);
        Arrays.sort(this_, compareSizesByArea2);
        for (Size size : this_) {
            if (size.getWidth() > SizeUtil.RESOLUTION_1080P.getWidth() || size.getHeight() > SizeUtil.RESOLUTION_1080P.getHeight()) continue;
            return size;
        }
        return SizeUtil.RESOLUTION_480P;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size a(int cameraId) {
        void var1_2;
        Size size = SizeUtil.RESOLUTION_480P;
        CamcorderProfile camcorderProfile = null;
        if (this.i.hasProfile((int)var1_2, 10)) {
            camcorderProfile = this.i.get((int)var1_2, 10);
        } else if (this.i.hasProfile((int)var1_2, 8)) {
            camcorderProfile = this.i.get((int)var1_2, 8);
        } else if (this.i.hasProfile((int)var1_2, 12)) {
            camcorderProfile = this.i.get((int)var1_2, 12);
        } else if (this.i.hasProfile((int)var1_2, 6)) {
            camcorderProfile = this.i.get((int)var1_2, 6);
        } else if (this.i.hasProfile((int)var1_2, 5)) {
            camcorderProfile = this.i.get((int)var1_2, 5);
        } else if (this.i.hasProfile((int)var1_2, 4)) {
            camcorderProfile = this.i.get((int)var1_2, 4);
        }
        if (camcorderProfile != null) {
            Size size2;
            size = size2;
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n2 = camcorderProfile2.videoFrameWidth;
            size2 = new Size(n2, camcorderProfile2.videoFrameHeight);
        }
        return size;
    }

    public String i() {
        return this.h;
    }

    public boolean m() {
        return this.m;
    }

    public boolean l() {
        return this.n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean a(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        void var2_3;
        Iterator<SurfaceCombination> iterator;
        boolean bl = false;
        iterator = this.a((SupportedSurfaceCombination.FeatureSettings)iterator).iterator();
        while (iterator.hasNext() && !(bl = iterator.next().getOrderedSupportedSurfaceConfigList((List)var2_3) != null)) {
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<SurfaceConfig> b(@NonNull SupportedSurfaceCombination.FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)featureSettings)) {
            return null;
        }
        Iterator<SurfaceCombination> iterator = ((a)((Object)iterator)).g.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            List list = ((SurfaceCombination)iterator.next()).getOrderedSupportedSurfaceConfigList((List)var2_2);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SurfaceConfig b(int cameraMode, int imageFormat, Size size) {
        void var3_3;
        void var2_2;
        return SurfaceConfig.transformSurfaceConfig((int)cameraMode, (int)var2_2, (Size)var3_3, (SurfaceSizeDefinition)this.b((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> a(int cameraMode, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, boolean isPreviewStabilizationOn) {
        void var4_9;
        void var1_1;
        void var2_4;
        Object object;
        ArrayList arrayList;
        a a2 = this;
        a a3 = this;
        a3.n();
        ArrayList arrayList2 = arrayList;
        List<Integer> list = a3.c(new ArrayList(object.keySet()));
        Map map = a3.x.resolveAndValidateDynamicRanges((List)var2_4, arrayList2, list);
        UseCaseConfig<?> useCaseConfig3 = a2.a((int)var1_1, map, (boolean)var4_9);
        boolean bl = a2.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, (List<AttachedSurfaceInfo>)var2_4, (Map<UseCaseConfig<?>, List<Size>>)object);
        if (bl) {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            Object object2;
            ArrayList<List<Size>> arrayList3;
            a a4 = this;
            Range<Integer> range = a4.a((List<AttachedSurfaceInfo>)var2_4, arrayList2, list);
            object = a4.a((Map<UseCaseConfig<?>, List<Size>>)object, (SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, range);
            Cloneable cloneable = arrayList3;
            arrayList3 = new ArrayList<List<Size>>();
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                UseCaseConfig<?> useCaseConfig2 = arrayList2.get(object3.next());
                object2 = (List)object.get(useCaseConfig2);
                cloneable.add(this.a((List<Size>)object2, useCaseConfig2.getInputFormat()));
            }
            a a5 = this;
            void v7 = var2_4;
            object = this.a((List<List<Size>>)((Object)cloneable));
            cloneable = hashMap4;
            hashMap4 = new HashMap();
            object3 = hashMap3;
            hashMap3 = new HashMap();
            object2 = hashMap2;
            hashMap2 = new HashMap();
            HashMap hashMap5 = hashMap;
            hashMap = new HashMap();
            List list2 = null;
            int n2 = Integer.MAX_VALUE;
            List list3 = null;
            int n3 = Integer.MAX_VALUE;
            boolean bl2 = StreamUseCaseUtil.containsZslUseCase((List)v7, arrayList2);
            List<SurfaceConfig> list4 = null;
            int n4 = a5.b((List<AttachedSurfaceInfo>)v7);
            if (a5.p && !bl2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    list4 = this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, (List)this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, (List<Size>)((List)iterator.next()), arrayList2, list, (int)n4, (Map<Integer, AttachedSurfaceInfo>)object2, hashMap5).first);
                    if (list4 != null && !StreamUseCaseUtil.areCaptureTypesEligible((Map)object2, hashMap5, list4)) {
                        list4 = null;
                    }
                    if (list4 != null) {
                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.j, list4)) break;
                        list4 = null;
                    }
                    ((HashMap)object2).clear();
                    hashMap5.clear();
                }
                if (list4 == null && !bl) {
                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.h + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
                }
            }
            boolean bl3 = false;
            bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                List list5 = (List)iterator.next();
                Pair<List<SurfaceConfig>, Integer> pair = this.a((int)var1_1, (List<AttachedSurfaceInfo>)var2_4, list5, arrayList2, list, n4, null, null);
                List list6 = (List)pair.first;
                int n5 = (Integer)pair.second;
                boolean bl4 = true;
                if (range != null && n4 > n5 && n5 < (Integer)range.getLower()) {
                    bl4 = false;
                }
                if (!bl3 && this.a((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6)) {
                    if (n2 == Integer.MAX_VALUE || n2 < n5) {
                        list2 = list5;
                        n2 = n5;
                    }
                    if (bl4) {
                        bl3 = true;
                        if (bl) {
                            n2 = n5;
                            list2 = list5;
                            break;
                        }
                        list2 = list5;
                        n2 = n5;
                    }
                }
                if (list4 == null || bl || this.b((SupportedSurfaceCombination.FeatureSettings)useCaseConfig3, list6) == null) continue;
                if (n3 == Integer.MAX_VALUE || n3 < n5) {
                    list3 = list5;
                    n3 = n5;
                }
                if (!bl4) continue;
                bl = true;
                if (bl3) {
                    list3 = list5;
                    n3 = n5;
                    break;
                }
                list3 = list5;
                n3 = n5;
            }
            if (list2 != null) {
                Range<Integer> range2 = null;
                if (range != null) {
                    range2 = this.a(range, n2);
                }
                for (UseCaseConfig<?> useCaseConfig3 : arrayList2) {
                    StreamSpec.Builder builder = StreamSpec.builder((Size)((Size)list2.get(list.indexOf(arrayList2.indexOf(useCaseConfig3))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)map.get(useCaseConfig3)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions(useCaseConfig3));
                    if (range2 != null) {
                        builder.setExpectedFrameRateRange(range2);
                    }
                    ((HashMap)object3).put(useCaseConfig3, builder.build());
                }
                if (list4 != null && n2 == n3 && list2.size() == list3.size()) {
                    boolean bl5 = false;
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        if (((Size)list2.get(i2)).equals(list3.get(i2))) continue;
                        bl5 = true;
                        break;
                    }
                    if (!bl5 && !StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.j, (List)var2_4, (Map)object3, cloneable)) {
                        StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs((Map)object3, cloneable, (Map)object2, hashMap5, list4);
                    }
                }
                return new Pair(object3, cloneable);
            }
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.h + " and Hardware level: " + this.l + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.h + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_4 + " New configs: " + arrayList2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public List<Size> a(@NonNull List<Size> sizeList, int imageFormat) {
        void var2_2;
        Object object;
        Object object2;
        a a2 = this;
        String string = a2.h;
        int n2 = this.v.get(string, a2.j);
        string = null;
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                string = null;
                break;
            }
            case 2: {
                Rational rational;
                string = this.b(256).getMaximumSize(256);
                object2 = rational;
                String string2 = string;
                int n3 = string2.getWidth();
                rational = new Rational(n3, string2.getHeight());
                string = object2;
                break;
            }
            case 1: {
                string = AspectRatioUtil.ASPECT_RATIO_16_9;
                break;
            }
            case 0: {
                string = AspectRatioUtil.ASPECT_RATIO_4_3;
            }
        }
        if (string != null) {
            ArrayList arrayList;
            ArrayList arrayList2;
            void v4 = object;
            object = arrayList2;
            arrayList2 = new ArrayList();
            object2 = arrayList;
            arrayList = new ArrayList();
            for (Size size : v4) {
                if (AspectRatioUtil.hasMatchingAspectRatio((Size)size, (Rational)string)) {
                    ((ArrayList)object).add(size);
                    continue;
                }
                ((ArrayList)object2).add(size);
            }
            ((ArrayList)object2).addAll(0, object);
            object = object2;
        }
        return this.w.insertOrPrioritize(SurfaceConfig.getConfigType((int)var2_2), object);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NonNull
    public SurfaceSizeDefinition b(int format) {
        void var1_1;
        if (!this.t.contains((int)var1_1)) {
            a a2 = this;
            a2.a(a2.s.getS720pSizeMap(), SizeUtil.RESOLUTION_720P, (int)var1_1);
            a2.a(a2.s.getS1440pSizeMap(), SizeUtil.RESOLUTION_1440P, (int)var1_1);
            a2.a(a2.s.getMaximumSizeMap(), (int)var1_1);
            a2.b(a2.s.getUltraMaximumSizeMap(), (int)var1_1);
            a2.t.add((int)var1_1);
        }
        return this.s;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface a {
    }
}

