/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.util.Log;
import com.android.mms.exif.ExifData;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifParser;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.IfdData;
import java.io.InputStream;

class ExifReader {
    private static final String TAG = "ExifReader";
    private final ExifInterface mInterface;

    /*
     * WARNING - void declaration
     */
    public ExifReader(ExifInterface iRef) {
        void var1_1;
        this.mInterface = var1_1;
    }

    public ExifData read(InputStream inputStream) {
        ExifData exifData;
        ExifParser exifParser = ExifParser.parse(inputStream, ((ExifReader)((Object)exifParser)).mInterface);
        ExifData exifData2 = exifData;
        exifData = new ExifData(exifParser.getByteOrder());
        int n2 = exifParser.next();
        while (n2 != 5) {
            switch (n2) {
                default: {
                    break;
                }
                case 4: {
                    int n3 = exifParser.getStripSize();
                    byte[] byArray = new byte[n3];
                    if (n3 == exifParser.read(byArray)) {
                        exifData2.setStripBytes(exifParser.getStripIndex(), byArray);
                        break;
                    }
                    Log.w((String)TAG, (String)"Failed to read the strip bytes");
                    break;
                }
                case 3: {
                    int n4 = exifParser.getCompressedImageSize();
                    byte[] byArray = new byte[n4];
                    if (n4 == exifParser.read(byArray)) {
                        exifData2.setCompressedThumbnail(byArray);
                        break;
                    }
                    Log.w((String)TAG, (String)"Failed to read the compressed thumbnail");
                    break;
                }
                case 2: {
                    ExifTag exifTag = exifParser.getTag();
                    if (exifTag.getDataType() == 7) {
                        exifParser.readFullTagValue(exifTag);
                    }
                    exifData2.getIfdData(exifTag.getIfd()).setTag(exifTag);
                    break;
                }
                case 1: {
                    ExifTag exifTag = exifParser.getTag();
                    if (!exifTag.hasValue()) {
                        exifParser.registerForTagValue(exifTag);
                        break;
                    }
                    exifData2.getIfdData(exifTag.getIfd()).setTag(exifTag);
                    break;
                }
                case 0: {
                    exifData2.addIfdData(new IfdData(exifParser.getCurrentIfd()));
                }
            }
            n2 = exifParser.next();
        }
        return exifData2;
    }
}

