/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.creditcard;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.common.Result;
import io.scanbot.common.ResultKt;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.creditcard.CreditCardScanner;
import io.scanbot.sdk.creditcard.CreditCardScanningResult;
import io.scanbot.sdk.licensing.Feature;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0003#$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u00102\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0002J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "creditCardScanner", "Lio/scanbot/sdk/creditcard/CreditCardScanner;", "(Lio/scanbot/sdk/creditcard/CreditCardScanner;)V", "handlers", "", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "mapPolygonToPointsArray", "", "Landroid/graphics/PointF;", "polygon", "frameWidth", "", "frameHeight", "orientation", "finderRect", "Landroid/graphics/RectF;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/creditcard/CreditCardScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "Companion", "CreditCardScannerResultHandler", "ResultHandler", "sdk-creditcard_release"})
@SourceDebugExtension(value={"SMAP\nCreditCardScannerFrameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreditCardScannerFrameHandler.kt\nio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler\n+ 2 Rect.kt\nandroidx/core/graphics/RectKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n337#2:145\n1#3:146\n1549#4:147\n1620#4,3:148\n*S KotlinDebug\n*F\n+ 1 CreditCardScannerFrameHandler.kt\nio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler\n*L\n56#1:145\n81#1:147\n81#1:148,3\n*E\n"})
public final class CreditCardScannerFrameHandler
extends FrameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CreditCardScanner creditCardScanner;
    @NotNull
    private final Set<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public CreditCardScannerFrameHandler(@NotNull CreditCardScanner creditCardScanner) {
        void var1_1;
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"creditCardScanner");
        creditCardScannerFrameHandler.creditCardScanner = var1_1;
        creditCardScannerFrameHandler.handlers = new LinkedHashSet<ResultHandler>();
        creditCardScannerFrameHandler.sapManager = SapSingleton.getInstance();
        creditCardScannerFrameHandler.logger = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private final List<PointF> mapPolygonToPointsArray(List<? extends PointF> polygon, int frameWidth, int frameHeight, int orientation, RectF finderRect) {
        Iterator iterator;
        ArrayList<PointF> arrayList;
        void var5_8;
        void var3_5;
        void var2_4;
        boolean bl = orientation % 180 == 0;
        void var4_7 = bl ? var2_4 : var3_5;
        if (bl) {
            var2_4 = var3_5;
        }
        void v0 = var5_8;
        float f = v0.width();
        float f2 = v0.height();
        float f3 = v0.left;
        float f4 = v0.top;
        ArrayList<PointF> arrayList2 = arrayList;
        arrayList = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            PointF pointF = (PointF)iterator.next();
            arrayList2.add(new PointF((pointF.x * f + f3) / (float)var4_7, (pointF.y * f2 + f4) / (float)var2_4));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean notifyHandlers(FrameHandlerResult<CreditCardScanningResult, SdkLicenseError> result) {
        void var1_1;
        return this.processResult((Function0)new Function0<Boolean>(this, (FrameHandlerResult<CreditCardScanningResult, SdkLicenseError>)var1_1){
            public final /* synthetic */ CreditCardScannerFrameHandler a;
            public final /* synthetic */ FrameHandlerResult<CreditCardScanningResult, SdkLicenseError> b;
            {
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @NotNull
            public final Boolean a() {
                boolean bl = false;
                Set set = this_.a.handlers;
                a a2 = this_;
                Object this_ = a2.a;
                FrameHandlerResult<CreditCardScanningResult, SdkLicenseError> frameHandlerResult = a2.b;
                synchronized (set) {
                    Throwable throwable2;
                    block4: {
                        boolean bl2;
                        try {
                            this_ = ((CreditCardScannerFrameHandler)((Object)this_)).handlers.iterator();
                            while (this_.hasNext()) {
                                bl |= ((ResultHandler)this_.next()).handle(frameHandlerResult);
                            }
                            bl2 = bl;
                            Set set2 = set;
                        }
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        return bl2;
                    }
                    throw throwable2;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final CreditCardScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull CreditCardScanner creditCardScanner) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (CreditCardScanner)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        boolean bl;
        void var1_1;
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFrame");
        creditCardScannerFrameHandler.logger.logMethod();
        if (!creditCardScannerFrameHandler.sapManager.checkLicenseStatus(Feature.CREDIT_CARD_SCANNER)) {
            this_.notifyHandlers((FrameHandlerResult<CreditCardScanningResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError(this_.sapManager.getLicenseInfo().getLicenseStatusMessage())));
            return false;
        }
        CreditCardScanningResult creditCardScanningResult = (CreditCardScanningResult)ResultKt.getOrNull((Result)this_.creditCardScanner.run(var1_1.getFrame()));
        if (var1_1.getFinderRect() != null && creditCardScanningResult != null) {
            RectF rectF;
            void v1 = var1_1;
            List<PointF> list = creditCardScanningResult.getQuadNormalized();
            int n = v1.getWidth();
            int n2 = v1.getHeight();
            int n3 = v1.getFrameOrientation();
            Rect rect = v1.getFinderRect();
            Intrinsics.checkNotNull((Object)rect);
            RectF rectF2 = rectF;
            rectF = new RectF(rect);
            list = this_.mapPolygonToPointsArray((List<? extends PointF>)list, n, n2, n3, rectF2);
            CreditCardScanningResult.copy$default((CreditCardScanningResult)creditCardScanningResult, null, null, null, null, list, (int)15, null);
        }
        if (creditCardScanningResult != null) {
            FrameHandlerResult.Success success;
            CreditCardScannerFrameHandler creditCardScannerFrameHandler2 = this_;
            CreditCardScannerFrameHandler this_ = success;
            success = new FrameHandlerResult.Success((Object)creditCardScanningResult, (FrameHandler.Frame)var1_1);
            bl = creditCardScannerFrameHandler2.notifyHandlers((FrameHandlerResult<CreditCardScanningResult, SdkLicenseError>)this_);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(var1_1);
            return;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "creditCardScanner", "Lio/scanbot/sdk/creditcard/CreditCardScanner;", "sdk-creditcard_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CreditCardScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull CreditCardScanner creditCardScanner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"creditCardScanner");
            Object object = (CreditCardScannerFrameHandler)cameraView.getAttachedFrameHandler(CreditCardScannerFrameHandler.class);
            if (object == null) {
                CreditCardScannerFrameHandler creditCardScannerFrameHandler;
                object = creditCardScannerFrameHandler;
                creditCardScannerFrameHandler = new CreditCardScannerFrameHandler((CreditCardScanner)var2_2);
            }
            var1_1.addFrameHandler((FrameHandler)object);
            return object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$CreditCardScannerResultHandler;", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "()V", "sdk-creditcard_release"})
    public static abstract class CreditCardScannerResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/creditcard/CreditCardScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-creditcard_release"})
    public static interface ResultHandler
    extends BaseResultHandler<CreditCardScanningResult, SdkLicenseError> {
    }
}

