/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010!\u001a\u00020\u001f\u0012\u0006\u0010$\u001a\u00020\"\u0012\u0006\u0010(\u001a\u00020%\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u001e\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016J\u0016\u0010\u000e\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0016J&\u0010\u0011\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0012\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002R\u0014\u0010!\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010 R\u0014\u0010$\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010#R\u0014\u0010(\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "Landroid/graphics/Bitmap;", "bitmap", "Lio/scanbot/sdk/ocr/process/OcrResult;", "recognizeTextFromBitmap", "", "Landroid/net/Uri;", "imageFileUris", "", "sourceFilesEncrypted", "recognizeTextFromUris", "Lio/scanbot/sdk/persistence/Page;", "pages", "recognizeTextFromPages", "Lio/scanbot/pdf/model/PdfConfig;", "pdfConfig", "recognizeTextWithPdfFromUris", "recognizeTextWithPdfFromPages", "Ljava/io/File;", "getLanguageDataPath", "", "Lio/scanbot/sdk/entity/Language;", "getInstalledLanguages", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$OcrConfig;", "ocrConfig", "", "setOcrConfig", "Lio/scanbot/sdk/entity/Document;", "b", "a", "Landroid/content/Context;", "Landroid/content/Context;", "context", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "textRecognition", "Lio/scanbot/sdk/blob/BlobManager;", "c", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "d", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$OcrConfig;", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/ocr/process/TextRecognition;Lio/scanbot/sdk/blob/BlobManager;)V", "sdk-ocr_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    @NotNull
    public final Context a;
    @NotNull
    public final TextRecognition b;
    @NotNull
    public final BlobManager c;
    @NotNull
    public OpticalCharacterRecognizer.OcrConfig d;

    /*
     * WARNING - void declaration
     */
    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull TextRecognition textRecognition, @NotNull BlobManager blobManager) {
        OpticalCharacterRecognizer.OcrConfig ocrConfig;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"textRecognition");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobManager");
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).a = var1_1;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).b = var2_2;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).c = var3_3;
        OpticalCharacterRecognizer.OcrConfig this_ = ocrConfig;
        ocrConfig = new OpticalCharacterRecognizer.OcrConfig(null, null, 3, null);
        v1.d = this_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromBitmap(@NotNull Bitmap bitmap) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.b.onBitmap((Bitmap)var1_1).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted) {
        void var2_2;
        ArrayList<Uri> arrayList;
        Iterator iterator;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        scanbotOpticalCharacterRecognizer.a();
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.b;
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return textRecognition.withoutPDF(arrayList2, (boolean)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.b.withoutPDF((List<Page>)var1_1).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PdfConfig pdfConfig) {
        void var2_2;
        ArrayList<Uri> arrayList;
        void var3_3;
        Iterator iterator;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.b;
        Document document = scanbotOpticalCharacterRecognizer.b();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return textRecognition.withPDF(document, arrayList2, (boolean)var2_2, (PdfConfig)var3_3).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PdfConfig pdfConfig) {
        void var2_2;
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.b.withPDF(this.b(), (List<Page>)var1_1, (PdfConfig)var2_2).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.c.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.c.getAllLanguagesWithAvailableOcrBlobs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOcrConfig(@NotNull OpticalCharacterRecognizer.OcrConfig ocrConfig) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"ocrConfig");
        this.d = v0;
        this.b.setOcrConfig((OpticalCharacterRecognizer.OcrConfig)var1_1);
    }

    public final Document b() {
        Document document;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = document;
        document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        document.id = string;
        document.name = ((Document)scanbotOpticalCharacterRecognizer).id + ".pdf";
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    public final void a() {
        if (((ScanbotOpticalCharacterRecognizer)((Object)this_)).d.getEngineMode() == OpticalCharacterRecognizer.EngineMode.TLDR) {
            return;
        }
        Set this_ = SetsKt.minus(((ScanbotOpticalCharacterRecognizer)((Object)this_)).d.getLanguages(), ((ScanbotOpticalCharacterRecognizer)((Object)this_)).getInstalledLanguages());
        if (!(this_.isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException(this_ + " Provided set of languages was not presented on device");
    }
}

