/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.SandwichingPdfOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.TesseractOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.TldrOcrPerformer;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognizer;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0004QRSTB_\u0012\u0006\u0010%\u001a\u00020#\u0012\u0006\u0010(\u001a\u00020&\u0012\u0006\u0010,\u001a\u00020)\u0012\u0006\u00100\u001a\u00020-\u0012\u0006\u00104\u001a\u000201\u0012\u0006\u00108\u001a\u000205\u0012\u0006\u0010<\u001a\u000209\u0012\u0006\u0010@\u001a\u00020=\u0012\u0006\u0010D\u001a\u00020A\u0012\u0006\u0010H\u001a\u00020E\u0012\u0006\u0010L\u001a\u00020I\u00a2\u0006\u0004\bO\u0010PJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u001e\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016J\u0016\u0010\u000e\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0016J&\u0010\u0011\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0012\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u001e\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0014\u0010%\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010$R\u0014\u0010(\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010'R\u0014\u0010,\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u00100\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00108\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u0010<\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010@\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010D\u001a\u00020A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010H\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0014\u0010L\u001a\u00020I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010N\u00a8\u0006U"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "Landroid/graphics/Bitmap;", "bitmap", "Lio/scanbot/sdk/ocr/process/OcrResult;", "recognizeTextFromBitmap", "", "Landroid/net/Uri;", "imageFileUris", "", "sourceFilesEncrypted", "recognizeTextFromUris", "Lio/scanbot/sdk/persistence/Page;", "pages", "recognizeTextFromPages", "Lio/scanbot/pdf/model/PdfConfig;", "pdfConfig", "recognizeTextWithPdfFromUris", "recognizeTextWithPdfFromPages", "Ljava/io/File;", "getLanguageDataPath", "", "Lio/scanbot/sdk/entity/Language;", "getInstalledLanguages", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$OcrConfig;", "ocrConfig", "", "setOcrConfig", "Lio/scanbot/sdk/entity/Document;", "b", "a", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "recognizerInput", "languages", "Lio/scanbot/sdk/ocr/process/TextRecognizer;", "Landroid/content/Context;", "Landroid/content/Context;", "context", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sap/SapManager;", "c", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "d", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "pdfRenderer", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "e", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "documentStoreStrategy", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "f", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "g", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/PageFileStorage;", "h", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "i", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "fileIOProcessor", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "j", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "k", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "bitmapBinarizer", "l", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$OcrConfig;", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;)V", "BitmapInput", "PagesInput", "RecognizerInput", "UrisInput", "sdk-ocr_release"})
@SourceDebugExtension(value={"SMAP\nScanbotOpticalCharacterRecognizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotOpticalCharacterRecognizer.kt\nio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,2:202\n1622#2:205\n1549#2:206\n1620#2,2:207\n1622#2:210\n36#3:204\n36#3:209\n*S KotlinDebug\n*F\n+ 1 ScanbotOpticalCharacterRecognizer.kt\nio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer\n*L\n56#1:201\n56#1:202,2\n56#1:205\n85#1:206\n85#1:207,2\n85#1:210\n56#1:204\n85#1:209\n*E\n"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    @NotNull
    public final Context a;
    @NotNull
    public final BlobManager b;
    @NotNull
    public final SapManager c;
    @NotNull
    public final OcrPdfRenderer d;
    @NotNull
    public final DocumentStoreStrategy e;
    @NotNull
    public final SimpleComposer f;
    @NotNull
    public final BlobStoreStrategy g;
    @NotNull
    public final PageFileStorage h;
    @NotNull
    public final FileIOProcessor i;
    @NotNull
    public final OcrSettings j;
    @NotNull
    public final OcrPdfRenderer.BitmapBinarizer k;
    @NotNull
    public OpticalCharacterRecognizer.OcrConfig l;

    /*
     * WARNING - void declaration
     */
    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull BlobManager blobManager, @NotNull SapManager sapManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        OpticalCharacterRecognizer.OcrConfig ocrConfig;
        void var11_11;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var10_10, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var11_11, (String)"bitmapBinarizer");
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).a = var1_1;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).b = var2_2;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).c = var3_3;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).d = var4_4;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).e = var5_5;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).f = var6_6;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).g = var7_7;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).h = var8_8;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).i = var9_9;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).j = var10_10;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).k = var11_11;
        OpticalCharacterRecognizer.OcrConfig this_ = ocrConfig;
        ocrConfig = new OpticalCharacterRecognizer.OcrConfig(null, null, 3, null);
        v1.l = this_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromBitmap(@NotNull Bitmap bitmap) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.a(new BitmapInput((Bitmap)var1_1, null, null, 6, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted) {
        void var2_2;
        ArrayList<Uri> arrayList;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        this.a();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return this.a(new UrisInput(arrayList2, (boolean)var2_2, null, null, 12, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.a(new PagesInput((List)var1_1, null, null, 6, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PdfConfig pdfConfig) {
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer;
        void var2_2;
        UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var3_3;
        UrisInput urisInput2;
        Object object;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = object;
        Intrinsics.checkNotNullParameter((Object)urisInput2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        SapManager sapManager = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)urisInput2), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)object.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        object = object.l.getEngineMode();
        urisInput2 = urisInput;
        urisInput = new UrisInput(arrayList2, (boolean)var2_2, (OpticalCharacterRecognizer.EngineMode)((Object)object), (PdfConfig)var3_3);
        object = sandwichingPdfOcrPerformer;
        sandwichingPdfOcrPerformer = new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, urisInput2);
        return new TextRecognizer((OcrPerformer)object).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PdfConfig pdfConfig) {
        PagesInput pagesInput;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        this.a();
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Object object = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        SapManager sapManager = object;
        object = pagesInput;
        pagesInput = new PagesInput((List<Page>)var1_1, this.l.getEngineMode(), (PdfConfig)var2_2);
        return new TextRecognizer(new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, (RecognizerInput)object)).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.b.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.b.getAllLanguagesWithAvailableOcrBlobs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOcrConfig(@NotNull OpticalCharacterRecognizer.OcrConfig ocrConfig) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrConfig");
        this.l = var1_1;
    }

    public final Document b() {
        Document document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        document.id = string;
        document.name = (String)string + ".pdf";
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    public final void a() {
        if (((ScanbotOpticalCharacterRecognizer)((Object)this_)).l.getEngineMode() == OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR) {
            return;
        }
        Set this_ = SetsKt.minus(((ScanbotOpticalCharacterRecognizer)((Object)this_)).l.getLanguages(), ((ScanbotOpticalCharacterRecognizer)((Object)this_)).getInstalledLanguages());
        if (!(this_.isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException((Set)this_ + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TextRecognizer a(RecognizerInput recognizerInput, Set<? extends Language> languages) {
        void var2_5;
        void var1_1;
        ScanbotOpticalCharacterRecognizer this_;
        int n = WhenMappings.$EnumSwitchMapping$0[this_.l.getEngineMode().ordinal()];
        if (n != 1) {
            TldrOcrPerformer tldrOcrPerformer;
            if (n != 2) throw new NoWhenBranchMatchedException();
            TldrOcrPerformer tldrOcrPerformer2 = tldrOcrPerformer;
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this_;
            this_ = scanbotOpticalCharacterRecognizer.c;
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.h;
            FileIOProcessor fileIOProcessor = scanbotOpticalCharacterRecognizer.i;
            OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
            OcrPdfRenderer.BitmapBinarizer bitmapBinarizer = scanbotOpticalCharacterRecognizer.k;
            tldrOcrPerformer = new TldrOcrPerformer((SapManager)this_, pageFileStorage, fileIOProcessor, ocrSettings, bitmapBinarizer, (RecognizerInput)var1_1);
            return new TextRecognizer((OcrPerformer)var2_5);
        } else {
            void var2_2;
            TesseractOcrPerformer tesseractOcrPerformer;
            TesseractOcrPerformer tesseractOcrPerformer2 = tesseractOcrPerformer;
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this_;
            this_ = scanbotOpticalCharacterRecognizer.c;
            BlobStoreStrategy blobStoreStrategy = scanbotOpticalCharacterRecognizer.g;
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.h;
            FileIOProcessor fileIOProcessor = scanbotOpticalCharacterRecognizer.i;
            OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
            OcrPdfRenderer.BitmapBinarizer bitmapBinarizer = scanbotOpticalCharacterRecognizer.k;
            tesseractOcrPerformer = new TesseractOcrPerformer((SapManager)this_, (Set<? extends Language>)var2_2, blobStoreStrategy, pageFileStorage, fileIOProcessor, ocrSettings, bitmapBinarizer, (RecognizerInput)var1_1);
            TesseractOcrPerformer tesseractOcrPerformer3 = tesseractOcrPerformer2;
        }
        return new TextRecognizer((OcrPerformer)var2_5);
    }

    @Metadata(mv={1, 8, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b%\u0010&J\t\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0005\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J)\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\t\u0010\r\u001a\u00020\fH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010$\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "Landroid/graphics/Bitmap;", "component1", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "component2", "Lio/scanbot/pdf/model/PdfConfig;", "component3", "bitmap", "engineMode", "pdfConfig", "copy", "", "toString", "", "hashCode", "", "other", "", "equals", "a", "Landroid/graphics/Bitmap;", "getBitmap", "()Landroid/graphics/Bitmap;", "b", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "c", "Lio/scanbot/pdf/model/PdfConfig;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "d", "I", "getSize", "()I", "size", "<init>", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;)V", "sdk-ocr_release"})
    public static final class BitmapInput
    extends RecognizerInput {
        @NotNull
        public final Bitmap a;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode b;
        @Nullable
        public final PdfConfig c;
        public final int d;

        /*
         * WARNING - void declaration
         */
        public BitmapInput(@NotNull Bitmap bitmap, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = 1;
        }

        public /* synthetic */ BitmapInput(Bitmap bitmap, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfig = null;
            }
            this(bitmap, engineMode, pdfConfig);
        }

        public static /* synthetic */ BitmapInput copy$default(BitmapInput bitmapInput, Bitmap bitmap, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = bitmapInput.a;
            }
            if ((n & 2) != 0) {
                engineMode = bitmapInput.b;
            }
            if ((n & 4) != 0) {
                pdfConfig = bitmapInput.c;
            }
            return bitmapInput.copy(bitmap, engineMode, pdfConfig);
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.a;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.b;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.c;
        }

        @Override
        public int getSize() {
            return this.d;
        }

        @NotNull
        public final Bitmap component1() {
            return this.a;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component2() {
            return this.b;
        }

        @Nullable
        public final PdfConfig component3() {
            return this.c;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BitmapInput copy(@NotNull Bitmap bitmap, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new BitmapInput((Bitmap)var1_1, (OpticalCharacterRecognizer.EngineMode)var2_2, (PdfConfig)var3_3);
        }

        @NotNull
        public String toString() {
            BitmapInput bitmapInput = this_;
            Object this_ = bitmapInput.b;
            return "BitmapInput(bitmap=" + this_.a + ", engineMode=" + (OpticalCharacterRecognizer.EngineMode)((Object)this_) + ", pdfConfig=" + bitmapInput.c + ")";
        }

        public int hashCode() {
            BitmapInput bitmapInput = this;
            int n = bitmapInput.a.hashCode() * 31;
            n = (((Object)((Object)bitmapInput.b)).hashCode() + n) * 31;
            PdfConfig pdfConfig = bitmapInput.c;
            int n2 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            return n + n2;
        }

        public boolean equals(@Nullable Object other) {
            BitmapInput bitmapInput;
            if (this == bitmapInput) {
                return true;
            }
            if (!(bitmapInput instanceof BitmapInput)) {
                return false;
            }
            bitmapInput = bitmapInput;
            if (!Intrinsics.areEqual((Object)this.a, (Object)bitmapInput.a)) {
                return false;
            }
            if (this.b != bitmapInput.b) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.c, (Object)bitmapInput.c);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003J\t\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\n\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "", "Lio/scanbot/sdk/persistence/Page;", "component1", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "component2", "Lio/scanbot/pdf/model/PdfConfig;", "component3", "pages", "engineMode", "pdfConfig", "copy", "", "toString", "", "hashCode", "", "other", "", "equals", "a", "Ljava/util/List;", "getPages", "()Ljava/util/List;", "b", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "c", "Lio/scanbot/pdf/model/PdfConfig;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "getSize", "()I", "size", "<init>", "(Ljava/util/List;Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;)V", "sdk-ocr_release"})
    public static final class PagesInput
    extends RecognizerInput {
        @NotNull
        public final List<Page> a;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode b;
        @Nullable
        public final PdfConfig c;

        /*
         * WARNING - void declaration
         */
        public PagesInput(@NotNull List<Page> pages, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public /* synthetic */ PagesInput(List list, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfig = null;
            }
            this(list, engineMode, pdfConfig);
        }

        public static /* synthetic */ PagesInput copy$default(PagesInput pagesInput, List list, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, Object object) {
            if ((n & 1) != 0) {
                list = pagesInput.a;
            }
            if ((n & 2) != 0) {
                engineMode = pagesInput.b;
            }
            if ((n & 4) != 0) {
                pdfConfig = pagesInput.c;
            }
            return pagesInput.copy(list, engineMode, pdfConfig);
        }

        @NotNull
        public final List<Page> getPages() {
            return this.a;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.b;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.c;
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @NotNull
        public final List<Page> component1() {
            return this.a;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component2() {
            return this.b;
        }

        @Nullable
        public final PdfConfig component3() {
            return this.c;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PagesInput copy(@NotNull List<Page> pages, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new PagesInput((List<Page>)var1_1, (OpticalCharacterRecognizer.EngineMode)var2_2, (PdfConfig)var3_3);
        }

        @NotNull
        public String toString() {
            PagesInput pagesInput = this_;
            Object this_ = pagesInput.b;
            return "PagesInput(pages=" + this_.a + ", engineMode=" + (OpticalCharacterRecognizer.EngineMode)((Object)this_) + ", pdfConfig=" + pagesInput.c + ")";
        }

        public int hashCode() {
            PagesInput pagesInput = this;
            int n = ((Object)pagesInput.a).hashCode() * 31;
            n = (((Object)((Object)pagesInput.b)).hashCode() + n) * 31;
            PdfConfig pdfConfig = pagesInput.c;
            int n2 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            return n + n2;
        }

        public boolean equals(@Nullable Object other) {
            PagesInput pagesInput;
            if (this == pagesInput) {
                return true;
            }
            if (!(pagesInput instanceof PagesInput)) {
                return false;
            }
            pagesInput = pagesInput;
            if (!Intrinsics.areEqual(this.a, pagesInput.a)) {
                return false;
            }
            if (this.b != pagesInput.b) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.c, (Object)pagesInput.c);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "", "()V", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "size", "", "getSize", "()I", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$UrisInput;", "sdk-ocr_release"})
    public static abstract class RecognizerInput {
        public RecognizerInput() {
        }

        public /* synthetic */ RecognizerInput(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public abstract int getSize();

        @NotNull
        public abstract OpticalCharacterRecognizer.EngineMode getEngineMode();

        @Nullable
        public abstract PdfConfig getPdfConfig();
    }

    @Metadata(mv={1, 8, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0018\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003J\t\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\b\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0003J9\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\r\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$UrisInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "", "Landroid/net/Uri;", "component1", "", "component2", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "component3", "Lio/scanbot/pdf/model/PdfConfig;", "component4", "uris", "encryptedInput", "engineMode", "pdfConfig", "copy", "", "toString", "", "hashCode", "", "other", "equals", "a", "Ljava/util/List;", "getUris", "()Ljava/util/List;", "b", "Z", "getEncryptedInput", "()Z", "c", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "d", "Lio/scanbot/pdf/model/PdfConfig;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "getSize", "()I", "size", "<init>", "(Ljava/util/List;ZLio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;)V", "sdk-ocr_release"})
    public static final class UrisInput
    extends RecognizerInput {
        @NotNull
        public final List<Uri> a;
        public final boolean b;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode c;
        @Nullable
        public final PdfConfig d;

        /*
         * WARNING - void declaration
         */
        public UrisInput(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var4_4;
            void var2_2;
            void var3_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
        }

        public /* synthetic */ UrisInput(List list, boolean bl, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 8) != 0) {
                pdfConfig = null;
            }
            this(list, bl, engineMode, pdfConfig);
        }

        public static /* synthetic */ UrisInput copy$default(UrisInput urisInput, List list, boolean bl, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, int n, Object object) {
            if ((n & 1) != 0) {
                list = urisInput.a;
            }
            if ((n & 2) != 0) {
                bl = urisInput.b;
            }
            if ((n & 4) != 0) {
                engineMode = urisInput.c;
            }
            if ((n & 8) != 0) {
                pdfConfig = urisInput.d;
            }
            return urisInput.copy(list, bl, engineMode, pdfConfig);
        }

        @NotNull
        public final List<Uri> getUris() {
            return this.a;
        }

        public final boolean getEncryptedInput() {
            return this.b;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.c;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.d;
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @NotNull
        public final List<Uri> component1() {
            return this.a;
        }

        public final boolean component2() {
            return this.b;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component3() {
            return this.c;
        }

        @Nullable
        public final PdfConfig component4() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UrisInput copy(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new UrisInput((List<? extends Uri>)var1_1, (boolean)var2_2, (OpticalCharacterRecognizer.EngineMode)var3_3, (PdfConfig)var4_4);
        }

        @NotNull
        public String toString() {
            UrisInput urisInput = this;
            boolean bl = urisInput.b;
            OpticalCharacterRecognizer.EngineMode engineMode = urisInput.c;
            PdfConfig pdfConfig = urisInput.d;
            return "UrisInput(uris=" + this.a + ", encryptedInput=" + bl + ", engineMode=" + engineMode + ", pdfConfig=" + pdfConfig + ")";
        }

        public int hashCode() {
            UrisInput urisInput = this;
            int n = ((Object)urisInput.a).hashCode() * 31;
            int n2 = urisInput.b ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            UrisInput urisInput2 = this;
            int n3 = (n + n2) * 31;
            n3 = (((Object)((Object)urisInput2.c)).hashCode() + n3) * 31;
            PdfConfig pdfConfig = urisInput2.d;
            int n4 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            return n3 + n4;
        }

        public boolean equals(@Nullable Object other) {
            UrisInput urisInput;
            if (this == urisInput) {
                return true;
            }
            if (!(urisInput instanceof UrisInput)) {
                return false;
            }
            urisInput = urisInput;
            if (!Intrinsics.areEqual(this.a, urisInput.a)) {
                return false;
            }
            if (this.b != urisInput.b) {
                return false;
            }
            if (this.c != urisInput.c) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.d, (Object)urisInput.d);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OpticalCharacterRecognizer.EngineMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[OpticalCharacterRecognizer.EngineMode.TESSERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

