/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.Page;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.SandwichingPdfOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.TesseractOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.TldrOcrPerformer;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognizer;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004?@ABB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u001e\u00101\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030/2\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020*2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J \u00106\u001a\u00020*2\u0006\u00107\u001a\u0002082\u0006\u0010;\u001a\u00020&2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010<\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00109\u001a\u00020:H\u0016J&\u0010<\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010;\u001a\u00020&2\u0006\u00109\u001a\u00020:H\u0016J.\u0010=\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030/2\u0006\u0010;\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020:H\u0016J&\u0010=\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030/2\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "context", "Landroid/content/Context;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "sapManager", "Lio/scanbot/sap/SapManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "(Landroid/content/Context;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;)V", "ocrConfig", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$OcrConfig;", "checkMissingLangs", "", "createTextRecognizer", "Lio/scanbot/sdk/ocr/process/TextRecognizer;", "recognizerInput", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lio/scanbot/sdk/entity/Document;", "recognizeTextFromBitmap", "Lio/scanbot/sdk/ocr/process/OcrResult;", "bitmap", "Landroid/graphics/Bitmap;", "recognizeTextFromPages", "pages", "", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "sourceFilesEncrypted", "", "recognizeTextWithPdfFromDocument", "document", "Lio/scanbot/sdk/docprocessing/Document;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "outputFile", "recognizeTextWithPdfFromPages", "recognizeTextWithPdfFromUris", "setOcrConfig", "BitmapInput", "PagesInput", "RecognizerInput", "UrisInput", "sdk-ocr_release"})
@SourceDebugExtension(value={"SMAP\nScanbotOpticalCharacterRecognizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotOpticalCharacterRecognizer.kt\nio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,307:1\n1549#2:308\n1620#2,2:309\n1622#2:312\n1549#2:313\n1620#2,2:314\n1622#2:317\n1549#2:318\n1620#2,2:319\n1622#2:322\n1549#2:323\n1620#2,3:324\n1549#2:327\n1620#2,3:328\n36#3:311\n36#3:316\n36#3:321\n*S KotlinDebug\n*F\n+ 1 ScanbotOpticalCharacterRecognizer.kt\nio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer\n*L\n61#1:308\n61#1:309,2\n61#1:312\n90#1:313\n90#1:314,2\n90#1:317\n117#1:318\n117#1:319,2\n117#1:322\n180#1:323\n180#1:324,3\n207#1:327\n207#1:328,3\n61#1:311\n90#1:316\n117#1:321\n*E\n"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    @NotNull
    public final Context a;
    @NotNull
    public final BlobManager b;
    @NotNull
    public final SapManager c;
    @NotNull
    public final OcrPdfRenderer d;
    @NotNull
    public final DocumentStoreStrategy e;
    @NotNull
    public final SimpleComposer f;
    @NotNull
    public final BlobStoreStrategy g;
    @NotNull
    public final PageFileStorage h;
    @NotNull
    public final FileIOProcessor i;
    @NotNull
    public final OcrSettings j;
    @NotNull
    public final OcrPdfRenderer.BitmapBinarizer k;
    @NotNull
    public OpticalCharacterRecognizer.OcrConfig l;

    /*
     * WARNING - void declaration
     */
    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull BlobManager blobManager, @NotNull SapManager sapManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        OpticalCharacterRecognizer.OcrConfig ocrConfig;
        void var11_11;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var10_10, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var11_11, (String)"bitmapBinarizer");
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).a = var1_1;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).b = var2_2;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).c = var3_3;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).d = var4_4;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).e = var5_5;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).f = var6_6;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).g = var7_7;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).h = var8_8;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).i = var9_9;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).j = var10_10;
        ((ScanbotOpticalCharacterRecognizer)((Object)this_)).k = var11_11;
        OpticalCharacterRecognizer.OcrConfig this_ = ocrConfig;
        ocrConfig = new OpticalCharacterRecognizer.OcrConfig(null, null, 3, null);
        v1.l = this_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromBitmap(@NotNull Bitmap bitmap) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.a(new BitmapInput((Bitmap)var1_1, null, null, null, 14, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted) {
        void var2_2;
        ArrayList<Uri> arrayList;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        this.a();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return this.a(new UrisInput(arrayList2, (boolean)var2_2, null, null, null, 28, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages) {
        void var1_1;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        scanbotOpticalCharacterRecognizer.a();
        return scanbotOpticalCharacterRecognizer.a(new PagesInput((List)var1_1, null, null, null, 14, null), this.l.getLanguages()).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PdfConfig pdfConfig) {
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer;
        void var2_2;
        UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var3_3;
        UrisInput urisInput2;
        Object object;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = object;
        Intrinsics.checkNotNullParameter((Object)urisInput2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        SapManager sapManager = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)urisInput2), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)object.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        object = object.l.getEngineMode();
        urisInput2 = urisInput;
        urisInput = new UrisInput(arrayList2, (boolean)var2_2, (OpticalCharacterRecognizer.EngineMode)((Object)object), (PdfConfig)var3_3, null, 16, null);
        object = sandwichingPdfOcrPerformer;
        sandwichingPdfOcrPerformer = new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, urisInput2);
        return new TextRecognizer((OcrPerformer)object).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull File outputFile, boolean sourceFilesEncrypted, @NotNull PdfConfig pdfConfig) {
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer;
        void var3_3;
        UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var4_4;
        void var2_2;
        UrisInput urisInput2;
        Object object;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = object;
        Intrinsics.checkNotNullParameter((Object)urisInput2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        SapManager sapManager = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)urisInput2), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)object.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        object = object.l.getEngineMode();
        urisInput2 = urisInput;
        urisInput = new UrisInput(arrayList2, (boolean)var3_3, (OpticalCharacterRecognizer.EngineMode)((Object)object), (PdfConfig)var4_4, (File)var2_2);
        object = sandwichingPdfOcrPerformer;
        sandwichingPdfOcrPerformer = new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, urisInput2);
        return new TextRecognizer((OcrPerformer)object).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull PdfConfig pdfConfig) {
        PagesInput pagesInput;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        this.a();
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Object object = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        SapManager sapManager = object;
        object = pagesInput;
        pagesInput = new PagesInput((List)var1_1, this.l.getEngineMode(), (PdfConfig)var2_2, null, 8, null);
        return new TextRecognizer(new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, (RecognizerInput)object)).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull File outputFile, @NotNull PdfConfig pdfConfig) {
        PagesInput pagesInput;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        this.a();
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Object object = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document = scanbotOpticalCharacterRecognizer.b();
        SapManager sapManager = object;
        object = pagesInput;
        pagesInput = new PagesInput((List<io.scanbot.sdk.persistence.page.legacy.Page>)var1_1, this.l.getEngineMode(), (PdfConfig)var3_3, (File)var2_2);
        return new TextRecognizer(new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document, (RecognizerInput)object)).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document document, @NotNull PdfConfig pdfConfig) {
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer;
        UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var2_4;
        OpticalCharacterRecognizer.EngineMode engineMode;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        SapManager sapManager = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document2 = scanbotOpticalCharacterRecognizer.b();
        Object object = document.getPages();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getDocumentFileUri());
        }
        void v2 = engineMode;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer2 = this;
        boolean bl = scanbotOpticalCharacterRecognizer2.i.getUseEncryption();
        engineMode = scanbotOpticalCharacterRecognizer2.l.getEngineMode();
        object = UriKt.toFile((Uri)v2.getPdfUri());
        UrisInput urisInput2 = urisInput;
        urisInput = new UrisInput(arrayList2, bl, engineMode, (PdfConfig)var2_4, (File)object);
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer2 = sandwichingPdfOcrPerformer;
        sandwichingPdfOcrPerformer = new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document2, urisInput2);
        return new TextRecognizer(sandwichingPdfOcrPerformer2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document document, @NotNull File outputFile, @NotNull PdfConfig pdfConfig) {
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer;
        UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var3_5;
        void var2_4;
        SapManager sapManager;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_5, (String)"pdfConfig");
        scanbotOpticalCharacterRecognizer.a();
        sapManager = scanbotOpticalCharacterRecognizer.c;
        OcrPdfRenderer ocrPdfRenderer = scanbotOpticalCharacterRecognizer.d;
        Set<Language> set = scanbotOpticalCharacterRecognizer.l.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotOpticalCharacterRecognizer.e;
        SimpleComposer simpleComposer = scanbotOpticalCharacterRecognizer.f;
        OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
        Document document2 = scanbotOpticalCharacterRecognizer.b();
        Object object = document.getPages();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getDocumentFileUri());
        }
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer2 = this;
        boolean bl = scanbotOpticalCharacterRecognizer2.i.getUseEncryption();
        object = scanbotOpticalCharacterRecognizer2.l.getEngineMode();
        UrisInput urisInput2 = urisInput;
        urisInput = new UrisInput(arrayList2, bl, (OpticalCharacterRecognizer.EngineMode)((Object)object), (PdfConfig)var3_5, (File)var2_4);
        SandwichingPdfOcrPerformer sandwichingPdfOcrPerformer2 = sandwichingPdfOcrPerformer;
        sandwichingPdfOcrPerformer = new SandwichingPdfOcrPerformer(sapManager, ocrPdfRenderer, set, documentStoreStrategy, simpleComposer, ocrSettings, document2, urisInput2);
        return new TextRecognizer(sandwichingPdfOcrPerformer2).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.b.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.b.getAllLanguagesWithAvailableOcrBlobs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOcrConfig(@NotNull OpticalCharacterRecognizer.OcrConfig ocrConfig) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrConfig");
        this.l = var1_1;
    }

    public final Document b() {
        Document document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        document.id = string;
        document.name = (String)string + ".pdf";
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    public final void a() {
        if (((ScanbotOpticalCharacterRecognizer)((Object)this_)).l.getEngineMode() == OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR) {
            return;
        }
        Set this_ = SetsKt.minus(((ScanbotOpticalCharacterRecognizer)((Object)this_)).l.getLanguages(), ((ScanbotOpticalCharacterRecognizer)((Object)this_)).getInstalledLanguages());
        if (!(this_.isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException((Set)this_ + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TextRecognizer a(RecognizerInput recognizerInput, Set<? extends Language> languages) {
        void var2_5;
        void var1_1;
        ScanbotOpticalCharacterRecognizer this_;
        int n = WhenMappings.$EnumSwitchMapping$0[this_.l.getEngineMode().ordinal()];
        if (n != 1) {
            TldrOcrPerformer tldrOcrPerformer;
            if (n != 2) throw new NoWhenBranchMatchedException();
            TldrOcrPerformer tldrOcrPerformer2 = tldrOcrPerformer;
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this_;
            this_ = scanbotOpticalCharacterRecognizer.c;
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.h;
            FileIOProcessor fileIOProcessor = scanbotOpticalCharacterRecognizer.i;
            OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
            OcrPdfRenderer.BitmapBinarizer bitmapBinarizer = scanbotOpticalCharacterRecognizer.k;
            tldrOcrPerformer = new TldrOcrPerformer((SapManager)this_, pageFileStorage, fileIOProcessor, ocrSettings, bitmapBinarizer, (RecognizerInput)var1_1);
            return new TextRecognizer((OcrPerformer)var2_5);
        } else {
            void var2_2;
            TesseractOcrPerformer tesseractOcrPerformer;
            TesseractOcrPerformer tesseractOcrPerformer2 = tesseractOcrPerformer;
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this_;
            this_ = scanbotOpticalCharacterRecognizer.c;
            BlobStoreStrategy blobStoreStrategy = scanbotOpticalCharacterRecognizer.g;
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.h;
            FileIOProcessor fileIOProcessor = scanbotOpticalCharacterRecognizer.i;
            OcrSettings ocrSettings = scanbotOpticalCharacterRecognizer.j;
            OcrPdfRenderer.BitmapBinarizer bitmapBinarizer = scanbotOpticalCharacterRecognizer.k;
            tesseractOcrPerformer = new TesseractOcrPerformer((SapManager)this_, (Set<? extends Language>)var2_2, blobStoreStrategy, pageFileStorage, fileIOProcessor, ocrSettings, bitmapBinarizer, (RecognizerInput)var1_1);
            TesseractOcrPerformer tesseractOcrPerformer3 = tesseractOcrPerformer2;
        }
        return new TextRecognizer((OcrPerformer)var2_5);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0014H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "bitmap", "Landroid/graphics/Bitmap;", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "outputFile", "Ljava/io/File;", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;Ljava/io/File;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getOutputFile", "()Ljava/io/File;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class BitmapInput
    extends RecognizerInput {
        @NotNull
        public final Bitmap a;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode b;
        @Nullable
        public final PdfConfig c;
        @Nullable
        public final File d;
        public final int e;

        /*
         * WARNING - void declaration
         */
        public BitmapInput(@NotNull Bitmap bitmap, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
            this.e = 1;
        }

        public /* synthetic */ BitmapInput(Bitmap bitmap, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfig = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            this(bitmap, engineMode, pdfConfig, file);
        }

        public static /* synthetic */ BitmapInput copy$default(BitmapInput bitmapInput, Bitmap bitmap, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = bitmapInput.a;
            }
            if ((n & 2) != 0) {
                engineMode = bitmapInput.b;
            }
            if ((n & 4) != 0) {
                pdfConfig = bitmapInput.c;
            }
            if ((n & 8) != 0) {
                file = bitmapInput.d;
            }
            return bitmapInput.copy(bitmap, engineMode, pdfConfig, file);
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.a;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.b;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.c;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.d;
        }

        @Override
        public int getSize() {
            return this.e;
        }

        @NotNull
        public final Bitmap component1() {
            return this.a;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component2() {
            return this.b;
        }

        @Nullable
        public final PdfConfig component3() {
            return this.c;
        }

        @Nullable
        public final File component4() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BitmapInput copy(@NotNull Bitmap bitmap, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new BitmapInput((Bitmap)var1_1, (OpticalCharacterRecognizer.EngineMode)var2_2, (PdfConfig)var3_3, (File)var4_4);
        }

        @NotNull
        public String toString() {
            BitmapInput bitmapInput = this_;
            Object this_ = bitmapInput.b;
            PdfConfig pdfConfig = bitmapInput.c;
            File file = bitmapInput.d;
            return "BitmapInput(bitmap=" + this_.a + ", engineMode=" + (OpticalCharacterRecognizer.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfig + ", outputFile=" + file + ")";
        }

        public int hashCode() {
            BitmapInput bitmapInput = this;
            int n = bitmapInput.a.hashCode() * 31;
            n = (((Object)((Object)bitmapInput.b)).hashCode() + n) * 31;
            PdfConfig pdfConfig = bitmapInput.c;
            int n2 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            int n3 = (n + n2) * 31;
            File file = this.d;
            int n4 = file == null ? 0 : file.hashCode();
            return n3 + n4;
        }

        public boolean equals(@Nullable Object other) {
            BitmapInput bitmapInput;
            if (this == bitmapInput) {
                return true;
            }
            if (!(bitmapInput instanceof BitmapInput)) {
                return false;
            }
            bitmapInput = bitmapInput;
            if (!Intrinsics.areEqual((Object)this.a, (Object)bitmapInput.a)) {
                return false;
            }
            if (this.b != bitmapInput.b) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.c, (Object)bitmapInput.c)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.d, (Object)bitmapInput.d);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "pages", "", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "outputFile", "Ljava/io/File;", "(Ljava/util/List;Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;Ljava/io/File;)V", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getOutputFile", "()Ljava/io/File;", "getPages", "()Ljava/util/List;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "size", "", "getSize", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class PagesInput
    extends RecognizerInput {
        @NotNull
        public final List<io.scanbot.sdk.persistence.page.legacy.Page> a;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode b;
        @Nullable
        public final PdfConfig c;
        @Nullable
        public final File d;

        /*
         * WARNING - void declaration
         */
        public PagesInput(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
        }

        public /* synthetic */ PagesInput(List list, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 4) != 0) {
                pdfConfig = null;
            }
            if ((n & 8) != 0) {
                file = null;
            }
            this(list, engineMode, pdfConfig, file);
        }

        public static /* synthetic */ PagesInput copy$default(PagesInput pagesInput, List list, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, Object object) {
            if ((n & 1) != 0) {
                list = pagesInput.a;
            }
            if ((n & 2) != 0) {
                engineMode = pagesInput.b;
            }
            if ((n & 4) != 0) {
                pdfConfig = pagesInput.c;
            }
            if ((n & 8) != 0) {
                file = pagesInput.d;
            }
            return pagesInput.copy(list, engineMode, pdfConfig, file);
        }

        @NotNull
        public final List<io.scanbot.sdk.persistence.page.legacy.Page> getPages() {
            return this.a;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.b;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.c;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.d;
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @NotNull
        public final List<io.scanbot.sdk.persistence.page.legacy.Page> component1() {
            return this.a;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component2() {
            return this.b;
        }

        @Nullable
        public final PdfConfig component3() {
            return this.c;
        }

        @Nullable
        public final File component4() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PagesInput copy(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new PagesInput((List<io.scanbot.sdk.persistence.page.legacy.Page>)var1_1, (OpticalCharacterRecognizer.EngineMode)var2_2, (PdfConfig)var3_3, (File)var4_4);
        }

        @NotNull
        public String toString() {
            PagesInput pagesInput = this_;
            Object this_ = pagesInput.b;
            PdfConfig pdfConfig = pagesInput.c;
            File file = pagesInput.d;
            return "PagesInput(pages=" + this_.a + ", engineMode=" + (OpticalCharacterRecognizer.EngineMode)((Object)this_) + ", pdfConfig=" + pdfConfig + ", outputFile=" + file + ")";
        }

        public int hashCode() {
            PagesInput pagesInput = this;
            int n = ((Object)pagesInput.a).hashCode() * 31;
            n = (((Object)((Object)pagesInput.b)).hashCode() + n) * 31;
            PdfConfig pdfConfig = pagesInput.c;
            int n2 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            int n3 = (n + n2) * 31;
            File file = this.d;
            int n4 = file == null ? 0 : file.hashCode();
            return n3 + n4;
        }

        public boolean equals(@Nullable Object other) {
            PagesInput pagesInput;
            if (this == pagesInput) {
                return true;
            }
            if (!(pagesInput instanceof PagesInput)) {
                return false;
            }
            pagesInput = pagesInput;
            if (!Intrinsics.areEqual(this.a, pagesInput.a)) {
                return false;
            }
            if (this.b != pagesInput.b) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.c, (Object)pagesInput.c)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.d, (Object)pagesInput.d);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "", "()V", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "size", "", "getSize", "()I", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$BitmapInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$PagesInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$UrisInput;", "sdk-ocr_release"})
    public static abstract class RecognizerInput {
        public RecognizerInput() {
        }

        public /* synthetic */ RecognizerInput(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public abstract int getSize();

        @NotNull
        public abstract OpticalCharacterRecognizer.EngineMode getEngineMode();

        @Nullable
        public abstract PdfConfig getPdfConfig();

        @Nullable
        public abstract File getOutputFile();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\fH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0017H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$UrisInput;", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "uris", "", "Landroid/net/Uri;", "encryptedInput", "", "engineMode", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfig;", "outputFile", "Ljava/io/File;", "(Ljava/util/List;ZLio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;Lio/scanbot/pdf/model/PdfConfig;Ljava/io/File;)V", "getEncryptedInput", "()Z", "getEngineMode", "()Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer$EngineMode;", "getOutputFile", "()Ljava/io/File;", "getPdfConfig", "()Lio/scanbot/pdf/model/PdfConfig;", "size", "", "getSize", "()I", "getUris", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "", "sdk-ocr_release"})
    public static final class UrisInput
    extends RecognizerInput {
        @NotNull
        public final List<Uri> a;
        public final boolean b;
        @NotNull
        public final OpticalCharacterRecognizer.EngineMode c;
        @Nullable
        public final PdfConfig d;
        @Nullable
        public final File e;

        /*
         * WARNING - void declaration
         */
        public UrisInput(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var3_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"engineMode");
            super(null);
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
            this.e = var5_5;
        }

        public /* synthetic */ UrisInput(List list, boolean bl, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                engineMode = OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR;
            }
            if ((n & 8) != 0) {
                pdfConfig = null;
            }
            if ((n & 0x10) != 0) {
                file = null;
            }
            this(list, bl, engineMode, pdfConfig, file);
        }

        public static /* synthetic */ UrisInput copy$default(UrisInput urisInput, List list, boolean bl, OpticalCharacterRecognizer.EngineMode engineMode, PdfConfig pdfConfig, File file, int n, Object object) {
            if ((n & 1) != 0) {
                list = urisInput.a;
            }
            if ((n & 2) != 0) {
                bl = urisInput.b;
            }
            if ((n & 4) != 0) {
                engineMode = urisInput.c;
            }
            if ((n & 8) != 0) {
                pdfConfig = urisInput.d;
            }
            if ((n & 0x10) != 0) {
                file = urisInput.e;
            }
            return urisInput.copy(list, bl, engineMode, pdfConfig, file);
        }

        @NotNull
        public final List<Uri> getUris() {
            return this.a;
        }

        public final boolean getEncryptedInput() {
            return this.b;
        }

        @Override
        @NotNull
        public OpticalCharacterRecognizer.EngineMode getEngineMode() {
            return this.c;
        }

        @Override
        @Nullable
        public PdfConfig getPdfConfig() {
            return this.d;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return this.e;
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @NotNull
        public final List<Uri> component1() {
            return this.a;
        }

        public final boolean component2() {
            return this.b;
        }

        @NotNull
        public final OpticalCharacterRecognizer.EngineMode component3() {
            return this.c;
        }

        @Nullable
        public final PdfConfig component4() {
            return this.d;
        }

        @Nullable
        public final File component5() {
            return this.e;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UrisInput copy(@NotNull List<? extends Uri> uris, boolean encryptedInput, @NotNull OpticalCharacterRecognizer.EngineMode engineMode, @Nullable PdfConfig pdfConfig, @Nullable File outputFile) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uris");
            Intrinsics.checkNotNullParameter((Object)((Object)engineMode), (String)"engineMode");
            return new UrisInput((List<? extends Uri>)var1_1, (boolean)var2_2, (OpticalCharacterRecognizer.EngineMode)var3_3, (PdfConfig)var4_4, (File)var5_5);
        }

        @NotNull
        public String toString() {
            UrisInput urisInput = this;
            boolean bl = urisInput.b;
            OpticalCharacterRecognizer.EngineMode engineMode = urisInput.c;
            PdfConfig pdfConfig = urisInput.d;
            File file = urisInput.e;
            return "UrisInput(uris=" + this.a + ", encryptedInput=" + bl + ", engineMode=" + engineMode + ", pdfConfig=" + pdfConfig + ", outputFile=" + file + ")";
        }

        public int hashCode() {
            UrisInput urisInput = this;
            int n = ((Object)urisInput.a).hashCode() * 31;
            n = (Boolean.hashCode(urisInput.b) + n) * 31;
            n = (((Object)((Object)urisInput.c)).hashCode() + n) * 31;
            PdfConfig pdfConfig = urisInput.d;
            int n2 = pdfConfig == null ? 0 : pdfConfig.hashCode();
            int n3 = (n + n2) * 31;
            File file = this.e;
            int n4 = file == null ? 0 : file.hashCode();
            return n3 + n4;
        }

        public boolean equals(@Nullable Object other) {
            UrisInput urisInput;
            if (this == urisInput) {
                return true;
            }
            if (!(urisInput instanceof UrisInput)) {
                return false;
            }
            urisInput = urisInput;
            if (!Intrinsics.areEqual(this.a, urisInput.a)) {
                return false;
            }
            if (this.b != urisInput.b) {
                return false;
            }
            if (this.c != urisInput.c) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.d, (Object)urisInput.d)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.e, (Object)urisInput.e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OpticalCharacterRecognizer.EngineMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[OpticalCharacterRecognizer.EngineMode.TESSERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

