/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.googlecode.tesseract.android.TessPdfRenderer;
import io.scanbot.ocr.model.OcrPage;
import io.scanbot.ocr.model.OcrResultBlock;
import io.scanbot.ocr.pdf.TldrPdfRenderer;
import io.scanbot.pdf.model.PdfConfig;
import io.scanbot.sdk.docprocessing.compose.ComposerCache;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.imageprocessing.BitmapAccessException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.ScanbotOpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileType;
import io.scanbot.sdk.persistence.page.legacy.Page;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import io.scanbot.sdk.util.FileUtilsKt;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0005\u001a\u001b\u001c\u001d\u001eB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "composerCache", "Lio/scanbot/sdk/docprocessing/compose/ComposerCache;", "(Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/docprocessing/compose/ComposerCache;)V", "startRender", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "document", "Lio/scanbot/sdk/entity/Document;", "recognizerInput", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "BitmapBinarizer", "Companion", "RenderIterator", "TesseractRenderIteratorImpl", "TldrRenderIteratorImpl", "sdk-ocr_release"})
public final class OcrPdfRenderer {
    @NotNull
    public static final Companion g = new Companion(null);
    @Deprecated
    @NotNull
    public static final String PDF_TEMP_IMAGE_FILE_SUFFIX = "_pdf_image";
    @NotNull
    public final DocumentStoreStrategy a;
    @NotNull
    public final PageFileStorage b;
    @NotNull
    public final BlobStoreStrategy c;
    @NotNull
    public final BitmapBinarizer d;
    @NotNull
    public final FileIOProcessor e;
    @NotNull
    public final ComposerCache f;

    /*
     * WARNING - void declaration
     */
    public OcrPdfRenderer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BitmapBinarizer bitmapBinarizer, @NotNull FileIOProcessor fileIOProcessor, @NotNull ComposerCache composerCache) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"composerCache");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        this.e = var5_5;
        this.f = var6_6;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final RenderIterator startRender(@NotNull Document document, @NotNull ScanbotOpticalCharacterRecognizer.RecognizerInput recognizerInput, @NotNull Collection<? extends Language> languages, @NotNull OcrSettings ocrSettings) throws IOException {
        void var3_6;
        void var4_7;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"recognizerInput");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)var4_7, (String)"ocrSettings");
        int n = WhenMappings.$EnumSwitchMapping$0[recognizerInput.getEngineMode().ordinal()];
        if (n != 1) {
            b b2;
            if (n != 2) throw new NoWhenBranchMatchedException();
            b b3 = b2;
            b2 = new b(this, (Document)var1_1, (ScanbotOpticalCharacterRecognizer.RecognizerInput)var2_2);
            return var3_6;
        } else {
            a a2;
            a a3 = a2;
            a2 = new a(this, (Document)var1_1, (ScanbotOpticalCharacterRecognizer.RecognizerInput)var2_2, (Collection<? extends Language>)var3_3, (OcrSettings)var4_7);
            a a4 = a3;
        }
        return var3_6;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "", "binarizeBitmap", "Landroid/graphics/Bitmap;", "bitmap", "recycle", "", "sdk-ocr_release"})
    public static interface BitmapBinarizer {
        @NotNull
        public Bitmap binarizeBitmap(@NotNull Bitmap var1, boolean var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$Companion;", "", "()V", "PDF_TEMP_IMAGE_FILE_SUFFIX", "", "sdk-ocr_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0016H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "", "detectedLines", "", "Lio/scanbot/ocr/model/OcrResultBlock;", "getDetectedLines", "()Ljava/util/List;", "detectedParagraphs", "getDetectedParagraphs", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "detectedWords", "getDetectedWords", "lastProcessedPosition", "", "getLastProcessedPosition", "()I", "recycle", "", "renderNextPage", "", "sdk-ocr_release"})
    public static interface RenderIterator {
        public boolean renderNextPage() throws IOException;

        @NotNull
        public String getDetectedText();

        @NotNull
        public List<OcrResultBlock> getDetectedParagraphs();

        @NotNull
        public List<OcrResultBlock> getDetectedLines();

        @NotNull
        public List<OcrResultBlock> getDetectedWords();

        public int getLastProcessedPosition();

        public void recycle();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ*\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\r2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0002J&\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u00104\u001a\u00020\r2\u0006\u00107\u001a\u000208H\u0002J\u0016\u0010:\u001a\u00020-2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J\b\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J \u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020#2\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020\u0016H\u0002J\u0010\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020BH\u0016J\b\u0010J\u001a\u00020=H\u0002J\u0018\u0010K\u001a\u00020#2\u0006\u0010E\u001a\u00020\u00162\u0006\u0010D\u001a\u00020#H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$TesseractRenderIteratorImpl;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "document", "Lio/scanbot/sdk/entity/Document;", "recognizerInput", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "languages", "", "Lio/scanbot/sdk/entity/Language;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;Ljava/util/Collection;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "currentPosition", "", "detectedLines", "", "Lio/scanbot/ocr/model/OcrResultBlock;", "getDetectedLines", "()Ljava/util/List;", "detectedParagraphs", "getDetectedParagraphs", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "detectedTextBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDetectedTextBuilder", "()Ljava/lang/StringBuilder;", "setDetectedTextBuilder", "(Ljava/lang/StringBuilder;)V", "detectedWords", "getDetectedWords", "documentFile", "Ljava/io/File;", "getDocumentFile", "()Ljava/io/File;", "lastProcessedPosition", "getLastProcessedPosition", "()I", "lines", "", "paragraphs", "tessBaseAPI", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessPdfRenderer", "Lcom/googlecode/tesseract/android/TessPdfRenderer;", "words", "extractBlock", "resultIterator", "Lcom/googlecode/tesseract/android/ResultIterator;", "pageIteratorLevel", "thresholdedImage", "Lcom/googlecode/leptonica/android/Pix;", "blockType", "Lio/scanbot/ocr/model/OcrResultBlock$OcrResultBlockType;", "getBlocks", "initTessApi", "languageCodes", "recycle", "", "renderFromFileURI", "fileURI", "Landroid/net/Uri;", "useFileIOProcessor", "", "renderFromImageFile", "imageFile", "tempFileName", "renderFromPage", "page", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "renderNextPage", "resetDataHolders", "writePDFTempImageFile", "sdk-ocr_release"})
    public final class a
    implements RenderIterator {
        @NotNull
        public final ScanbotOpticalCharacterRecognizer.RecognizerInput a;
        @NotNull
        public final OcrSettings b;
        @NotNull
        public final TessBaseAPI c;
        @NotNull
        public final TessPdfRenderer d;
        @NotNull
        public List<OcrResultBlock> e;
        @NotNull
        public List<OcrResultBlock> f;
        @NotNull
        public List<OcrResultBlock> g;
        public int h;
        @NotNull
        public StringBuilder i;
        @NotNull
        public final File j;
        public final /* synthetic */ OcrPdfRenderer k;

        /*
         * WARNING - void declaration
         */
        public a(@NotNull OcrPdfRenderer this$0, @NotNull Document document, @NotNull ScanbotOpticalCharacterRecognizer.RecognizerInput recognizerInput, @NotNull Collection<? extends Language> languages, OcrSettings ocrSettings) {
            TessBaseAPI tessBaseAPI;
            void var5_5;
            void var4_4;
            File file;
            Object object;
            a a2 = this;
            Intrinsics.checkNotNullParameter((Object)object, (String)"document");
            Intrinsics.checkNotNullParameter((Object)file, (String)"recognizerInput");
            Intrinsics.checkNotNullParameter((Object)var4_4, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
            this.k = tessBaseAPI;
            this.a = file;
            a2.b = var5_5;
            a2.e = new ArrayList<OcrResultBlock>();
            a2.f = new ArrayList<OcrResultBlock>();
            a2.g = new ArrayList<OcrResultBlock>();
            a2.i = new StringBuilder();
            ((OcrPdfRenderer)((Object)tessBaseAPI)).a.getDocumentDir(((Document)object).id).mkdirs();
            file = recognizerInput.getOutputFile();
            if (file == null) {
                void v1 = object;
                object = v1.id;
                file = ((OcrPdfRenderer)((Object)tessBaseAPI)).a.getDocumentFile((String)object, v1.name);
            }
            void v2 = tessBaseAPI;
            this.j = file;
            this.c = tessBaseAPI = this.a(Language.Companion.languageCodes((Collection)var4_4));
            if (((OcrPdfRenderer)v2).e.getUseEncryption()) {
                TessPdfRenderer tessPdfRenderer;
                object = tessPdfRenderer;
                tessPdfRenderer = new TessPdfRenderer(tessBaseAPI);
            } else {
                TessPdfRenderer tessPdfRenderer;
                object = tessPdfRenderer;
                tessPdfRenderer = new TessPdfRenderer(tessBaseAPI, FileUtilsKt.pathWithoutExtension((File)file));
            }
            this.d = object;
        }

        @NotNull
        public final StringBuilder a() {
            return this.i;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(@NotNull StringBuilder stringBuilder) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.i = var1_1;
        }

        @NotNull
        public final File b() {
            return this.j;
        }

        @Override
        @NotNull
        public String getDetectedText() {
            String string = this.i.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public boolean renderNextPage() throws IOException {
            block10: {
                Object object;
                block9: {
                    block8: {
                        a a2 = this;
                        a2.c();
                        if (a2.h == 0) {
                            this.c.beginDocument(this.d);
                        }
                        if (this.h >= this.a.getSize()) {
                            return false;
                        }
                        object = this.a;
                        if (!(object instanceof ScanbotOpticalCharacterRecognizer.PagesInput)) break block8;
                        this.a(((ScanbotOpticalCharacterRecognizer.PagesInput)object).getPages().get(this.h));
                        break block9;
                    }
                    if (object instanceof ScanbotOpticalCharacterRecognizer.BitmapInput) break block10;
                    if (object instanceof ScanbotOpticalCharacterRecognizer.UrisInput) {
                        this.a(((ScanbotOpticalCharacterRecognizer.UrisInput)object).getUris().get(this.h), ((ScanbotOpticalCharacterRecognizer.UrisInput)this.a).getEncryptedInput());
                    }
                }
                if (this.h == this.a.getSize() - 1) {
                    a a3 = this;
                    a3.c.endDocument(this.d);
                    if (a3.k.e.getUseEncryption()) {
                        FileIOProcessor fileIOProcessor = this.k.e;
                        a a4 = this;
                        byte[] byArray = a4.c.getOutputBuffer(this.d);
                        object = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOutputBuffer(...)");
                        fileIOProcessor.write((byte[])object, a4.j);
                    }
                }
                ++this.h;
                return true;
            }
            throw new IOException("Tesseract based OcrPdfRenderer doesn't support Bitmap as an input source!");
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedParagraphs() {
            return this.e;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedLines() {
            return this.f;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedWords() {
            return this.g;
        }

        @Override
        public int getLastProcessedPosition() {
            return this.h - 1;
        }

        @Override
        public void recycle() {
            a a2 = this;
            a2.k.f.clear();
            a2.c.end();
            a2.d.recycle();
        }

        /*
         * WARNING - void declaration
         */
        public final TessBaseAPI a(List<String> languageCodes) throws IOException {
            void var1_1;
            TessBaseAPI tessBaseAPI = new TessBaseAPI();
            tessBaseAPI.init(this.k.c.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", (Iterable)var1_1));
            tessBaseAPI.setPageSegMode(1);
            return tessBaseAPI;
        }

        public final void c() {
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            StringBuilder stringBuilder;
            a a2 = this_;
            Object this_ = stringBuilder;
            stringBuilder = new StringBuilder();
            a2.i = this_;
            this_ = arrayList3;
            arrayList3 = new ArrayList();
            a2.e = this_;
            this_ = arrayList2;
            arrayList2 = new ArrayList();
            a2.f = this_;
            this_ = arrayList;
            arrayList = new ArrayList();
            a2.g = this_;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(Page page) throws IOException {
            void var1_1;
            File file;
            File file2;
            File file3 = file2;
            File file4 = file;
            file = new File(((a)((Object)string)).k.b.getImageURI(var1_1.getPageId(), PageFileType.ORIGINAL).getPath());
            if (!new File(((a)((Object)string)).k.b.getImageURI(var1_1.getPageId(), PageFileType.DOCUMENT).getPath()).exists()) {
                file3 = file4;
            }
            a a2 = string;
            String string = var1_1.getPageId();
            a2.a(file3, true, string);
        }

        /*
         * WARNING - void declaration
         */
        public final void a(Uri fileURI, boolean useFileIOProcessor) throws IOException {
            void var2_2;
            void var1_1;
            a a2 = this_;
            File file = new File(var1_1.getPath());
            String this_ = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"toString(...)");
            a2.a(file, (boolean)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void a(File imageFile, boolean useFileIOProcessor, String tempFileName) {
            Pix pix;
            Bitmap bitmap;
            Object object;
            void var2_2;
            if (!imageFile.exists()) {
                return;
            }
            if (var2_2 != false) {
                bitmap = ImageFileIOProcessor.DefaultImpls.readImage$default((ImageFileIOProcessor)this.k.e, (File)object, null, (int)2, null);
                if (bitmap == null) {
                    throw new BitmapAccessException("Cannot decode an image for PDF page.");
                }
            } else {
                bitmap = BitmapFactory.decodeFile((String)((File)object).getPath());
            }
            if (this.b.getBinarizeImage()) {
                BitmapBinarizer bitmapBinarizer = this.k.d;
                Bitmap bitmap2 = bitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                Bitmap bitmap3 = bitmapBinarizer.binarizeBitmap(bitmap2, false);
                pix = ReadFile.readBitmap(bitmap3);
                Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
                bitmap3.recycle();
                if (var2_2 != false && this.k.e.getUseEncryption()) {
                    object = ReadFile.readBitmap(bitmap);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readBitmap(...)");
                    this.c.addPageToDocument(pix, (Pix)object, this.d);
                } else {
                    String string;
                    a a2 = this;
                    if (!a2.c.addPageToDocument(pix, string = ((File)(object = a2.a(string, (File)object))).getPath(), this.d)) throw new Error("Failed to render document.");
                    ((File)object).delete();
                }
                bitmap.recycle();
            } else {
                Bitmap bitmap4 = bitmap;
                pix = ReadFile.readBitmap(bitmap4);
                Intrinsics.checkNotNullExpressionValue((Object)pix, (String)"readBitmap(...)");
                bitmap4.recycle();
                if (var2_2 != false && this.k.e.getUseEncryption()) {
                    this.c.addPageToDocument(pix, "", this.d);
                } else {
                    object = ((File)object).getPath();
                    this.c.addPageToDocument(pix, (String)object, this.d);
                }
            }
            a a3 = this;
            a3.i.append(this.c.getUTF8Text());
            a a4 = this;
            a3.e.addAll(a4.a(a4.c, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH));
            a a5 = this;
            a3.f.addAll(a5.a(a5.c, 2, OcrResultBlock.OcrResultBlockType.LINE));
            a a6 = this;
            a3.g.addAll(a6.a(a6.c, 3, OcrResultBlock.OcrResultBlockType.WORD));
            pix.recycle();
        }

        /*
         * WARNING - void declaration
         */
        public final List<OcrResultBlock> a(TessBaseAPI tessBaseAPI, int pageIteratorLevel, OcrResultBlock.OcrResultBlockType blockType) {
            void var3_3;
            void var2_2;
            Pix pix;
            ArrayList<OcrResultBlock> arrayList;
            ArrayList<OcrResultBlock> arrayList2 = arrayList;
            void v1 = pix;
            arrayList2();
            pix = v1.getThresholdedImage();
            ResultIterator resultIterator = v1.getResultIterator();
            resultIterator.begin();
            Intrinsics.checkNotNull((Object)resultIterator);
            arrayList.add(this.a(resultIterator, (int)var2_2, pix, (OcrResultBlock.OcrResultBlockType)var3_3));
            while (resultIterator.next((int)var2_2)) {
                arrayList2.add(this.a(resultIterator, (int)var2_2, pix, (OcrResultBlock.OcrResultBlockType)var3_3));
            }
            return arrayList2;
        }

        /*
         * WARNING - void declaration
         */
        public final OcrResultBlock a(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, OcrResultBlock.OcrResultBlockType blockType) {
            void var4_6;
            RectF rectF;
            Rect rect;
            void var1_1;
            void var2_3;
            Object object = resultIterator.getUTF8Text((int)var2_3);
            if (object == null) {
                object = "";
            }
            int[] nArray = var1_1.getBoundingBox((int)var2_3);
            Rect rect2 = rect;
            rect = new Rect();
            RectF rectF2 = rectF;
            rectF = new RectF();
            if (nArray.length == 4) {
                void var3_4;
                Rect rect3;
                rect2 = rect3;
                int n = nArray[0];
                int n2 = nArray[1];
                int n3 = nArray[2];
                int n4 = nArray[3];
                rect3 = new Rect(n, n2, n3, n4);
                if (var3_4 != null) {
                    RectF rectF3;
                    rectF2 = rectF3;
                    float f = (float)nArray[0] / (float)var3_4.getWidth();
                    float f2 = (float)nArray[1] / (float)var3_4.getHeight();
                    float f3 = (float)nArray[2] / (float)var3_4.getWidth();
                    float f4 = (float)nArray[3] / (float)var3_4.getHeight();
                    rectF3 = new RectF(f, f2, f3, f4);
                }
            }
            float f = var1_1.confidence((int)var2_3);
            return new OcrResultBlock((String)object, rectF2, rect2, f, (OcrResultBlock.OcrResultBlockType)var4_6);
        }

        /*
         * WARNING - void declaration
         */
        public final File a(String tempFileName, File imageFile) throws IOException {
            void var2_2;
            void var1_1;
            Object this_ = ((a)this_).k.f.getCacheDir();
            if (!((File)this_).exists()) {
                ((File)this_).mkdirs();
            }
            this_ = File.createTempFile("scanbot_", (String)var1_1 + OcrPdfRenderer.PDF_TEMP_IMAGE_FILE_SUFFIX, (File)this_);
            Intrinsics.checkNotNull((Object)this_);
            FilesKt.copyTo$default((File)var2_2, (File)this_, (boolean)true, (int)0, (int)4, null);
            return this_;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u0002032\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020 2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020;H\u0016J\b\u0010B\u001a\u000203H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$TldrRenderIteratorImpl;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$RenderIterator;", "document", "Lio/scanbot/sdk/entity/Document;", "recognizerInput", "Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;", "(Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer$RecognizerInput;)V", "currentPosition", "", "detectedLines", "", "Lio/scanbot/ocr/model/OcrResultBlock;", "getDetectedLines", "()Ljava/util/List;", "detectedParagraphs", "getDetectedParagraphs", "detectedText", "", "getDetectedText", "()Ljava/lang/String;", "detectedTextBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDetectedTextBuilder", "()Ljava/lang/StringBuilder;", "setDetectedTextBuilder", "(Ljava/lang/StringBuilder;)V", "detectedWords", "getDetectedWords", "getDocument", "()Lio/scanbot/sdk/entity/Document;", "documentFile", "Ljava/io/File;", "getDocumentFile", "()Ljava/io/File;", "fileOutputStream", "Ljava/io/OutputStream;", "getFileOutputStream", "()Ljava/io/OutputStream;", "setFileOutputStream", "(Ljava/io/OutputStream;)V", "lastProcessedPosition", "getLastProcessedPosition", "()I", "lines", "", "paragraphs", "pdfRenderer", "Lio/scanbot/ocr/pdf/TldrPdfRenderer;", "words", "recycle", "", "renderFromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "renderFromFileURI", "fileURI", "Landroid/net/Uri;", "inputEncrypted", "", "renderFromImageFile", "imageFile", "renderFromPage", "page", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "renderNextPage", "resetDataHolders", "sdk-ocr_release"})
    @SourceDebugExtension(value={"SMAP\nOcrPdfRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OcrPdfRenderer.kt\nio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$TldrRenderIteratorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,488:1\n1#2:489\n*E\n"})
    public final class b
    implements RenderIterator {
        @NotNull
        public final Document a;
        @NotNull
        public final ScanbotOpticalCharacterRecognizer.RecognizerInput b;
        @NotNull
        public final TldrPdfRenderer c;
        @NotNull
        public List<OcrResultBlock> d;
        @NotNull
        public List<OcrResultBlock> e;
        @NotNull
        public List<OcrResultBlock> f;
        public int g;
        @NotNull
        public StringBuilder h;
        @NotNull
        public final File i;
        @Nullable
        public OutputStream j;
        public final /* synthetic */ OcrPdfRenderer k;

        /*
         * WARNING - void declaration
         */
        public b(@NotNull OcrPdfRenderer this$0, @NotNull Document document, ScanbotOpticalCharacterRecognizer.RecognizerInput recognizerInput) {
            TldrPdfRenderer tldrPdfRenderer;
            String string;
            File file;
            void var2_2;
            b b2 = b4;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)file, (String)"recognizerInput");
            b4.k = string;
            b4.a = var2_2;
            b2.b = file;
            b2.d = new ArrayList<OcrResultBlock>();
            b2.e = new ArrayList<OcrResultBlock>();
            b2.f = new ArrayList<OcrResultBlock>();
            b2.h = new StringBuilder();
            ((OcrPdfRenderer)((Object)string)).a.getDocumentDir(var2_2.id).mkdirs();
            file = recognizerInput.getOutputFile();
            if (file == null) {
                DocumentStoreStrategy documentStoreStrategy = ((OcrPdfRenderer)((Object)string)).a;
                void v2 = var2_2;
                string = v2.id;
                file = documentStoreStrategy.getDocumentFile(string, v2.name);
            }
            b b3 = b4;
            b3.i = file;
            b b4 = tldrPdfRenderer;
            tldrPdfRenderer = new TldrPdfRenderer();
            b3.c = b4;
        }

        @NotNull
        public final Document b() {
            return this.a;
        }

        @NotNull
        public final StringBuilder a() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(@NotNull StringBuilder stringBuilder) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
            this.h = var1_1;
        }

        @NotNull
        public final File c() {
            return this.i;
        }

        @Nullable
        public final OutputStream d() {
            return this.j;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(@Nullable OutputStream outputStream) {
            void var1_1;
            this.j = var1_1;
        }

        @Override
        @NotNull
        public String getDetectedText() {
            String string = this.h.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public boolean renderNextPage() throws IOException {
            Object object;
            b b2 = this;
            b2.e();
            if (b2.g == 0) {
                object = this.k.e.openFileOutputStream(this.i);
                this.j = object;
                if (object != null) {
                    b b3 = this;
                    TldrPdfRenderer tldrPdfRenderer = b3.c;
                    PdfConfig pdfConfig = b3.b.getPdfConfig();
                    if (pdfConfig == null) {
                        pdfConfig = PdfConfig.Companion.defaultConfig();
                    }
                    tldrPdfRenderer.beginRender((OutputStream)object, pdfConfig);
                }
            }
            if (this.g >= this.b.getSize()) {
                return false;
            }
            object = this.b;
            if (object instanceof ScanbotOpticalCharacterRecognizer.PagesInput) {
                this.a(((ScanbotOpticalCharacterRecognizer.PagesInput)object).getPages().get(this.g));
            } else if (object instanceof ScanbotOpticalCharacterRecognizer.BitmapInput) {
                this.a(((ScanbotOpticalCharacterRecognizer.BitmapInput)object).getBitmap());
            } else if (object instanceof ScanbotOpticalCharacterRecognizer.UrisInput) {
                this.a(((ScanbotOpticalCharacterRecognizer.UrisInput)object).getUris().get(this.g), ((ScanbotOpticalCharacterRecognizer.UrisInput)this.b).getEncryptedInput());
            }
            if (this.g == this.b.getSize() - 1) {
                b b4 = this;
                b4.c.endRender();
                object = b4.j;
                if (object != null) {
                    ((OutputStream)object).close();
                }
            }
            ++this.g;
            return true;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedParagraphs() {
            return this.d;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedLines() {
            return this.e;
        }

        @Override
        @NotNull
        public List<OcrResultBlock> getDetectedWords() {
            return this.f;
        }

        @Override
        public int getLastProcessedPosition() {
            return this.g - 1;
        }

        @Override
        public void recycle() {
            this.k.f.clear();
        }

        public final void e() {
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            StringBuilder stringBuilder;
            b b2 = this_;
            Object this_ = stringBuilder;
            stringBuilder = new StringBuilder();
            b2.h = this_;
            this_ = arrayList3;
            arrayList3 = new ArrayList();
            b2.d = this_;
            this_ = arrayList2;
            arrayList2 = new ArrayList();
            b2.e = this_;
            this_ = arrayList;
            arrayList = new ArrayList();
            b2.f = this_;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(Page page) throws IOException {
            void var1_1;
            File file;
            File file2;
            File file3 = file2;
            File file4 = file;
            file = new File(this.k.b.getImageURI(var1_1.getPageId(), PageFileType.ORIGINAL).getPath());
            if (!new File(this.k.b.getImageURI(var1_1.getPageId(), PageFileType.DOCUMENT).getPath()).exists()) {
                file3 = file4;
            }
            this.a(file3, this.k.e.getUseEncryption());
        }

        public final void a(Bitmap bitmap) throws IOException {
            Object object;
            OcrPage ocrPage = this.c.addPageBitmap((Bitmap)object, 0);
            object.recycle();
            object = this.h;
            String string = ocrPage != null ? ocrPage.text : null;
            ((StringBuilder)object).append(string);
            if (ocrPage != null && (object = ocrPage.paragraphs) != null) {
                this.d.addAll((Collection<OcrResultBlock>)object);
            }
            if (ocrPage != null && (object = ocrPage.lines) != null) {
                this.e.addAll((Collection<OcrResultBlock>)object);
            }
            if (ocrPage != null && (object = ocrPage.words) != null) {
                this.f.addAll((Collection<OcrResultBlock>)object);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void a(Uri fileURI, boolean inputEncrypted) throws IOException {
            void var2_2;
            void var1_1;
            this.a(new File(var1_1.getPath()), (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void a(File imageFile, boolean inputEncrypted) {
            List list;
            void var1_5;
            void var1_1;
            void var2_7;
            if (!imageFile.exists()) {
                return;
            }
            if (var2_7 != false) {
                Bitmap bitmap = ImageFileIOProcessor.DefaultImpls.readImage$default((ImageFileIOProcessor)this.k.e, (File)var1_1, null, (int)2, null);
                if (bitmap == null) throw new BitmapAccessException("Cannot decode an image for PDF page.");
                OcrPage ocrPage = this.c.addPageBitmap(bitmap, 0);
                bitmap.recycle();
            } else {
                String string = var1_1.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                OcrPage ocrPage = this.c.addPageImagePath(string);
            }
            Object object = this.h;
            String string = var1_5 != null ? var1_5.text : null;
            ((StringBuilder)object).append(string);
            if (var1_5 != null && (object = var1_5.paragraphs) != null) {
                this.d.addAll((Collection<OcrResultBlock>)object);
            }
            if (var1_5 != null && (object = var1_5.lines) != null) {
                this.e.addAll((Collection<OcrResultBlock>)object);
            }
            if (var1_5 == null || (list = var1_5.words) == null) return;
            this.f.addAll(list);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OpticalCharacterRecognizer.EngineMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[OpticalCharacterRecognizer.EngineMode.TESSERACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[OpticalCharacterRecognizer.EngineMode.SCANBOT_OCR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

