/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.BitmapInput;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.ocr.ScanbotOpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J(\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001a\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "sapManager", "Lio/scanbot/sap/SapManager;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "input", "Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;", "createPDF", "", "availableLanguages", "", "Lio/scanbot/sdk/entity/Language;", "ocrWithDefaultLanguage", "performOCR", "saveMetaData", "detectedText", "trackDocument", "trackDuration", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    @NotNull
    public final BlobManager a;
    @NotNull
    public final OcrPdfRenderer b;
    @NotNull
    public final SimpleComposer c;
    @NotNull
    public final SapManager d;
    @NotNull
    public final OcrSettings e;
    @NotNull
    public final Logger f;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        ocrComposer.e = var5_5;
        ocrComposer.f = LoggerProvider.getLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfRendererInput input) throws IOException {
        Set set;
        long l;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        if (!this.d.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.a.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            this.c.composeDocument((Document)var1_1, (PdfRendererInput)var2_2);
            return;
        }
        {
            if (!set.isEmpty()) {
                OcrComposer ocrComposer = this;
                ocrComposer.a((Document)var1_1, ocrComposer.c((Document)var1_1, (PdfRendererInput)var2_2, set));
                ocrComposer.a((Document)var1_1, l);
                return;
            }
            this.f.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String a(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String c(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.f.d("OCR", "Starting OCR with languages: " + (Set)var3_3);
        return this.b((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String b(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        OcrPdfRenderer.RenderIterator renderIterator;
        List list;
        ScanbotOpticalCharacterRecognizer.RecognizerInput recognizerInput;
        if (input instanceof PagesInput) {
            ScanbotOpticalCharacterRecognizer.PagesInput pagesInput;
            recognizerInput = pagesInput;
            pagesInput = new ScanbotOpticalCharacterRecognizer.PagesInput(((PagesInput)list).getPages(), null, null, null, 14, null);
        } else if (list instanceof UrisInput) {
            ScanbotOpticalCharacterRecognizer.UrisInput urisInput;
            recognizerInput = urisInput;
            UrisInput urisInput2 = (UrisInput)list;
            list = urisInput2.getUris();
            urisInput = new ScanbotOpticalCharacterRecognizer.UrisInput(list, urisInput2.getInputEncrypted(), null, null, null, 28, null);
        } else {
            ScanbotOpticalCharacterRecognizer.BitmapInput bitmapInput;
            if (!(list instanceof BitmapInput)) {
                throw new NoWhenBranchMatchedException();
            }
            recognizerInput = bitmapInput;
            bitmapInput = new ScanbotOpticalCharacterRecognizer.BitmapInput(((BitmapInput)list).getBitmap(), null, null, null, 14, null);
        }
        renderIterator = this.b.startRender((Document)renderIterator, recognizerInput, (Collection<? extends Language>)var3_3, this.e);
        try {
            while (renderIterator.renderNextPage()) {
                this.f.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            String string = renderIterator.getDetectedText();
            renderIterator.recycle();
            return string;
        }
        catch (Throwable throwable) {
            renderIterator.recycle();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.f.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    public final void a(Document document) {
        Object object = document.language;
        if (object != null) {
            OcrComposer ocrComposer = ocrComposer.f;
            String string = "OCR";
            object = "Document language assigned: " + (object != null ? object.getOcrBlobLanguageTag() : null);
            ocrComposer.d(string, (String)object);
        }
    }
}

