/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.BitmapInput;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.DocumentInput;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfGeneratorInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.licensing.Feature;
import io.scanbot.sdk.ocr.ScanbotOcrEngine;
import io.scanbot.sdk.ocr.intelligence.OcrPdfGenerator;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0019\u001a\u00020\u0017\u0012\u0006\u0010\u001c\u001a\u00020\u001a\u0012\u0006\u0010\u001f\u001a\u00020\u001d\u0012\u0006\u0010#\u001a\u00020 \u0012\u0006\u0010'\u001a\u00020$\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ/\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ!\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u0012J\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\r\u0010\u0015J\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001eR\u0014\u0010#\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010'\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010+\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/entity/Document;", "document", "Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;", "input", "", "composeDocument", "(Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;)V", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "", "a", "(Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/docprocessing/compose/PdfGeneratorInput;Ljava/util/Set;)Ljava/lang/String;", "c", "b", "detectedText", "(Lio/scanbot/sdk/entity/Document;Ljava/lang/String;)V", "", "ocrStartedMillis", "(Lio/scanbot/sdk/entity/Document;J)V", "(Lio/scanbot/sdk/entity/Document;)V", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "pdfGenerator", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sap/SapManager;", "d", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "e", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sdk/util/log/Logger;", "f", "Lio/scanbot/sdk/util/log/Logger;", "logger", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    @NotNull
    public final BlobManager a;
    @NotNull
    public final OcrPdfGenerator b;
    @NotNull
    public final SimpleComposer c;
    @NotNull
    public final SapManager d;
    @NotNull
    public final OcrSettings e;
    @NotNull
    public final Logger f;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        ocrComposer.e = var5_5;
        ocrComposer.f = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfGeneratorInput input) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        if (!this.d.checkLicenseStatus(Feature.OCR)) {
            return;
        }
        try {
            long l = SystemClock.elapsedRealtime();
            Object object = this.a.getAllLanguagesWithAvailableOcrBlobs();
            if (!object.isEmpty()) {
                object = this.c((Document)var1_1, (PdfGeneratorInput)var2_2, (Set<? extends Language>)object);
                var1_1.ocrStatus = OcrStatus.DONE;
                var1_1.ocrText = object;
                this.a((Document)var1_1);
                this.a((Document)var1_1, l);
                return;
            }
            this.f.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
        catch (IOException iOException) {}
        this.c.composeDocument((Document)var1_1, (PdfGeneratorInput)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String a(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (PdfGeneratorInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String c(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.f.d("OCR", "Starting OCR with languages: " + (Set)var3_3);
        return this.b((Document)var1_1, (PdfGeneratorInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String b(Document document, PdfGeneratorInput input, Set<? extends Language> availableLanguages) throws IOException {
        Throwable throwable2;
        OcrPdfGenerator.GenerationIterator generationIterator;
        block10: {
            void var3_3;
            List list;
            ScanbotOcrEngine.EngineInput engineInput;
            if (input instanceof PagesInput) {
                ScanbotOcrEngine.PagesInput pagesInput;
                engineInput = pagesInput;
                pagesInput = new ScanbotOcrEngine.PagesInput(((PagesInput)list).getPages(), null, null, null, null, 30, null);
            } else if (list instanceof UrisInput) {
                ScanbotOcrEngine.UrisInput urisInput;
                engineInput = urisInput;
                UrisInput urisInput2 = (UrisInput)list;
                list = urisInput2.getUris();
                urisInput = new ScanbotOcrEngine.UrisInput(list, urisInput2.getInputEncrypted(), null, null, null, null, 60, null);
            } else if (list instanceof BitmapInput) {
                ScanbotOcrEngine.BitmapInput bitmapInput;
                engineInput = bitmapInput;
                bitmapInput = new ScanbotOcrEngine.BitmapInput(((BitmapInput)list).getBitmap(), null, null, null, null, 30, null);
            } else {
                ScanbotOcrEngine.DocumentInput documentInput;
                if (!(list instanceof DocumentInput)) {
                    throw new NoWhenBranchMatchedException();
                }
                engineInput = documentInput;
                documentInput = new ScanbotOcrEngine.DocumentInput(((DocumentInput)list).getDocument(), null, null, null, null, 30, null);
            }
            generationIterator = this.b.startGeneration((Document)generationIterator, engineInput, (Collection<? extends Language>)var3_3, this.e);
            try {
                while (generationIterator.generateNextPage()) {
                    this.f.d("OCR", "Page generated: " + generationIterator.getDetectedText());
                }
            }
            catch (Throwable throwable2) {
                break block10;
            }
            String string = generationIterator.getDetectedText();
            generationIterator.recycle();
            return string;
        }
        generationIterator.recycle();
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void a(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.f.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    public final void a(Document document) {
        Object object = document.language;
        if (object != null) {
            OcrComposer ocrComposer = ocrComposer.f;
            String string = "OCR";
            object = "Document language assigned: " + (object != null ? object.getOcrBlobLanguageTag() : null);
            ocrComposer.d(string, (String)object);
        }
    }
}

