/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.pdf;

import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import io.scanbot.sdk.exceptions.OperationCancelledException;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.LongOperationCancelCallback;
import io.scanbot.sdk.util.ProgressCallback;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0004JZ\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J,\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0004J@\u0010'\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010(\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/pdf/DefaultPdfImagesExtractor;", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "(Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;)V", "getFileIOProcessor", "()Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "calculateFileName", "", "prefix", "pageNumber", "", "format", "Landroid/graphics/Bitmap$CompressFormat;", "calculatePageSize", "Lkotlin/Pair;", "scaling", "", "page", "Landroid/graphics/pdf/PdfRenderer$Page;", "Landroid/graphics/pdf/PdfRenderer;", "imageUrlsFromPdf", "", "Landroid/net/Uri;", "pdfFile", "Ljava/io/File;", "outputDir", "compression", "quality", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "cancelCallback", "Lio/scanbot/sdk/util/LongOperationCancelCallback;", "progressCallback", "Lio/scanbot/sdk/util/ProgressCallback;", "renderBitmap", "Landroid/graphics/Bitmap;", "width", "height", "writeBitmapIntoFile", "bitmap", "sdk-pdfextractor_release"})
@SourceDebugExtension(value={"SMAP\nDefaultPdfImagesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPdfImagesExtractor.kt\nio/scanbot/sdk/pdf/DefaultPdfImagesExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n2634#2:116\n1#3:117\n*S KotlinDebug\n*F\n+ 1 DefaultPdfImagesExtractor.kt\nio/scanbot/sdk/pdf/DefaultPdfImagesExtractor\n*L\n65#1:116\n65#1:117\n*E\n"})
public class DefaultPdfImagesExtractor
implements PdfImagesExtractor {
    @NotNull
    private final FileIOProcessor fileIOProcessor;

    /*
     * WARNING - void declaration
     */
    public DefaultPdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        this.fileIOProcessor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final File writeBitmapIntoFile(FileIOProcessor fileIOProcessor, String prefix, int pageNumber, Bitmap.CompressFormat compression, File outputDir, Bitmap bitmap, int quality) {
        void var7_7;
        void var6_6;
        void var1_1;
        void var4_4;
        void var3_3;
        void var2_2;
        File file = FilesKt.resolve((File)outputDir, (String)((DefaultPdfImagesExtractor)((Object)file)).calculateFileName((String)var2_2, (int)(var3_3 + true), (Bitmap.CompressFormat)var4_4));
        var1_1.writeImage((Bitmap)var6_6, (Bitmap.CompressFormat)var4_4, (int)var7_7, file);
        return file;
    }

    @NotNull
    public final FileIOProcessor getFileIOProcessor() {
        return this.fileIOProcessor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Uri> imageUrlsFromPdf(@NotNull File pdfFile, @NotNull File outputDir, @NotNull String prefix, @NotNull Bitmap.CompressFormat compression, int quality, float scaling, @NotNull Bitmap.Config bitmapConfig, @Nullable LongOperationCancelCallback cancelCallback, @Nullable ProgressCallback progressCallback) throws IOException, OperationCancelledException {
        void var8_10;
        PdfRenderer pdfRenderer;
        ArrayList<Uri> arrayList;
        void var4_6;
        void var3_5;
        void var2_4;
        String string;
        Intrinsics.checkNotNullParameter((Object)string, (String)"pdfFile");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)var3_5, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)var4_6, (String)"compression");
        Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>();
        PdfRenderer pdfRenderer2 = pdfRenderer;
        pdfRenderer = new PdfRenderer(ParcelFileDescriptor.open((File)((Object)string), (int)0x10000000));
        int n = pdfRenderer.getPageCount();
        for (int i = 0; i < n; ++i) {
            void var5_7;
            void var7_9;
            void var6_8;
            void var9_11;
            boolean bl;
            block18: {
                block17: {
                    if (var8_10 != null) {
                        if (!var8_10.isCanceled()) break block17;
                        bl = true;
                        break block18;
                    }
                }
                bl = false;
            }
            if (bl) break;
            void v3 = var9_11;
            ArrayList<Uri> arrayList3 = arrayList2;
            DefaultPdfImagesExtractor defaultPdfImagesExtractor = this;
            DefaultPdfImagesExtractor defaultPdfImagesExtractor2 = defaultPdfImagesExtractor;
            DefaultPdfImagesExtractor defaultPdfImagesExtractor3 = defaultPdfImagesExtractor;
            void v8 = var6_8;
            Object object = pdfRenderer2.openPage(i);
            Intrinsics.checkNotNull((Object)object);
            Bitmap bitmap = defaultPdfImagesExtractor2.calculatePageSize((float)v8, (PdfRenderer.Page)object);
            bitmap = defaultPdfImagesExtractor3.renderBitmap(((Number)bitmap.component1()).intValue(), ((Number)bitmap.component2()).intValue(), (Bitmap.Config)var7_9, (PdfRenderer.Page)object);
            PdfRenderer.Page page = object;
            Object object2 = this;
            object = super.writeBitmapIntoFile(((DefaultPdfImagesExtractor)object2).fileIOProcessor, (String)var3_5, i, (Bitmap.CompressFormat)var4_6, (File)var2_4, bitmap, (int)var5_7);
            page.close();
            bitmap.recycle();
            arrayList3.add(Uri.fromFile((File)object));
            if (v3 == null) continue;
            var9_11.onPageProcessed(i, pdfRenderer2.getPageCount());
        }
        try {
            pdfRenderer2.close();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            if (string == null) {
                string = "Error while converting pdf to images";
            }
            DefaultPdfImagesExtractor defaultPdfImagesExtractor = this;
            defaultPdfImagesExtractor(string);
            throw defaultPdfImagesExtractor;
        }
        if (var8_10 != null && var8_10.isCanceled()) {
            for (Uri uri : arrayList2) {
                new File(String.valueOf(uri.getPath())).delete();
            }
            arrayList2.clear();
            throw new OperationCancelledException();
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap renderBitmap(int width, int height, @NotNull Bitmap.Config bitmapConfig, @NotNull PdfRenderer.Page page) {
        void var2_2;
        void var4_4;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"bitmapConfig");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"page");
        DefaultPdfImagesExtractor defaultPdfImagesExtractor = this = Bitmap.createBitmap((int)width, (int)var2_2, (Bitmap.Config)var3_3);
        Intrinsics.checkNotNullExpressionValue((Object)defaultPdfImagesExtractor, (String)"createBitmap(...)");
        defaultPdfImagesExtractor.eraseColor(-1);
        var4_4.render((Bitmap)this, null, null, 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> calculatePageSize(float scaling, @NotNull PdfRenderer.Page page) {
        void var1_3;
        void var2_5;
        void v0 = var2_5;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"page");
        int n = (int)(var1_3 * (float)v0.getWidth());
        int n2 = (int)(scaling * (float)var2_5.getHeight());
        Integer n3 = n;
        return new Pair((Object)n3, (Object)n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String calculateFileName(@NotNull String prefix, int pageNumber, @NotNull Bitmap.CompressFormat format) {
        void var2_2;
        void var1_1;
        void var3_3;
        void v0 = var3_3;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"format");
        String string = v0.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return prefix + "_" + (int)var2_2 + "." + (String)string;
    }
}

