/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.textpattern.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.generic_text.R;
import io.scanbot.sdk.textpattern.WordBox;
import io.scanbot.sdk.ui.BasePolygonView;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0014J\u000e\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020 J(\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 H\u0002J\u0014\u0010B\u001a\u0002072\f\u0010C\u001a\b\u0012\u0004\u0012\u00020201R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/scanbot/sdk/textpattern/ui/WordboxPreviewView;", "Landroid/view/View;", "Lio/scanbot/sdk/ui/BasePolygonView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "analyzerFrameMirrored", "", "getAnalyzerFrameMirrored", "()Z", "setAnalyzerFrameMirrored", "(Z)V", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "getCameraModule", "()Lio/scanbot/sdk/camera/CameraModule;", "setCameraModule", "(Lio/scanbot/sdk/camera/CameraModule;)V", "cornerRadius", "", "drawRect", "Landroid/graphics/RectF;", "finderRect", "Landroid/graphics/Rect;", "getFinderRect", "()Landroid/graphics/Rect;", "setFinderRect", "(Landroid/graphics/Rect;)V", "frameHeight", "", "getFrameHeight", "()I", "setFrameHeight", "(I)V", "frameOrientation", "getFrameOrientation", "setFrameOrientation", "frameWidth", "getFrameWidth", "setFrameWidth", "matrix", "Landroid/graphics/Matrix;", "resultRectF", "strokePaint", "Landroid/graphics/Paint;", "wordboxes", "", "Lio/scanbot/sdk/textpattern/WordBox;", "calculateAlpha", "confidence", "", "initView", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setColor", "strokeColor", "toRelativeRectF", "resultRect", "width", "height", "orientation", "updateCharacters", "list", "Companion", "sdk-textpattern_release"})
@SourceDebugExtension(value={"SMAP\nWordboxPreviewView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordboxPreviewView.kt\nio/scanbot/sdk/textpattern/ui/WordboxPreviewView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 WordboxPreviewView.kt\nio/scanbot/sdk/textpattern/ui/WordboxPreviewView\n*L\n73#1:114,2\n*E\n"})
public final class WordboxPreviewView
extends View
implements BasePolygonView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CONFIDENCE_MAX_ALPHA = 50;
    private static final int CONFIDENCE_DIVIDER = 10000;
    @NotNull
    private static final List<Integer> PORTRAIT_ORIENTATION;
    @NotNull
    private List<WordBox> wordboxes;
    @NotNull
    private Paint strokePaint;
    @NotNull
    private final RectF drawRect;
    @NotNull
    private final RectF resultRectF;
    private float cornerRadius;
    @NotNull
    private final Matrix matrix;
    private int frameWidth;
    private int frameHeight;
    private int frameOrientation;
    @Nullable
    private Rect finderRect;
    private boolean analyzerFrameMirrored;
    @NotNull
    private CameraModule cameraModule;

    /*
     * WARNING - void declaration
     */
    public WordboxPreviewView(@NotNull Context context) {
        void var1_1;
        WordboxPreviewView wordboxPreviewView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1);
        wordboxPreviewView.wordboxes = CollectionsKt.emptyList();
        wordboxPreviewView.strokePaint = new TextPaint();
        wordboxPreviewView.drawRect = new RectF();
        wordboxPreviewView.resultRectF = new RectF();
        Matrix matrix = new Matrix();
        matrix.setScale(-1.0f, 1.0f, 0.5f, 0.5f);
        wordboxPreviewView.matrix = matrix;
        wordboxPreviewView.cameraModule = CameraModule.BACK;
        wordboxPreviewView.initView();
    }

    /*
     * WARNING - void declaration
     */
    public WordboxPreviewView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        void var1_1;
        WordboxPreviewView wordboxPreviewView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        wordboxPreviewView.wordboxes = CollectionsKt.emptyList();
        wordboxPreviewView.strokePaint = new TextPaint();
        wordboxPreviewView.drawRect = new RectF();
        wordboxPreviewView.resultRectF = new RectF();
        Matrix matrix = new Matrix();
        matrix.setScale(-1.0f, 1.0f, 0.5f, 0.5f);
        wordboxPreviewView.matrix = matrix;
        wordboxPreviewView.cameraModule = CameraModule.BACK;
        wordboxPreviewView.initView();
    }

    private final void initView() {
        WordboxPreviewView wordboxPreviewView = this;
        wordboxPreviewView.cornerRadius = wordboxPreviewView.getResources().getDimension(R.dimen.wordbox_rounded_corner_radius);
        wordboxPreviewView.strokePaint.setColor(-16711681);
        wordboxPreviewView.strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        wordboxPreviewView.strokePaint.setAntiAlias(true);
    }

    private final int calculateAlpha(double confidence) {
        double d = confidence;
        return (int)(d * d / (double)10000 * (double)50);
    }

    /*
     * WARNING - void declaration
     */
    private final RectF toRelativeRectF(Rect resultRect, int width, int height, int orientation) {
        void var1_2;
        void var3_5;
        void var2_4;
        void var4_6;
        List<Integer> list = PORTRAIT_ORIENTATION;
        void var6_8 = list.contains((int)var4_6) ? var2_4 : var3_5;
        if (list.contains((int)var4_6)) {
            var2_4 = var3_5;
        }
        WordboxPreviewView wordboxPreviewView = wordboxPreviewView.resultRectF;
        float f = (float)var6_8;
        ((RectF)wordboxPreviewView).left = (float)var1_2.left / f;
        float f2 = (float)var2_4;
        ((RectF)wordboxPreviewView).top = (float)var1_2.top / f2;
        ((RectF)wordboxPreviewView).right = (float)var1_2.right / f;
        ((RectF)wordboxPreviewView).bottom = (float)var1_2.bottom / f2;
        return wordboxPreviewView;
    }

    static {
        Integer n = 0;
        Integer n2 = 180;
        PORTRAIT_ORIENTATION = CollectionsKt.listOf((Object[])new Integer[]{n, n2});
    }

    public final int getFrameWidth() {
        return this.frameWidth;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrameWidth(int n) {
        void var1_1;
        this.frameWidth = var1_1;
    }

    public final int getFrameHeight() {
        return this.frameHeight;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrameHeight(int n) {
        void var1_1;
        this.frameHeight = var1_1;
    }

    public final int getFrameOrientation() {
        return this.frameOrientation;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrameOrientation(int n) {
        void var1_1;
        this.frameOrientation = var1_1;
    }

    @Nullable
    public final Rect getFinderRect() {
        return this.finderRect;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFinderRect(@Nullable Rect rect) {
        void var1_1;
        this.finderRect = var1_1;
    }

    public final boolean getAnalyzerFrameMirrored() {
        return this.analyzerFrameMirrored;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnalyzerFrameMirrored(boolean bl) {
        void var1_1;
        this.analyzerFrameMirrored = var1_1;
    }

    @NotNull
    public final CameraModule getCameraModule() {
        return this.cameraModule;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.cameraModule = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setColor(int strokeColor) {
        void var1_1;
        WordboxPreviewView wordboxPreviewView = this;
        wordboxPreviewView.strokePaint.setColor((int)var1_1);
        wordboxPreviewView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCharacters(@NotNull List<WordBox> list) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"list");
        this.wordboxes = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void onDraw(@NotNull Canvas canvas) {
        void var1_1;
        WordboxPreviewView wordboxPreviewView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"canvas");
        super.onDraw((Canvas)v1);
        for (WordBox wordBox : wordboxPreviewView.wordboxes) {
            Rect rect;
            Rect rect2;
            Rect rect3 = this.finderRect;
            if (rect3 != null) {
                Rect rect4;
                rect2 = wordBox.getBoundingRect();
                rect = rect4;
                int n = rect3.left;
                int n2 = n;
                Rect rect5 = rect2;
                int n3 = rect3.top;
                int n4 = rect5.top + n3;
                n2 = rect5.right + n2;
                n3 = rect5.bottom + n3;
                rect4 = new Rect(rect2.left + n, n4, n2, n3);
            } else {
                rect = wordBox.getBoundingRect();
            }
            WordboxPreviewView wordboxPreviewView2 = this;
            WordboxPreviewView wordboxPreviewView3 = this;
            int n = wordboxPreviewView3.frameWidth;
            int n5 = wordboxPreviewView3.frameHeight;
            int n6 = wordboxPreviewView3.frameOrientation;
            RectF rectF = wordboxPreviewView2.toRelativeRectF(rect, n, n5, n6);
            wordboxPreviewView2.strokePaint.setAlpha(this.calculateAlpha(wordBox.getRecognitionConfidence()));
            wordboxPreviewView2.drawRect.left = rectF.left * (float)this.getWidth();
            wordboxPreviewView2.drawRect.top = rectF.top * (float)this.getHeight();
            wordboxPreviewView2.drawRect.right = rectF.right * (float)this.getWidth();
            wordboxPreviewView2.drawRect.bottom = rectF.bottom * (float)this.getHeight();
            wordBox = wordboxPreviewView2.drawRect;
            float f = wordboxPreviewView2.cornerRadius;
            rect2 = wordboxPreviewView2.strokePaint;
            float f2 = f;
            var1_1.drawRoundRect((RectF)wordBox, f2, f2, (Paint)rect2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/textpattern/ui/WordboxPreviewView$Companion;", "", "()V", "CONFIDENCE_DIVIDER", "", "CONFIDENCE_MAX_ALPHA", "PORTRAIT_ORIENTATION", "", "sdk-textpattern_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

