/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import io.scanbot.sdk.ui.base.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\rH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/ui/view/widget/ToastView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "textView", "Landroid/widget/TextView;", "hideViewRunnable", "Ljava/lang/Runnable;", "showToast", "", "text", "", "duration", "Lio/scanbot/sdk/ui/view/widget/ToastView$Duration;", "setTextColor", "color", "", "setToastBackgroundColor", "onDetachedFromWindow", "Duration", "Companion", "rtu-ui-base_release"})
public final class ToastView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView textView;
    @NotNull
    private Runnable hideViewRunnable;
    public static final long DURATION_SHORT = 4000L;
    public static final long DURATION_LONG = 7000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToastView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.hideViewRunnable = () -> ToastView.hideViewRunnable$lambda$0(this);
        View.inflate((Context)context, (int)R.layout.scanbot_sdk_view_toast, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.scanbot_sdk_view_toast_text);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.textView = (TextView)view;
        this.textView.setBackgroundResource(R.drawable.camera_hint_bg);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ToastView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            int backgroundColor = typedArray2.getColor(R.styleable.ToastView_toast_text_background, ContextCompat.getColor((Context)context, (int)R.color.scanbot_sdk_toast_view_color));
            int textColor = typedArray2.getColor(R.styleable.ToastView_toast_text_color, ContextCompat.getColor((Context)context, (int)R.color.scanbot_sdk_textColorPrimary));
            this.textView.setBackgroundTintList(ColorStateList.valueOf((int)backgroundColor));
            this.textView.setTextColor(textColor);
        }
        finally {
            typedArray2.recycle();
        }
        this.setVisibility(8);
    }

    public final void showToast(@NotNull String text, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)duration), (String)"duration");
        this.textView.setText((CharSequence)text);
        this.setVisibility(0);
        this.removeCallbacks(this.hideViewRunnable);
        this.postDelayed(this.hideViewRunnable, switch (WhenMappings.$EnumSwitchMapping$0[duration.ordinal()]) {
            case 1 -> 4000L;
            case 2 -> 7000L;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    public final void setTextColor(@ColorInt int color2) {
        this.textView.setTextColor(color2);
    }

    public final void setToastBackgroundColor(@ColorInt int color2) {
        this.textView.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.hideViewRunnable);
    }

    private static final void hideViewRunnable$lambda$0(ToastView this$0) {
        this$0.setVisibility(8);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/widget/ToastView$Companion;", "", "<init>", "()V", "DURATION_SHORT", "", "DURATION_LONG", "rtu-ui-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/widget/ToastView$Duration;", "", "<init>", "(Ljava/lang/String;I)V", "SHORT", "LONG", "rtu-ui-base_release"})
    public static final class Duration
    extends Enum<Duration> {
        public static final /* enum */ Duration SHORT = new Duration();
        public static final /* enum */ Duration LONG = new Duration();
        private static final /* synthetic */ Duration[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Duration[] values() {
            return (Duration[])$VALUES.clone();
        }

        public static Duration valueOf(String value) {
            return Enum.valueOf(Duration.class, value);
        }

        @NotNull
        public static EnumEntries<Duration> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = durationArray = new Duration[]{Duration.SHORT, Duration.LONG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Duration.values().length];
            try {
                nArray[Duration.SHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Duration.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

