/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageButton;
import io.scanbot.sdk.ui.base.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\u0012\u001a\u00020\u000eH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/utils/TintableImageButton;", "Landroidx/appcompat/widget/AppCompatImageButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "tint", "Landroid/content/res/ColorStateList;", "init", "", "defStyle", "drawableStateChanged", "setColorFilter", "updateTintColor", "rtu-ui-base_release"})
public class TintableImageButton
extends AppCompatImageButton {
    @Nullable
    private ColorStateList tint;

    public TintableImageButton(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public TintableImageButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TintableImageButton, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            this.tint = typedArray2.getColorStateList(R.styleable.TintableImageButton_src_tint);
            if (this.tint != null) {
                ColorStateList colorStateList = this.tint;
                Intrinsics.checkNotNull((Object)colorStateList);
                if (!colorStateList.isStateful()) {
                    this.updateTintColor();
                }
            }
        }
        finally {
            typedArray2.recycle();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.tint != null) {
            ColorStateList colorStateList = this.tint;
            Intrinsics.checkNotNull((Object)colorStateList);
            if (colorStateList.isStateful()) {
                this.updateTintColor();
            }
        }
    }

    public final void setColorFilter(@Nullable ColorStateList tint) {
        this.tint = tint;
        this.updateTintColor();
    }

    private final void updateTintColor() {
        block0: {
            ColorStateList colorStateList = this.tint;
            if (colorStateList == null) break block0;
            ColorStateList it = colorStateList;
            boolean bl = false;
            int color = it.getColorForState(this.getDrawableState(), 0);
            this.setColorFilter(color);
        }
    }
}

