/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.documentdata.list;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import io.scanbot.genericdocument.entity.CommonFieldType;
import io.scanbot.genericdocument.entity.Field;
import io.scanbot.genericdocument.entity.OcrResult;
import io.scanbot.sdk.core.ImageRef;
import io.scanbot.sdk.ui.documentdata.R;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentDataListViewModel;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentDataListViewType;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentDataViewConfiguration;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentFieldDiffCallback;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentFieldItemViewHolder;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentItemViewHolder;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentSectionItemViewHolder;
import io.scanbot.sdk.ui.view.documentdata.list.FieldDataViewModel;
import io.scanbot.sdk.ui.view.documentdata.list.SectionDataViewModel;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/ui/view/documentdata/list/DocumentDataFieldItemAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lio/scanbot/sdk/ui/view/documentdata/list/DocumentDataListViewModel;", "Lio/scanbot/sdk/ui/view/documentdata/list/DocumentItemViewHolder;", "context", "Landroid/content/Context;", "configProvider", "Ljavax/inject/Provider;", "Lio/scanbot/sdk/ui/view/documentdata/list/DocumentDataViewConfiguration;", "(Landroid/content/Context;Ljavax/inject/Provider;)V", "getItemViewType", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "rtu-ui-documentdata_release"})
@SourceDebugExtension(value={"SMAP\nDocumentDataFieldItemAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentDataFieldItemAdapter.kt\nio/scanbot/sdk/ui/view/documentdata/list/DocumentDataFieldItemAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class DocumentDataFieldItemAdapter
extends ListAdapter<DocumentDataListViewModel, DocumentItemViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Provider<DocumentDataViewConfiguration> configProvider;
    private static final int TYPE_TITLE_FIELD_ALPHA = 180;
    private static final int IMAGE_GENERIC_DOCUMENT_FIELD_ALPHA = 100;

    public DocumentDataFieldItemAdapter(@NotNull Context context, @NotNull Provider<DocumentDataViewConfiguration> configProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(configProvider, (String)"configProvider");
        super((DiffUtil.ItemCallback)new DocumentFieldDiffCallback());
        this.context = context;
        this.configProvider = configProvider;
    }

    @NotNull
    public DocumentItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = viewType;
        if (n == DocumentDataListViewType.FIELD.ordinal()) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.scanbot_sdk_document_data_field_item, parent, false);
            Intrinsics.checkNotNull((Object)view);
            DocumentFieldItemViewHolder holder = new DocumentFieldItemViewHolder(view);
            int it = ((DocumentDataViewConfiguration)this.configProvider.get()).getPrimaryColor();
            boolean bl = false;
            holder.getValue().setTextColor(it);
            holder.getType().setTextColor(Color.argb((int)180, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it)));
            holder.getImage().setBackgroundTintList(ColorStateList.valueOf((int)Color.argb((int)100, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it))));
            it = ((DocumentDataViewConfiguration)this.configProvider.get()).getFieldConfidenceTextColor();
            boolean bl2 = false;
            holder.getConfidenceImage().setImageTintList(ColorStateList.valueOf((int)it));
            holder.getConfidence().setTextColor(it);
            return holder;
        }
        if (n == DocumentDataListViewType.SECTION.ordinal()) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.scanbot_sdk_document_data_section_item, parent, false);
            Intrinsics.checkNotNull((Object)view);
            DocumentSectionItemViewHolder holder = new DocumentSectionItemViewHolder(view);
            int it = ((DocumentDataViewConfiguration)this.configProvider.get()).getPrimaryColor();
            boolean bl = false;
            holder.getValue().setTextColor(it);
            return holder;
        }
        throw new IllegalArgumentException("Unknown type of view holder " + viewType);
    }

    public int getItemViewType(int position) {
        int n;
        DocumentDataListViewModel documentDataListViewModel = (DocumentDataListViewModel)this.getItem(position);
        if (documentDataListViewModel instanceof FieldDataViewModel) {
            n = DocumentDataListViewType.FIELD.ordinal();
        } else if (documentDataListViewModel instanceof SectionDataViewModel) {
            n = DocumentDataListViewType.SECTION.ordinal();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public void onBindViewHolder(@NotNull DocumentItemViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        DocumentDataListViewModel item = (DocumentDataListViewModel)this.getItem(position);
        if (item instanceof FieldDataViewModel) {
            float f;
            Object object;
            DocumentFieldItemViewHolder cfr_ignored_0 = (DocumentFieldItemViewHolder)holder;
            Field documentField = ((FieldDataViewModel)item).getField();
            ImageRef imageRef = documentField.getImage();
            if (imageRef != null && (imageRef = imageRef.toBitmap()) != null) {
                ImageRef it = imageRef;
                boolean bl = false;
                ((DocumentFieldItemViewHolder)holder).getImage().setImageBitmap((Bitmap)it);
            }
            OcrResult ocrResult = documentField.getValue();
            ((DocumentFieldItemViewHolder)holder).getValue().setText((CharSequence)(ocrResult != null ? ocrResult.getText() : null));
            ((DocumentFieldItemViewHolder)holder).getType().setText((object = ((DocumentDataViewConfiguration)this.configProvider.get()).getFieldsDisplayMap().get(documentField.getType().getNormalizedName())) != null && (object = object.getDefaultDisplayText()) != null ? (CharSequence)object : (CharSequence)documentField.getType().getName());
            Object[] objectArray = new CommonFieldType[]{CommonFieldType.SIGNATURE, CommonFieldType.PHOTO};
            boolean isImage = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)documentField.getType().getCommonType());
            if (isImage) {
                f = 1.0f;
            } else {
                OcrResult ocrResult2 = documentField.getValue();
                CharSequence charSequence = ocrResult2 != null ? ocrResult2.getText() : null;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    f = 1.0f;
                } else {
                    OcrResult ocrResult3 = documentField.getValue();
                    f = ocrResult3 != null ? (float)ocrResult3.getConfidence() : 0.0f;
                }
            }
            float conf = f;
            ((DocumentFieldItemViewHolder)holder).getConfidence().setText((CharSequence)"");
            if (isImage) {
                ((DocumentFieldItemViewHolder)holder).getValue().setText((CharSequence)((DocumentDataViewConfiguration)this.configProvider.get()).getImageTitle());
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_checked);
            } else if (conf == 1.0f) {
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_checked);
            } else if (conf == 0.0f) {
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_crossed);
            } else {
                int textConfidence = MathKt.roundToInt((float)(conf * (float)100));
                ((DocumentFieldItemViewHolder)holder).getConfidence().setText((CharSequence)String.valueOf(textConfidence));
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(8);
            }
            DocumentDataViewConfiguration config = (DocumentDataViewConfiguration)this.configProvider.get();
            boolean bl = false;
            ((DocumentFieldItemViewHolder)holder).getConfidenceLayout().setBackgroundTintList((double)conf > 0.9 ? ColorStateList.valueOf((int)config.getFieldConfidenceHighColor()) : ((double)conf > 0.5 ? ColorStateList.valueOf((int)config.getFieldConfidenceModerateColor()) : ColorStateList.valueOf((int)config.getFieldConfidenceLowColor())));
        } else if (item instanceof SectionDataViewModel) {
            DocumentSectionItemViewHolder cfr_ignored_1 = (DocumentSectionItemViewHolder)holder;
            ((DocumentSectionItemViewHolder)holder).getValue().setText((CharSequence)((SectionDataViewModel)item).getHeader());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/documentdata/list/DocumentDataFieldItemAdapter$Companion;", "", "()V", "IMAGE_GENERIC_DOCUMENT_FIELD_ALPHA", "", "TYPE_TITLE_FIELD_ALPHA", "rtu-ui-documentdata_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

