/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.documentdata;

import io.scanbot.sdk.documentdata.DocumentDataExtractionResult;
import io.scanbot.sdk.documentdata.DocumentDataExtractor;
import io.scanbot.sdk.documentdata.entity.RootDocumentType;
import io.scanbot.sdk.genericdocument.entity.GenericDocument;
import io.scanbot.sdk.genericdocument.entity.GenericDocumentType;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractionPack;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractionPacks;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractionState;
import io.scanbot.sdk.ui.view.documentdata.DocumentDataExtractionStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\b\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\rJ\u000e\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\nJ\b\u0010)\u001a\u00020\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionSession;", "", "documentDataExtractor", "Lio/scanbot/sdk/documentdata/DocumentDataExtractor;", "(Lio/scanbot/sdk/documentdata/DocumentDataExtractor;)V", "currentPack", "Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionPack;", "documentsState", "", "Lio/scanbot/sdk/genericdocument/entity/GenericDocumentType;", "Lio/scanbot/sdk/documentdata/DocumentDataExtractionResult;", "extractionPaused", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "extractionReady", "stateSubject", "Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionState;", "allSidesExtracted", "pack", "averageConfidence", "", "calculateStep", "Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionStep;", "clear", "", "getAllDocuments", "", "isHighAverageConfidence", "observeDocumentDataExtractionResults", "Lkotlinx/coroutines/flow/SharedFlow;", "observeExtractionPausedState", "Lkotlinx/coroutines/flow/StateFlow;", "observeExtractionReadyState", "processTwoSided", "Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionPack$TwoSidedPack;", "pushExtractionPausedState", "opened", "pushExtractionReadyState", "ready", "pushNewDocumentDataExtractionResult", "result", "updateState", "Companion", "rtu-ui-documentdata_release"})
@SourceDebugExtension(value={"SMAP\nDocumentDataExtractionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentDataExtractionSession.kt\nio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1#2:210\n125#3:211\n152#3,3:212\n125#3:215\n152#3,3:216\n1549#4:219\n1620#4,3:220\n*S KotlinDebug\n*F\n+ 1 DocumentDataExtractionSession.kt\nio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionSession\n*L\n110#1:211\n110#1:212,3\n114#1:215\n114#1:216,3\n140#1:219\n140#1:220,3\n*E\n"})
public final class DocumentDataExtractionSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentDataExtractor documentDataExtractor;
    @NotNull
    private final Map<GenericDocumentType, DocumentDataExtractionResult> documentsState;
    @NotNull
    private final MutableStateFlow<DocumentDataExtractionState> stateSubject;
    @NotNull
    private final MutableStateFlow<Boolean> extractionReady;
    @NotNull
    private final MutableStateFlow<Boolean> extractionPaused;
    @Nullable
    private DocumentDataExtractionPack currentPack;
    public static final double ZERO_CONFIDENCE_VALUE = 0.0;
    public static final double MODERATE_CONFIDENCE_VALUE = 0.5;
    public static final double HIGH_CONFIDENCE_VALUE = 0.9;

    public DocumentDataExtractionSession(@NotNull DocumentDataExtractor documentDataExtractor) {
        Intrinsics.checkNotNullParameter((Object)documentDataExtractor, (String)"documentDataExtractor");
        this.documentDataExtractor = documentDataExtractor;
        this.documentsState = new LinkedHashMap();
        this.stateSubject = StateFlowKt.MutableStateFlow((Object)new DocumentDataExtractionState(0.0, DocumentDataExtractionStep.NOT_READY, MapsKt.emptyMap()));
        this.extractionReady = StateFlowKt.MutableStateFlow((Object)false);
        this.extractionPaused = StateFlowKt.MutableStateFlow((Object)false);
    }

    @NotNull
    public final SharedFlow<DocumentDataExtractionState> observeDocumentDataExtractionResults() {
        return (SharedFlow)this.stateSubject;
    }

    public final void pushNewDocumentDataExtractionResult(@NotNull DocumentDataExtractionResult result) {
        block6: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            GenericDocument genericDocument = result.getDocument();
            if (genericDocument != null) {
                Object v1;
                GenericDocumentType type;
                block5: {
                    GenericDocument document = genericDocument;
                    boolean bl = false;
                    type = document.getType();
                    Iterable iterable = DocumentDataExtractionPacks.INSTANCE.getPacks();
                    for (Object t : iterable) {
                        DocumentDataExtractionPack it = (DocumentDataExtractionPack)t;
                        boolean bl2 = false;
                        if (!it.contains(type)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                DocumentDataExtractionPack documentDataExtractionPack = v1;
                if (documentDataExtractionPack == null) {
                    return;
                }
                DocumentDataExtractionPack typePack = documentDataExtractionPack;
                if (this.currentPack != null && !Intrinsics.areEqual((Object)typePack, (Object)this.currentPack)) {
                    return;
                }
                this.currentPack = typePack;
                this.documentsState.put(type, result);
                this.updateState();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block6;
            this.updateState();
        }
    }

    @NotNull
    public final StateFlow<Boolean> observeExtractionReadyState() {
        return (StateFlow)this.extractionReady;
    }

    @NotNull
    public final StateFlow<Boolean> observeExtractionPausedState() {
        return (StateFlow)this.extractionPaused;
    }

    public final void pushExtractionReadyState(boolean ready) {
        this.extractionReady.setValue((Object)ready);
    }

    public final void pushExtractionPausedState(boolean opened) {
        this.extractionPaused.setValue((Object)opened);
    }

    public final void clear() {
        this.documentDataExtractor.clear();
        this.documentsState.clear();
        this.currentPack = null;
        this.updateState();
    }

    @NotNull
    public final List<DocumentDataExtractionResult> getAllDocuments() {
        return CollectionsKt.toList((Iterable)this.documentsState.values());
    }

    private final void updateState() {
        this.stateSubject.setValue((Object)new DocumentDataExtractionState(this.averageConfidence(), this.calculateStep(), MapsKt.toMap(this.documentsState)));
    }

    /*
     * WARNING - void declaration
     */
    private final double averageConfidence() {
        void $this$mapTo$iv$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        if (this.documentsState.isEmpty()) {
            return 0.0;
        }
        Map<GenericDocumentType, DocumentDataExtractionResult> $this$map$iv = this.documentsState;
        boolean $i$f$map = false;
        Map<GenericDocumentType, DocumentDataExtractionResult> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            void it;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GenericDocument genericDocument = ((DocumentDataExtractionResult)it.getValue()).getDocument();
            Intrinsics.checkNotNull((Object)genericDocument);
            double d = genericDocument.getConfidence();
            GenericDocument genericDocument2 = ((DocumentDataExtractionResult)it.getValue()).getDocument();
            Intrinsics.checkNotNull((Object)genericDocument2);
            collection.add(d * genericDocument2.getConfidenceWeight());
        }
        double weightedConf = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
        Map<GenericDocumentType, DocumentDataExtractionResult> $this$map$iv2 = this.documentsState;
        boolean $i$f$map2 = false;
        Map<GenericDocumentType, DocumentDataExtractionResult> $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            GenericDocument genericDocument = ((DocumentDataExtractionResult)it.getValue()).getDocument();
            Intrinsics.checkNotNull((Object)genericDocument);
            collection.add(genericDocument.getConfidenceWeight());
        }
        double weights = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv2));
        if (weights == 0.0) {
            return 1.0;
        }
        return weightedConf / weights;
    }

    private final DocumentDataExtractionStep calculateStep() {
        Object object;
        block10: {
            block9: {
                DocumentDataExtractionStep documentDataExtractionStep;
                object = this.currentPack;
                if (object == null) break block9;
                DocumentDataExtractionPack pack = object;
                boolean bl = false;
                if (this.allSidesExtracted(pack)) {
                    documentDataExtractionStep = this.isHighAverageConfidence() ? DocumentDataExtractionStep.ALL_DONE : DocumentDataExtractionStep.EXTRACTING_FRONT;
                } else {
                    DocumentDataExtractionPack documentDataExtractionPack = pack;
                    if (documentDataExtractionPack instanceof DocumentDataExtractionPack.TwoSidedPack) {
                        documentDataExtractionStep = this.processTwoSided((DocumentDataExtractionPack.TwoSidedPack)pack);
                    } else if (documentDataExtractionPack instanceof DocumentDataExtractionPack.OneSidedPack) {
                        documentDataExtractionStep = DocumentDataExtractionStep.EXTRACTING_FRONT;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object = documentDataExtractionStep;
                if (documentDataExtractionStep != null) break block10;
            }
            object = DocumentDataExtractionStep.INITIAL;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allSidesExtracted(DocumentDataExtractionPack pack) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = pack.getAllTypes();
        Set<GenericDocumentType> set = this.documentsState.keySet();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RootDocumentType rootDocumentType = (RootDocumentType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return set.containsAll((List)destination$iv$iv);
    }

    private final DocumentDataExtractionStep processTwoSided(DocumentDataExtractionPack.TwoSidedPack pack) {
        return this.documentsState.containsKey(pack.getFrontType().getType()) ? (this.isHighAverageConfidence() ? DocumentDataExtractionStep.FRONT_DONE : DocumentDataExtractionStep.EXTRACTING_FRONT) : (this.documentsState.containsKey(pack.getBackType().getType()) ? (this.isHighAverageConfidence() ? DocumentDataExtractionStep.BACK_DONE : DocumentDataExtractionStep.EXTRACTING_BACK) : DocumentDataExtractionStep.INITIAL);
    }

    private final boolean isHighAverageConfidence() {
        return this.averageConfidence() > 0.9;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/documentdata/DocumentDataExtractionSession$Companion;", "", "()V", "HIGH_CONFIDENCE_VALUE", "", "MODERATE_CONFIDENCE_VALUE", "ZERO_CONFIDENCE_VALUE", "rtu-ui-documentdata_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

