/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.genericdocument.list;

import android.graphics.Bitmap;
import androidx.recyclerview.widget.DiffUtil;
import io.scanbot.genericdocument.entity.CommonFieldType;
import io.scanbot.genericdocument.entity.OcrResult;
import io.scanbot.sdk.ui.view.genericdocument.list.FieldViewModel;
import io.scanbot.sdk.ui.view.genericdocument.list.GenericDocumentListViewModel;
import io.scanbot.sdk.ui.view.genericdocument.list.SectionViewModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/list/DocumentFieldDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lio/scanbot/sdk/ui/view/genericdocument/list/GenericDocumentListViewModel;", "()V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "rtu-ui-genericdocument_release"})
final class DocumentFieldDiffCallback
extends DiffUtil.ItemCallback<GenericDocumentListViewModel> {
    public boolean areItemsTheSame(@NotNull GenericDocumentListViewModel oldItem, @NotNull GenericDocumentListViewModel newItem) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (oldItem.getType() != newItem.getType()) {
            return false;
        }
        GenericDocumentListViewModel genericDocumentListViewModel = oldItem;
        if (genericDocumentListViewModel instanceof FieldViewModel) {
            FieldViewModel cfr_ignored_0 = (FieldViewModel)newItem;
            bl = Intrinsics.areEqual((Object)((FieldViewModel)oldItem).getField().getType(), (Object)((FieldViewModel)newItem).getField().getType());
        } else if (genericDocumentListViewModel instanceof SectionViewModel) {
            SectionViewModel cfr_ignored_1 = (SectionViewModel)newItem;
            bl = Intrinsics.areEqual((Object)((SectionViewModel)oldItem).getHeader(), (Object)((SectionViewModel)newItem).getHeader());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areContentsTheSame(@NotNull GenericDocumentListViewModel oldItem, @NotNull GenericDocumentListViewModel newItem) {
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (oldItem.getType() != newItem.getType()) {
            return false;
        }
        GenericDocumentListViewModel genericDocumentListViewModel = oldItem;
        if (genericDocumentListViewModel instanceof FieldViewModel) {
            FieldViewModel cfr_ignored_0 = (FieldViewModel)newItem;
            Object[] objectArray = new CommonFieldType[]{CommonFieldType.Photo, CommonFieldType.Signature};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)((FieldViewModel)oldItem).getField().getType().getCommonType())) {
                Bitmap bitmap = ((FieldViewModel)oldItem).getField().getImage();
                if (bitmap == null) return false;
                boolean bl = bitmap.sameAs(((FieldViewModel)newItem).getField().getImage());
                return bl;
            }
            OcrResult ocrResult = ((FieldViewModel)oldItem).getField().getValue();
            OcrResult ocrResult2 = ((FieldViewModel)newItem).getField().getValue();
            if (!Intrinsics.areEqual((Object)(ocrResult != null ? ocrResult.getText() : null), (Object)(ocrResult2 != null ? ocrResult2.getText() : null))) return false;
            OcrResult ocrResult3 = ((FieldViewModel)oldItem).getField().getValue();
            OcrResult ocrResult4 = ((FieldViewModel)newItem).getField().getValue();
            if (!Intrinsics.areEqual((Float)(ocrResult3 != null ? Float.valueOf(ocrResult3.getConfidence()) : null), (Float)(ocrResult4 != null ? Float.valueOf(ocrResult4.getConfidence()) : null))) return false;
            return true;
        }
        if (!(genericDocumentListViewModel instanceof SectionViewModel)) throw new NoWhenBranchMatchedException();
        SectionViewModel cfr_ignored_1 = (SectionViewModel)newItem;
        return Intrinsics.areEqual((Object)((SectionViewModel)oldItem).getHeader(), (Object)((SectionViewModel)newItem).getHeader());
    }
}

