/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.genericdocument;

import io.scanbot.genericdocument.entity.GenericDocument;
import io.scanbot.genericdocument.entity.GenericDocumentLibrary;
import io.scanbot.genericdocument.entity.GenericDocumentWrapper;
import io.scanbot.genericdocument.entity.RootDocumentType;
import io.scanbot.sdk.genericdocument.GenericDocumentRecognitionResult;
import io.scanbot.sdk.genericdocument.GenericDocumentRecognizer;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionPack;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionPacks;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionState;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\b\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\rJ\b\u0010*\u001a\u00020\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession;", "", "genericDocumentRecognizer", "Lio/scanbot/sdk/genericdocument/GenericDocumentRecognizer;", "(Lio/scanbot/sdk/genericdocument/GenericDocumentRecognizer;)V", "currentPack", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionPack;", "documentsState", "", "Lio/scanbot/genericdocument/entity/GenericDocument$Type;", "Lio/scanbot/genericdocument/entity/GenericDocument;", "scanPaused", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "scanReady", "stateSubject", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionState;", "allSidesScanned", "pack", "averageConfidence", "", "calculateStep", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionStep;", "clear", "", "getAllDocuments", "", "isHighAverageConfidence", "observeDocumentRecognitionResults", "Lkotlinx/coroutines/flow/SharedFlow;", "observeScanReadyState", "Lkotlinx/coroutines/flow/StateFlow;", "observeScanningPausedState", "processTwoSided", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionPack$TwoSidedPack;", "pushNewDocumentRecognitionResult", "result", "Lio/scanbot/sdk/genericdocument/GenericDocumentRecognitionResult;", "pushScanReadyState", "ready", "pushScanningPausedState", "opened", "updateState", "Companion", "rtu-ui-genericdocument_release"})
@SourceDebugExtension(value={"SMAP\nGenericDocumentScanningSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericDocumentScanningSession.kt\nio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DocumentsModel.kt\nio/scanbot/genericdocument/entity/GenericDocumentLibrary\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1#2:212\n1767#3:213\n125#4:214\n152#4,3:215\n125#4:218\n152#4,3:219\n1549#5:222\n1620#5,3:223\n*S KotlinDebug\n*F\n+ 1 GenericDocumentScanningSession.kt\nio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession\n*L\n49#1:213\n114#1:214\n114#1:215,3\n118#1:218\n118#1:219,3\n144#1:222\n144#1:223,3\n*E\n"})
public final class GenericDocumentScanningSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GenericDocumentRecognizer genericDocumentRecognizer;
    @NotNull
    private final Map<GenericDocument.Type, GenericDocument> documentsState;
    @NotNull
    private final MutableStateFlow<DocumentRecognitionState> stateSubject;
    @NotNull
    private final MutableStateFlow<Boolean> scanReady;
    @NotNull
    private final MutableStateFlow<Boolean> scanPaused;
    @Nullable
    private DocumentRecognitionPack currentPack;
    public static final double ZERO_CONFIDENCE_VALUE = 0.0;
    public static final double MODERATE_CONFIDENCE_VALUE = 0.5;
    public static final double HIGH_CONFIDENCE_VALUE = 0.9;

    public GenericDocumentScanningSession(@NotNull GenericDocumentRecognizer genericDocumentRecognizer) {
        Intrinsics.checkNotNullParameter((Object)genericDocumentRecognizer, (String)"genericDocumentRecognizer");
        this.genericDocumentRecognizer = genericDocumentRecognizer;
        this.documentsState = new LinkedHashMap();
        this.stateSubject = StateFlowKt.MutableStateFlow((Object)new DocumentRecognitionState(0.0, DocumentRecognitionStep.NOT_READY, MapsKt.emptyMap()));
        this.scanReady = StateFlowKt.MutableStateFlow((Object)false);
        this.scanPaused = StateFlowKt.MutableStateFlow((Object)false);
    }

    @NotNull
    public final SharedFlow<DocumentRecognitionState> observeDocumentRecognitionResults() {
        return (SharedFlow)this.stateSubject;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushNewDocumentRecognitionResult(@NotNull GenericDocumentRecognitionResult result) {
        block6: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            GenericDocument genericDocument = result.getDocument();
            if (genericDocument != null) {
                void this_$iv;
                Object v1;
                GenericDocument.Type type;
                GenericDocument document;
                block5: {
                    document = genericDocument;
                    boolean bl = false;
                    type = document.getType();
                    Iterable iterable = DocumentRecognitionPacks.INSTANCE.getPacks();
                    for (Object t : iterable) {
                        DocumentRecognitionPack it = (DocumentRecognitionPack)t;
                        boolean bl2 = false;
                        if (!it.contains(type)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                DocumentRecognitionPack documentRecognitionPack = v1;
                if (documentRecognitionPack == null) {
                    return;
                }
                DocumentRecognitionPack typePack = documentRecognitionPack;
                if (this.currentPack != null && !Intrinsics.areEqual((Object)typePack, (Object)this.currentPack)) {
                    return;
                }
                this.currentPack = typePack;
                GenericDocumentLibrary genericDocumentLibrary = GenericDocumentLibrary.INSTANCE;
                GenericDocument $this$wrap$iv = document;
                boolean $i$f$wrap = false;
                GenericDocumentWrapper wrap = this_$iv.wrapperFromGenericDocument($this$wrap$iv);
                this.documentsState.put(type, document);
                this.updateState();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block6;
            this.updateState();
        }
    }

    @NotNull
    public final StateFlow<Boolean> observeScanReadyState() {
        return (StateFlow)this.scanReady;
    }

    @NotNull
    public final StateFlow<Boolean> observeScanningPausedState() {
        return (StateFlow)this.scanPaused;
    }

    public final void pushScanReadyState(boolean ready) {
        this.scanReady.setValue((Object)ready);
    }

    public final void pushScanningPausedState(boolean opened) {
        this.scanPaused.setValue((Object)opened);
    }

    public final void clear() {
        this.genericDocumentRecognizer.clear();
        this.documentsState.clear();
        this.currentPack = null;
        this.updateState();
    }

    @NotNull
    public final Set<GenericDocument> getAllDocuments() {
        return CollectionsKt.toSet((Iterable)this.documentsState.values());
    }

    private final void updateState() {
        this.stateSubject.setValue((Object)new DocumentRecognitionState(this.averageConfidence(), this.calculateStep(), MapsKt.toMap(this.documentsState)));
    }

    /*
     * WARNING - void declaration
     */
    private final double averageConfidence() {
        void $this$mapTo$iv$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        if (this.documentsState.isEmpty()) {
            return 0.0;
        }
        Map<GenericDocument.Type, GenericDocument> $this$map$iv = this.documentsState;
        boolean $i$f$map = false;
        Map<GenericDocument.Type, GenericDocument> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            void it;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(((GenericDocument)it.getValue()).getConfidence() * ((GenericDocument)it.getValue()).getConfidenceWeight()));
        }
        float weightedConf = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
        Map<GenericDocument.Type, GenericDocument> $this$map$iv2 = this.documentsState;
        boolean $i$f$map2 = false;
        Map<GenericDocument.Type, GenericDocument> $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Float.valueOf(((GenericDocument)it.getValue()).getConfidenceWeight()));
        }
        double weights = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv2));
        if (weights == 0.0) {
            return 1.0;
        }
        return (double)weightedConf / weights;
    }

    private final DocumentRecognitionStep calculateStep() {
        Object object;
        block10: {
            block9: {
                DocumentRecognitionStep documentRecognitionStep;
                object = this.currentPack;
                if (object == null) break block9;
                DocumentRecognitionPack pack = object;
                boolean bl = false;
                if (this.allSidesScanned(pack)) {
                    documentRecognitionStep = this.isHighAverageConfidence() ? DocumentRecognitionStep.ALL_DONE : DocumentRecognitionStep.SCANNING_FRONT;
                } else {
                    DocumentRecognitionPack documentRecognitionPack = pack;
                    if (documentRecognitionPack instanceof DocumentRecognitionPack.TwoSidedPack) {
                        documentRecognitionStep = this.processTwoSided((DocumentRecognitionPack.TwoSidedPack)pack);
                    } else if (documentRecognitionPack instanceof DocumentRecognitionPack.OneSidedPack) {
                        documentRecognitionStep = DocumentRecognitionStep.SCANNING_FRONT;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object = documentRecognitionStep;
                if (documentRecognitionStep != null) break block10;
            }
            object = DocumentRecognitionStep.INITIAL;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allSidesScanned(DocumentRecognitionPack pack) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = pack.getAllTypes();
        Set<GenericDocument.Type> set = this.documentsState.keySet();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RootDocumentType rootDocumentType = (RootDocumentType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return set.containsAll((List)destination$iv$iv);
    }

    private final DocumentRecognitionStep processTwoSided(DocumentRecognitionPack.TwoSidedPack pack) {
        return this.documentsState.containsKey(pack.getFrontType().getType()) ? (this.isHighAverageConfidence() ? DocumentRecognitionStep.FRONT_DONE : DocumentRecognitionStep.SCANNING_FRONT) : (this.documentsState.containsKey(pack.getBackType().getType()) ? (this.isHighAverageConfidence() ? DocumentRecognitionStep.BACK_DONE : DocumentRecognitionStep.SCANNING_BACK) : DocumentRecognitionStep.INITIAL);
    }

    private final boolean isHighAverageConfidence() {
        return this.averageConfidence() > 0.9;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession$Companion;", "", "()V", "HIGH_CONFIDENCE_VALUE", "", "MODERATE_CONFIDENCE_VALUE", "ZERO_CONFIDENCE_VALUE", "rtu-ui-genericdocument_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

