/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.vin.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import com.google.gson.Gson;
import io.scanbot.sdk.AspectRatio;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonAspectRatio;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonCameraPreviewMode;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonOrientationLockMode;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.vin.configuration.VinScannerConfigurationParams;
import io.scanbot.sdk.ui.view.vin.configuration.json.VinScannerJsonConfiguration;
import io.scanbot.sdk.ui.vin.R;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\b\b\u0001\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\n2\b\b\u0001\u0010\"\u001a\u00020\u0012J\u0010\u0010#\u001a\u00020\n2\b\b\u0001\u0010$\u001a\u00020\u0012J\u0010\u0010%\u001a\u00020\n2\b\b\u0001\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0012J\u000e\u0010.\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0012J\u0010\u0010/\u001a\u00020\n2\b\b\u0001\u00100\u001a\u00020\u0012J\u000e\u00101\u001a\u00020\n2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020\n2\b\b\u0001\u00108\u001a\u00020\u0012J\u0010\u00109\u001a\u00020\n2\b\b\u0001\u0010:\u001a\u00020\u0012J\u0010\u0010;\u001a\u00020\n2\b\b\u0001\u0010<\u001a\u00020\u0012J\u000e\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020)R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/ui/view/vin/configuration/VinScannerConfiguration;", "", "()V", "vinScannerConfig", "", "", "Ljava/io/Serializable;", "getVinScannerConfig", "()Ljava/util/Map;", "modifyFromJsonConfiguration", "", "jsonConfig", "Lio/scanbot/sdk/ui/view/vin/configuration/json/VinScannerJsonConfiguration;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderAspectRatio", "finderAspectRatio", "Lio/scanbot/sdk/AspectRatio;", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFinderTextHintColor", "finderTextHintColor", "setFlashEnabled", "flashEnabled", "", "setGuidanceText", "guidanceText", "setMaximumNumberOfAccumulatedFrames", "numberOfFrames", "setMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "setOcrResolutionLimit", "ocrResolutionLimit", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setSignificantShakeDelay", "significantShakeDelay", "", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsColor", "topBarButtonsColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "Companion", "rtu-ui-vin_release"})
public final class VinScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Serializable> vinScannerConfig = new HashMap();

    @NotNull
    public final Map<String, Serializable> getVinScannerConfig() {
        return this.vinScannerConfig;
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.vinScannerConfig.put(VinScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.vinScannerConfig.put(VinScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.vinScannerConfig.put(VinScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.vinScannerConfig.put(VinScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        Integer n = topBarButtonsColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.TOP_BAR_BUTTONS_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        Integer n = cameraOverlayColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.CAMERA_OVERLAY_COLOR.getKey(), n);
    }

    public final void setFinderLineWidth(@Px int finderLineWidth) {
        Integer n = finderLineWidth;
        this.vinScannerConfig.put(VinScannerConfigurationParams.FINDER_LINE_WIDTH.getKey(), n);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Integer n = finderLineColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.FINDER_LINE_COLOR.getKey(), n);
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        Integer n = finderTextHintColor;
        this.vinScannerConfig.put(VinScannerConfigurationParams.FINDER_TEXT_HINT_COLOR.getKey(), n);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.vinScannerConfig.put(VinScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        Integer n = cancelButtonIcon;
        this.vinScannerConfig.put(VinScannerConfigurationParams.CANCEL_BUTTON_ICON.getKey(), n);
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.vinScannerConfig.put(VinScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.vinScannerConfig.put(VinScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(int numberOfFrames) {
        Integer n = numberOfFrames;
        this.vinScannerConfig.put(VinScannerConfigurationParams.MINIMUM_NUMBER_OF_REQUIRED_FRAMES_WITH_EQUAL_RECOGNITION_RESULT.getKey(), n);
    }

    public final void setMaximumNumberOfAccumulatedFrames(int numberOfFrames) {
        Integer n = numberOfFrames;
        this.vinScannerConfig.put(VinScannerConfigurationParams.MAXIMUM_NUMBER_OF_ACCUMULATED_FRAMES.getKey(), n);
    }

    public final void setOcrResolutionLimit(@Px int ocrResolutionLimit) {
        Integer n = ocrResolutionLimit;
        this.vinScannerConfig.put(VinScannerConfigurationParams.OCR_RESOLUTION_LIMIT.getKey(), n);
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.vinScannerConfig.put(VinScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    public final void setFinderAspectRatio(@NotNull AspectRatio finderAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"finderAspectRatio");
        this.vinScannerConfig.put(VinScannerConfigurationParams.FINDER_ASPECT_RATIO.getKey(), (Serializable)finderAspectRatio);
    }

    public final void setSignificantShakeDelay(long significantShakeDelay) {
        Long l = significantShakeDelay;
        this.vinScannerConfig.put(VinScannerConfigurationParams.SIGNIFICANT_SHAKE_DELAY.getKey(), l);
    }

    public final void setGuidanceText(@NotNull String guidanceText) {
        Intrinsics.checkNotNullParameter((Object)guidanceText, (String)"guidanceText");
        this.vinScannerConfig.put(VinScannerConfigurationParams.GUIDANCE_TEXT.getKey(), (Serializable)((Object)guidanceText));
    }

    public final void modifyFromJsonConfiguration(@NotNull VinScannerJsonConfiguration jsonConfig) {
        block23: {
            JsonAspectRatio jsonAspectRatio;
            Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
            Boolean bl = jsonConfig.getFlashEnabled();
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                this.setFlashEnabled(it);
            }
            JsonOrientationLockMode jsonOrientationLockMode = jsonConfig.getOrientationLockMode();
            if (jsonOrientationLockMode != null) {
                JsonOrientationLockMode it = jsonOrientationLockMode;
                boolean bl3 = false;
                CameraOrientationMode cameraOrientationMode = CommonExtensionsKt.toSdk((JsonOrientationLockMode)it);
                if (cameraOrientationMode != null) {
                    CameraOrientationMode lockMode = cameraOrientationMode;
                    boolean bl4 = false;
                    this.setOrientationLockMode(lockMode);
                }
            }
            JsonCameraModule jsonCameraModule = jsonConfig.getCameraModule();
            if (jsonCameraModule != null) {
                JsonCameraModule it = jsonCameraModule;
                boolean bl5 = false;
                this.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)it));
            }
            JsonCameraPreviewMode jsonCameraPreviewMode = jsonConfig.getCameraPreviewMode();
            if (jsonCameraPreviewMode != null) {
                JsonCameraPreviewMode it = jsonCameraPreviewMode;
                boolean bl6 = false;
                this.setCameraPreviewMode(CommonExtensionsKt.toSdk((JsonCameraPreviewMode)it));
            }
            JsonColor jsonColor = jsonConfig.getTopBarBackgroundColor();
            if (jsonColor != null) {
                JsonColor it = jsonColor;
                boolean bl7 = false;
                this.setTopBarBackgroundColor(it.toSdk());
            }
            JsonColor jsonColor2 = jsonConfig.getTopBarButtonsActiveColor();
            if (jsonColor2 != null) {
                JsonColor it = jsonColor2;
                boolean bl8 = false;
                this.setTopBarButtonsColor(it.toSdk());
            }
            JsonColor jsonColor3 = jsonConfig.getTopBarButtonsInactiveColor();
            if (jsonColor3 != null) {
                JsonColor it = jsonColor3;
                boolean bl9 = false;
                this.setTopBarButtonsInactiveColor(it.toSdk());
            }
            JsonColor jsonColor4 = jsonConfig.getCameraOverlayColor();
            if (jsonColor4 != null) {
                JsonColor it = jsonColor4;
                boolean bl10 = false;
                this.setCameraOverlayColor(it.toSdk());
            }
            Double d = jsonConfig.getFinderLineWidth();
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl11 = false;
                this.setFinderLineWidth((int)it);
            }
            JsonColor jsonColor5 = jsonConfig.getFinderLineColor();
            if (jsonColor5 != null) {
                JsonColor it = jsonColor5;
                boolean bl12 = false;
                this.setFinderLineColor(it.toSdk());
            }
            JsonColor jsonColor6 = jsonConfig.getFinderTextHintColor();
            if (jsonColor6 != null) {
                JsonColor it = jsonColor6;
                boolean bl13 = false;
                this.setFinderTextHintColor(it.toSdk());
            }
            String string = jsonConfig.getCancelButtonTitle();
            if (string != null) {
                String it = string;
                boolean bl14 = false;
                this.setCancelButtonTitle(it);
            }
            Boolean bl15 = jsonConfig.getReplaceCancelButtonWithIcon();
            if (bl15 != null) {
                boolean it = bl15;
                boolean bl16 = false;
                if (it) {
                    this.setCancelButtonIcon(R.drawable.scanbot_arrow_back_24);
                }
            }
            String string2 = jsonConfig.getEnableCameraButtonTitle();
            if (string2 != null) {
                String it = string2;
                boolean bl17 = false;
                this.setEnableCameraButtonTitle(it);
            }
            String string3 = jsonConfig.getEnableCameraExplanationText();
            if (string3 != null) {
                String it = string3;
                boolean bl18 = false;
                this.setEnableCameraExplanationText(it);
            }
            Integer n = jsonConfig.getMinimumNumberOfRequiredFramesWithEqualRecognitionResult();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl19 = false;
                this.setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(it);
            }
            Integer n2 = jsonConfig.getMaximumNumberOfAccumulatedFrames();
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl20 = false;
                this.setMaximumNumberOfAccumulatedFrames(it);
            }
            Long l = jsonConfig.getOcrResolutionLimit();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl21 = false;
                this.setOcrResolutionLimit((int)it);
            }
            Boolean bl22 = jsonConfig.getUseButtonsAllCaps();
            if (bl22 != null) {
                boolean it = bl22;
                boolean bl23 = false;
                this.setUseButtonsAllCaps(it);
            }
            if ((jsonAspectRatio = jsonConfig.getAspectRatio()) != null && (jsonAspectRatio = CommonExtensionsKt.toSdk((JsonAspectRatio)jsonAspectRatio)) != null) {
                JsonAspectRatio it = jsonAspectRatio;
                boolean bl24 = false;
                this.setFinderAspectRatio((AspectRatio)it);
            }
            Long l2 = jsonConfig.getSignificantShakeDelay();
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                boolean bl25 = false;
                this.setSignificantShakeDelay(it);
            }
            String string4 = jsonConfig.getGuidanceText();
            if (string4 == null) break block23;
            String it = string4;
            boolean bl26 = false;
            this.setGuidanceText(it);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/vin/configuration/VinScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/vin/configuration/VinScannerConfiguration;", "input", "", "rtu-ui-vin_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VinScannerConfiguration fromJson(@NotNull String input) {
            VinScannerConfiguration vinScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            VinScannerJsonConfiguration jsonConfig = (VinScannerJsonConfiguration)gson.fromJson(input, VinScannerJsonConfiguration.class);
            VinScannerConfiguration $this$fromJson_u24lambda_u2d0 = vinScannerConfiguration = new VinScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return vinScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

