/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.pdf.model.PdfConfiguration;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.Page;
import io.scanbot.sdk.docprocessing.compose.PagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfGeneratorInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.compose.UrisInput;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OcrEngine;
import io.scanbot.sdk.ocr.ScanbotOcrEngine;
import io.scanbot.sdk.ocr.intelligence.OcrPdfGenerator;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.SandwichingPdfOcrPerformer;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.process.PdfGenerator;
import io.scanbot.sdk.util.FileChooserUtils;
import io.scanbot.sdk.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u0001:\u0001?BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J;\u0010\u0017\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010&J3\u0010\u0017\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J%\u0010+\u001a\u0004\u0018\u00010\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010,J+\u0010+\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010-J3\u0010.\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010/J-\u0010.\u001a\u0004\u0018\u00010\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u00100J \u00101\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u00101\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u00102\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J.\u00102\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J6\u00104\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u00104\u001a\u0004\u0018\u00010\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#032\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#03H\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\b\u00109\u001a\u00020\u001eH\u0002J\u0018\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/process/ScanbotPdfGenerator;", "Lio/scanbot/sdk/process/PdfGenerator;", "context", "Landroid/content/Context;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "ocrGenerator", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "sapManager", "Lio/scanbot/sap/SapManager;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sap/SapManager;)V", "checkMissingLangs", "", "ocrConfig", "Lio/scanbot/sdk/ocr/OcrEngine$OcrConfig;", "generate", "", "sourceDocument", "Lio/scanbot/sdk/docprocessing/Document;", "outputFile", "Ljava/io/File;", "legacyDocument", "Lio/scanbot/sdk/entity/Document;", "pdfConfig", "Lio/scanbot/pdf/model/PdfConfiguration;", "imageFileUris", "", "Landroid/net/Uri;", "document", "sourceFilesEncrypted", "([Landroid/net/Uri;Ljava/io/File;Lio/scanbot/sdk/entity/Document;ZLio/scanbot/pdf/model/PdfConfiguration;)Z", "pages", "Lio/scanbot/sdk/persistence/page/legacy/Page;", "([Lio/scanbot/sdk/persistence/page/legacy/Page;Ljava/io/File;Lio/scanbot/sdk/entity/Document;Lio/scanbot/pdf/model/PdfConfiguration;)Z", "generateFromDocument", "generateFromPages", "([Lio/scanbot/sdk/persistence/page/legacy/Page;Lio/scanbot/pdf/model/PdfConfiguration;)Ljava/io/File;", "([Lio/scanbot/sdk/persistence/page/legacy/Page;Ljava/io/File;Lio/scanbot/pdf/model/PdfConfiguration;)Z", "generateFromUris", "([Landroid/net/Uri;Ljava/io/File;ZLio/scanbot/pdf/model/PdfConfiguration;)Z", "([Landroid/net/Uri;ZLio/scanbot/pdf/model/PdfConfiguration;)Ljava/io/File;", "generateWithOcrFromDocument", "generateWithOcrFromPages", "", "generateWithOcrFromUris", "getFilesFromContentUri", "getInstalledLanguages", "", "Lio/scanbot/sdk/entity/Language;", "getPendingDocument", "saveStreamToFile", "fileOutputStream", "Ljava/io/OutputStream;", "inputSteam", "Ljava/io/InputStream;", "Companion", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nScanbotPdfGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotPdfGenerator.kt\nio/scanbot/sdk/process/ScanbotPdfGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,388:1\n1549#2:389\n1620#2,3:390\n1549#2:396\n1620#2,2:397\n1622#2:400\n1855#2,2:401\n1549#2:403\n1620#2,3:404\n766#2:407\n857#2,2:408\n1549#2:410\n1620#2,3:411\n1549#2:414\n1620#2,2:415\n1622#2:418\n1549#2:419\n1620#2,2:420\n1622#2:423\n1549#2:424\n1620#2,3:425\n1549#2:428\n1620#2,3:429\n3792#3:393\n4307#3,2:394\n36#4:399\n36#4:417\n36#4:422\n*S KotlinDebug\n*F\n+ 1 ScanbotPdfGenerator.kt\nio/scanbot/sdk/process/ScanbotPdfGenerator\n*L\n91#1:389\n91#1:390,3\n96#1:396\n96#1:397,2\n96#1:400\n103#1:401,2\n181#1:403\n181#1:404,3\n197#1:407\n197#1:408,2\n197#1:410\n197#1:411,3\n232#1:414\n232#1:415,2\n232#1:418\n258#1:419\n258#1:420,2\n258#1:423\n322#1:424\n322#1:425,3\n348#1:428\n348#1:429,3\n91#1:393\n91#1:394,2\n96#1:399\n232#1:417\n258#1:422\n*E\n"})
public final class ScanbotPdfGenerator
implements PdfGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CACHE_DIR = "scanbotPdfRenderer";
    @NotNull
    private final Context context;
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final OcrPdfGenerator ocrGenerator;
    @NotNull
    private final DocumentStoreStrategy documentStoreStrategy;
    @NotNull
    private final BlobManager blobManager;
    @NotNull
    private final SimpleComposer simpleComposer;
    @NotNull
    private final OcrSettings ocrSettings;
    @NotNull
    private final SapManager sapManager;

    /*
     * WARNING - void declaration
     */
    public ScanbotPdfGenerator(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrPdfGenerator ocrGenerator, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobManager blobManager, @NotNull SimpleComposer simpleComposer, @NotNull OcrSettings ocrSettings, @NotNull SapManager sapManager) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"ocrGenerator");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"sapManager");
        this.context = var1_1;
        this.fileIOProcessor = var2_2;
        this.ocrGenerator = var3_3;
        this.documentStoreStrategy = var4_4;
        this.blobManager = var5_5;
        this.simpleComposer = var6_6;
        this.ocrSettings = var7_7;
        this.sapManager = var8_8;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean generate(Uri[] imageFileUris, File outputFile, Document document, boolean sourceFilesEncrypted, PdfConfiguration pdfConfig) {
        void var3_3;
        void var2_2;
        void var5_5;
        void var4_4;
        UrisInput urisInput;
        ArrayList arrayList;
        ArrayList arrayList2;
        SimpleComposer simpleComposer;
        Object object;
        if (!((ScanbotPdfGenerator)this_).sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return false;
        }
        List<File> list = ((ScanbotPdfGenerator)this_).getFilesFromContentUri(ArraysKt.toList((Object[])object));
        SimpleComposer simpleComposer2 = simpleComposer;
        simpleComposer = new ArrayList(CollectionsKt.collectionSizeOrDefault(list, (int)10));
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            simpleComposer2.add(Uri.fromFile((File)((File)object2.next())));
        }
        object2 = arrayList2;
        arrayList2 = new ArrayList();
        for (void var11_12 : object) {
            if (!StringsKt.equals$default((String)var11_12.getScheme(), (String)"file", (boolean)false, (int)2, null)) continue;
            object2.add(var11_12);
        }
        object = CollectionsKt.plus(simpleComposer2, (Iterable)object2);
        simpleComposer2 = ((ScanbotPdfGenerator)this_).simpleComposer;
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Uri uri;
            Uri uri2 = uri = (Uri)object.next();
            Intrinsics.checkNotNull((Object)uri2);
            Uri uri3 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)((ScanbotPdfGenerator)this_).context, (Uri)uri2)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(this)");
            object2.add(uri3);
        }
        Object this_ = urisInput;
        urisInput = new UrisInput((List)object2, (boolean)var4_4, (PdfConfiguration)var5_5, (File)var2_2);
        simpleComposer2.composeDocument((Document)var3_3, (PdfGeneratorInput)this_);
        this_ = list.iterator();
        while (this_.hasNext()) {
            ((File)this_.next()).delete();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean generate(io.scanbot.sdk.persistence.page.legacy.Page[] pages, File outputFile, Document document, PdfConfiguration pdfConfig) {
        void var3_3;
        void var2_2;
        void var4_4;
        void var1_1;
        PagesInput pagesInput;
        if (!this_.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return false;
        }
        ScanbotPdfGenerator this_ = pagesInput;
        pagesInput = new PagesInput(ArraysKt.toList((Object[])var1_1), (PdfConfiguration)var4_4, (File)var2_2);
        this_.simpleComposer.composeDocument((Document)var3_3, (PdfGeneratorInput)this_);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean generate(io.scanbot.sdk.docprocessing.Document sourceDocument, File outputFile, Document legacyDocument, PdfConfiguration pdfConfig) {
        void var2_2;
        void var4_4;
        void var3_3;
        ArrayList<Uri> arrayList;
        Object object;
        if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return false;
        }
        object = object.getPages();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getDocumentFileUri());
        }
        this.simpleComposer.composeDocument((Document)var3_3, (PdfGeneratorInput)new UrisInput(arrayList2, this.fileIOProcessor.getUseEncryption(), (PdfConfiguration)var4_4, (File)var2_2));
        return true;
    }

    private final List<File> getFilesFromContentUri(List<? extends Uri> imageFileUris) {
        ArrayList arrayList;
        ArrayList arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        for (Object object2 : imageFileUris) {
            if (!StringsKt.equals$default((String)((Uri)object2).getScheme(), (String)"content", (boolean)false, (int)2, null)) continue;
            object.add(object2);
        }
        ArrayList arrayList3 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Uri uri = (Uri)object.next();
            InputStream inputStream = this.context.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                File file;
                Intrinsics.checkNotNull((Object)inputStream);
                File file2 = file;
                new File(FileUtils.getExternalCacheDirOrShowError((Context)this.context, (String)CACHE_DIR), UUID.randomUUID().toString() + ".jpg").createNewFile();
                OutputStream outputStream = this.fileIOProcessor.openFileOutputStream(file2);
                if (outputStream != null) {
                    this.saveStreamToFile(outputStream, inputStream);
                    arrayList3.add(file2);
                    continue;
                }
                throw new IOException("Can't create output stream for temporary image file " + file2.getPath());
            }
            throw new IOException("Can't get input stream from content uri " + uri.getPath());
        }
        return arrayList3;
    }

    private final Set<Language> getInstalledLanguages() {
        return this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMissingLangs(OcrEngine.OcrConfig ocrConfig) {
        void var1_1;
        if (ocrConfig.getEngineMode() == OcrEngine.EngineMode.SCANBOT_OCR) {
            return;
        }
        Set set = SetsKt.minus((Set)var1_1.getLanguages(), ((ScanbotPdfGenerator)((Object)set)).getInstalledLanguages());
        if (!(set.isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException((Set)set + " Provided set of languages was not presented on device");
    }

    private final Document getPendingDocument() {
        Document document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        document.id = string;
        document.name = (String)string + ".pdf";
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveStreamToFile(OutputStream fileOutputStream, InputStream inputSteam) {
        ScanbotPdfGenerator scanbotPdfGenerator;
        OutputStream outputStream = fileOutputStream;
        ScanbotPdfGenerator scanbotPdfGenerator2 = null;
        try {
            void var2_3;
            outputStream.write(ByteStreamsKt.readBytes((InputStream)var2_3));
            scanbotPdfGenerator = scanbotPdfGenerator2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var1_2;
                CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)outputStream, (Throwable)((Object)scanbotPdfGenerator));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File generateFromUris(@NotNull Uri[] imageFileUris, boolean sourceFilesEncrypted, @NotNull PdfConfiguration pdfConfig) {
        void var2_2;
        Document document;
        void var3_3;
        Object object;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        void v1 = object;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this_;
        Intrinsics.checkNotNullParameter((Object)object, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        void v4 = object;
        this_();
        ((Document)this_).id = object = UUID.randomUUID().toString() + ".pdf";
        ((Document)this_).name = object;
        document.pagesCount = ((void)v4).length;
        String string = object;
        object = scanbotPdfGenerator2.documentStoreStrategy.getDocumentFile(string, string);
        if (!scanbotPdfGenerator.generate((Uri[])v1, (File)object, (Document)this_, (boolean)var2_2, (PdfConfiguration)var3_3)) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateFromUris(@NotNull Uri[] imageFileUris, @NotNull File outputFile, boolean sourceFilesEncrypted, @NotNull PdfConfiguration pdfConfig) {
        void var3_3;
        Document document;
        void var4_4;
        void var2_2;
        String string;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        void v1 = string;
        Intrinsics.checkNotNullParameter((Object)string, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        void v3 = string;
        this_();
        string = UUID.randomUUID().toString() + ".pdf";
        ((Document)this_).id = string;
        ((Document)this_).name = string;
        document.pagesCount = ((void)v3).length;
        return scanbotPdfGenerator.generate((Uri[])v1, (File)var2_2, (Document)this_, (boolean)var3_3, (PdfConfiguration)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File generateFromPages(@NotNull io.scanbot.sdk.persistence.page.legacy.Page[] pages, @NotNull PdfConfiguration pdfConfig) {
        Document document;
        void var2_2;
        Object object;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        void v1 = object;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this_;
        Intrinsics.checkNotNullParameter((Object)object, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        void v4 = object;
        this_();
        ((Document)this_).id = object = UUID.randomUUID().toString() + ".pdf";
        ((Document)this_).name = object;
        document.pagesCount = ((void)v4).length;
        String string = object;
        object = scanbotPdfGenerator2.documentStoreStrategy.getDocumentFile(string, string);
        if (!scanbotPdfGenerator.generate((io.scanbot.sdk.persistence.page.legacy.Page[])v1, (File)object, (Document)this_, (PdfConfiguration)var2_2)) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateFromPages(@NotNull io.scanbot.sdk.persistence.page.legacy.Page[] pages, @NotNull File outputFile, @NotNull PdfConfiguration pdfConfig) {
        Document document;
        void var3_3;
        void var2_2;
        String string;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        void v1 = string;
        Intrinsics.checkNotNullParameter((Object)string, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        void v3 = string;
        this_();
        string = UUID.randomUUID().toString() + ".pdf";
        ((Document)this_).id = string;
        ((Document)this_).name = string;
        document.pagesCount = ((void)v3).length;
        return scanbotPdfGenerator.generate((io.scanbot.sdk.persistence.page.legacy.Page[])v1, (File)var2_2, (Document)this_, (PdfConfiguration)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document sourceDocument, @NotNull PdfConfiguration pdfConfig) {
        Document document;
        void var2_2;
        void var1_1;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceDocument");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        this_();
        ((Document)this_).id = var1_1.getUuid() + ".pdf";
        ((Document)this_).name = var1_1.getUuid();
        document.pagesCount = var1_1.getPageCount();
        return scanbotPdfGenerator.generate((io.scanbot.sdk.docprocessing.Document)v1, UriKt.toFile((Uri)v1.getPdfUri()), (Document)this_, (PdfConfiguration)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document sourceDocument, @NotNull File outputFile, @NotNull PdfConfiguration pdfConfig) {
        Document document;
        void var3_3;
        void var2_2;
        void var1_1;
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceDocument");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        ScanbotPdfGenerator this_ = document;
        this_();
        ((Document)this_).id = var1_1.getUuid() + ".pdf";
        ((Document)this_).name = var1_1.getUuid();
        document.pagesCount = var1_1.getPageCount();
        return scanbotPdfGenerator.generate((io.scanbot.sdk.docprocessing.Document)var1_1, (File)var2_2, (Document)this_, (PdfConfiguration)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File generateWithOcrFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        void var2_2;
        ScanbotOcrEngine.UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var3_3;
        ScanbotOcrEngine.UrisInput urisInput2;
        void var4_4;
        ScanbotPdfGenerator scanbotPdfGenerator3;
        ScanbotPdfGenerator scanbotPdfGenerator = scanbotPdfGenerator3;
        ScanbotPdfGenerator scanbotPdfGenerator2 = scanbotPdfGenerator3;
        void v2 = var4_4;
        Intrinsics.checkNotNullParameter((Object)urisInput2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"ocrConfig");
        scanbotPdfGenerator2.checkMissingLangs((OcrEngine.OcrConfig)v2);
        SapManager sapManager = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = var4_4.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document = scanbotPdfGenerator.getPendingDocument();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)urisInput2, (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)scanbotPdfGenerator3.context, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        scanbotPdfGenerator3 = var4_4.getEngineMode();
        urisInput2 = urisInput;
        urisInput = new ScanbotOcrEngine.UrisInput(arrayList2, (boolean)var2_2, (OcrEngine.EngineMode)scanbotPdfGenerator3, (PdfConfiguration)var3_3, null, 16, null);
        return new SandwichingPdfOcrPerformer((SapManager)sapManager, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document, (ScanbotOcrEngine.EngineInput)urisInput2).recognize().sandwichedPdfDocumentFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithOcrFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull File outputFile, boolean sourceFilesEncrypted, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        void var3_3;
        ScanbotOcrEngine.UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var4_4;
        void var2_2;
        ScanbotOcrEngine.UrisInput urisInput2;
        void var5_5;
        ScanbotPdfGenerator scanbotPdfGenerator3;
        ScanbotPdfGenerator scanbotPdfGenerator = scanbotPdfGenerator3;
        ScanbotPdfGenerator scanbotPdfGenerator2 = scanbotPdfGenerator3;
        void v2 = var5_5;
        Intrinsics.checkNotNullParameter((Object)urisInput2, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"ocrConfig");
        scanbotPdfGenerator2.checkMissingLangs((OcrEngine.OcrConfig)v2);
        SapManager sapManager = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = var5_5.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document = scanbotPdfGenerator.getPendingDocument();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)urisInput2, (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)scanbotPdfGenerator3.context, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        scanbotPdfGenerator3 = var5_5.getEngineMode();
        urisInput2 = urisInput;
        urisInput = new ScanbotOcrEngine.UrisInput(arrayList2, (boolean)var3_3, (OcrEngine.EngineMode)scanbotPdfGenerator3, (PdfConfiguration)var4_4, (File)var2_2);
        return new SandwichingPdfOcrPerformer((SapManager)sapManager, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document, (ScanbotOcrEngine.EngineInput)urisInput2).recognize().sandwichedPdfDocument != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithOcrFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        ScanbotOcrEngine.PagesInput pagesInput;
        void var2_2;
        void var1_1;
        void var3_3;
        void v0 = var3_3;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"ocrConfig");
        this_.checkMissingLangs((OcrEngine.OcrConfig)v0);
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this_;
        ScanbotPdfGenerator this_ = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = var3_3.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document = scanbotPdfGenerator.getPendingDocument();
        ScanbotPdfGenerator scanbotPdfGenerator3 = this_;
        this_ = pagesInput;
        pagesInput = new ScanbotOcrEngine.PagesInput((List)var1_1, var3_3.getEngineMode(), (PdfConfiguration)var2_2, null, 8, null);
        return new SandwichingPdfOcrPerformer((SapManager)scanbotPdfGenerator3, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document, (ScanbotOcrEngine.EngineInput)this_).recognize().sandwichedPdfDocument != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithOcrFromPages(@NotNull List<io.scanbot.sdk.persistence.page.legacy.Page> pages, @NotNull File outputFile, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        ScanbotOcrEngine.PagesInput pagesInput;
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        void v0 = var4_4;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"ocrConfig");
        this_.checkMissingLangs((OcrEngine.OcrConfig)v0);
        ScanbotPdfGenerator scanbotPdfGenerator = this_;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this_;
        ScanbotPdfGenerator this_ = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = var4_4.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document = scanbotPdfGenerator.getPendingDocument();
        ScanbotPdfGenerator scanbotPdfGenerator3 = this_;
        this_ = pagesInput;
        pagesInput = new ScanbotOcrEngine.PagesInput((List)var1_1, var4_4.getEngineMode(), (PdfConfiguration)var3_3, (File)var2_2);
        return new SandwichingPdfOcrPerformer((SapManager)scanbotPdfGenerator3, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document, (ScanbotOcrEngine.EngineInput)this_).recognize().sandwichedPdfDocument != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithOcrFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document document, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        ScanbotOcrEngine.UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var2_3;
        OcrEngine.EngineMode engineMode;
        File file;
        ScanbotPdfGenerator scanbotPdfGenerator = this;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this;
        void v2 = file;
        Intrinsics.checkNotNullParameter((Object)engineMode, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"ocrConfig");
        scanbotPdfGenerator2.checkMissingLangs((OcrEngine.OcrConfig)v2);
        SapManager sapManager = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = file.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document2 = scanbotPdfGenerator.getPendingDocument();
        Object object = document.getPages();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getDocumentFileUri());
        }
        void v4 = engineMode;
        boolean bl = this.fileIOProcessor.getUseEncryption();
        engineMode = file.getEngineMode();
        file = UriKt.toFile((Uri)v4.getPdfUri());
        object = urisInput;
        urisInput = new ScanbotOcrEngine.UrisInput(arrayList2, bl, engineMode, (PdfConfiguration)var2_3, file);
        return new SandwichingPdfOcrPerformer((SapManager)sapManager, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document2, (ScanbotOcrEngine.EngineInput)object).recognize().sandwichedPdfDocument != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithOcrFromDocument(@NotNull io.scanbot.sdk.docprocessing.Document document, @NotNull File outputFile, @NotNull PdfConfiguration pdfConfig, @NotNull OcrEngine.OcrConfig ocrConfig) {
        ScanbotOcrEngine.UrisInput urisInput;
        ArrayList<Uri> arrayList;
        void var3_4;
        void var2_3;
        SapManager sapManager;
        OcrEngine.EngineMode engineMode;
        ScanbotPdfGenerator scanbotPdfGenerator = this;
        ScanbotPdfGenerator scanbotPdfGenerator2 = this;
        void v2 = engineMode;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)var3_4, (String)"pdfConfig");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"ocrConfig");
        scanbotPdfGenerator2.checkMissingLangs((OcrEngine.OcrConfig)v2);
        sapManager = scanbotPdfGenerator2.sapManager;
        OcrPdfGenerator ocrPdfGenerator = scanbotPdfGenerator2.ocrGenerator;
        Set set = engineMode.getLanguages();
        DocumentStoreStrategy documentStoreStrategy = scanbotPdfGenerator.documentStoreStrategy;
        SimpleComposer simpleComposer = scanbotPdfGenerator.simpleComposer;
        OcrSettings ocrSettings = scanbotPdfGenerator.ocrSettings;
        Document document2 = scanbotPdfGenerator.getPendingDocument();
        Object object = document.getPages();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getDocumentFileUri());
        }
        boolean bl = this.fileIOProcessor.getUseEncryption();
        engineMode = engineMode.getEngineMode();
        object = urisInput;
        urisInput = new ScanbotOcrEngine.UrisInput(arrayList2, bl, engineMode, (PdfConfiguration)var3_4, (File)var2_3);
        return new SandwichingPdfOcrPerformer((SapManager)sapManager, (OcrPdfGenerator)ocrPdfGenerator, (Set)set, (DocumentStoreStrategy)documentStoreStrategy, (SimpleComposer)simpleComposer, (OcrSettings)ocrSettings, (Document)document2, (ScanbotOcrEngine.EngineInput)object).recognize().sandwichedPdfDocument != null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/process/ScanbotPdfGenerator$Companion;", "", "()V", "CACHE_DIR", "", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

