/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.di;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.DefaultBarcodeScanner;
import io.scanbot.sdk.barcode.StubBarcodeScanner;
import io.scanbot.sdk.barcode.document.BarcodeDocumentParser;
import io.scanbot.sdk.barcode.document.DefaultBarcodeDocumentParser;
import io.scanbot.sdk.barcode.document.StubBarcodeDocumentParser;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalLruStorage;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalRepository;
import io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.check.CheckScanner;
import io.scanbot.sdk.check.DefaultCheckScanner;
import io.scanbot.sdk.check.StubCheckScanner;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.creditcard.CreditCardScanner;
import io.scanbot.sdk.creditcard.DefaultCreditCardScanner;
import io.scanbot.sdk.creditcard.StubCreditCardScanner;
import io.scanbot.sdk.di.BundleDependencyCheck;
import io.scanbot.sdk.di.DependencyCheckUtils;
import io.scanbot.sdk.di.RequiredDependency;
import io.scanbot.sdk.di.ScanbotSdkModule;
import io.scanbot.sdk.docprocessing.DefaultDraftDocumentProcessor;
import io.scanbot.sdk.docprocessing.DefaultPdfPagesExtractor;
import io.scanbot.sdk.docprocessing.DocumentApi;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessorMonitor;
import io.scanbot.sdk.docprocessing.DraftDocumentProcessor;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.compose.BaseComposerFactory;
import io.scanbot.sdk.docprocessing.compose.ComposerCache;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.InternalComposerCache;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.draft.CombinedDocumentDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.CompositeDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.MultipleDocumentsDraftExtractor;
import io.scanbot.sdk.docprocessing.legacy.DraftPageProcessor;
import io.scanbot.sdk.docprocessing.legacy.PageProcessor;
import io.scanbot.sdk.document.DefaultDocumentScanner;
import io.scanbot.sdk.document.DocumentScanner;
import io.scanbot.sdk.document.DocumentScannerConfiguration;
import io.scanbot.sdk.document.StubDocumentScanner;
import io.scanbot.sdk.documentdata.DefaultDocumentDataExtractor;
import io.scanbot.sdk.documentdata.DocumentDataExtractor;
import io.scanbot.sdk.documentdata.StubDocumentDataExtractor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.hicscanner.DefaultHealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.StubHealthInsuranceCardScanner;
import io.scanbot.sdk.intelligence.ImageProcessorBitmapBinarizer;
import io.scanbot.sdk.mc.DefaultMedicalCertificateScanner;
import io.scanbot.sdk.mc.MedicalCertificateScanner;
import io.scanbot.sdk.mc.StubMedicalCertificateScanner;
import io.scanbot.sdk.mrz.DefaultMrzScanner;
import io.scanbot.sdk.mrz.MrzScanner;
import io.scanbot.sdk.mrz.StubMrzScanner;
import io.scanbot.sdk.ocr.OcrEngine;
import io.scanbot.sdk.ocr.ScanbotOcrEngine;
import io.scanbot.sdk.ocr.intelligence.OcrPdfGenerator;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.compose.OcrComposer;
import io.scanbot.sdk.pdf.DefaultPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.pdf.PdfiumPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfiumPdfPagesExtractor;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.persistence.document.DocumentStorage;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.persistence.page.DocumentPageStorage;
import io.scanbot.sdk.persistence.page.DocumentPageStorageProcessor;
import io.scanbot.sdk.persistence.page.PageFileStorage;
import io.scanbot.sdk.persistence.page.PageStorageSettings;
import io.scanbot.sdk.persistence.page.legacy.LegacyPageStorage;
import io.scanbot.sdk.persistence.page.legacy.PageStorageProcessor;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageFileStorage;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageStorage;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageStorageProcessor;
import io.scanbot.sdk.process.DefaultDocumentQualityAnalyzer;
import io.scanbot.sdk.process.DocumentQualityAnalyzer;
import io.scanbot.sdk.process.PdfGenerator;
import io.scanbot.sdk.process.ScanbotPdfGenerator;
import io.scanbot.sdk.process.StubDocumentQualityAnalyzer;
import io.scanbot.sdk.process.compose.P2ComposerFactory;
import io.scanbot.sdk.security.SapProvider;
import io.scanbot.sdk.textpattern.DefaultTextPatternScanner;
import io.scanbot.sdk.textpattern.StubTextPatternScanner;
import io.scanbot.sdk.textpattern.TextPatternScanner;
import io.scanbot.sdk.tiff.TiffGenerator;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.result.ResultStorage;
import io.scanbot.sdk.vin.DefaultVinScanner;
import io.scanbot.sdk.vin.StubVinScanner;
import io.scanbot.sdk.vin.VinScanner;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u009e\u00012\u00020\u0001:\u0002\u009e\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J`\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#H\u0007J'\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%2\u0017\u0010&\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010#0'\u00a2\u0006\u0002\b(H\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020.H\u0007J \u0010/\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u0018\u00104\u001a\u0002052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0007J\u0010\u00108\u001a\u0002092\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u000b\u001a\u00020@2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010I\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010J\u001a\u000207H\u0007J\u0018\u0010K\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010L\u001a\u00020M2\u0006\u00106\u001a\u000207H\u0007J0\u0010N\u001a\u00020O2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J8\u0010P\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010Q\u001a\u000209H\u0007J\b\u0010R\u001a\u00020\u0010H\u0007J\u0018\u0010S\u001a\u00020T2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010U\u001a\u00020VH\u0007J \u0010W\u001a\u00020X2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010U\u001a\u00020VH\u0007J \u0010Y\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\\\u001a\u00020]2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010^\u001a\u00020_2\u0006\u0010U\u001a\u00020VH\u0007J\u0010\u0010`\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020aH\u0007J \u0010b\u001a\u00020c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gH\u0007J \u0010h\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010f\u001a\u00020g2\u0006\u0010i\u001a\u00020cH\u0007J\u0018\u0010j\u001a\u00020\n2\u0006\u0010U\u001a\u00020V2\u0006\u0010J\u001a\u000207H\u0007J\u0010\u0010k\u001a\u00020e2\u0006\u0010J\u001a\u000207H\u0007J\u0010\u0010l\u001a\u00020m2\u0006\u0010\u0007\u001a\u00020\bH\u0007J,\u0010n\u001a\u00020o2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020*0q2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s0qH\u0007J\u0018\u0010t\u001a\u00020\u00182\u0006\u0010u\u001a\u0002052\u0006\u0010v\u001a\u00020MH\u0007J.\u0010w\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010x\u001a\u00020o2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020{0zH\u0007J\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020{0z2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010}\u001a\u00020~2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0011\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0080\u0001H\u0007J9\u0010\u0086\u0001\u001a\u0002032\b\u0010\u0085\u0001\u001a\u00030\u0080\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010G\u001a\u00020H2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0007J\u0012\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J$\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0085\u0001\u001a\u00030\u0080\u0001H\u0007J/\u0010\u0095\u0001\u001a\u0002012\b\u0010\u0085\u0001\u001a\u00030\u0080\u00012\b\u0010\u0096\u0001\u001a\u00030\u008a\u00012\u0006\u0010G\u001a\u00020H2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0007J\u0011\u0010\u0097\u0001\u001a\u00020\b2\u0006\u0010U\u001a\u00020VH\u0007J\u001a\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u009f\u0001"}, d2={"Lio/scanbot/sdk/di/ScanbotSdkModule;", "", "()V", "ocrEngine", "Lio/scanbot/sdk/ocr/OcrEngine;", "context", "Landroid/content/Context;", "sapManager", "Lio/scanbot/sap/SapManager;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator$BitmapBinarizer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfGenerator", "Lio/scanbot/sdk/process/PdfGenerator;", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "draftDocumentProcessor", "Lio/scanbot/sdk/docprocessing/DraftDocumentProcessor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "cleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "provideBarcodeScannerUiResultInternalLruStorage", "Lio/scanbot/sdk/ui/result/ResultStorage;", "provideBarcodeScannerUiResultInternalRepository", "Lio/scanbot/sdk/ui/result/ResultRepository;", "storages", "", "Lkotlin/jvm/JvmSuppressWildcards;", "provideBaseComposerFactory", "Lio/scanbot/sdk/docprocessing/compose/BaseComposerFactory;", "jpegComposer", "Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "provideCameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "provideCleaner", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/page/legacy/PageStorageProcessor;", "draftPageStorageProcessor", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageStorageProcessor;", "provideCombinedDocumentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/CombinedDocumentDraftExtractor;", "sharedPreferences", "Landroid/content/SharedPreferences;", "provideComposerCache", "Lio/scanbot/sdk/docprocessing/compose/ComposerCache;", "provideCreditCardScanner", "Lio/scanbot/sdk/creditcard/CreditCardScanner;", "provideDocumentApi", "Lio/scanbot/sdk/docprocessing/DocumentApi;", "documentStorage", "Lio/scanbot/sdk/persistence/document/DocumentStorage;", "Lio/scanbot/sdk/persistence/page/PageFileStorage;", "provideDocumentDataExtractor", "Lio/scanbot/sdk/documentdata/DocumentDataExtractor;", "provideDocumentPageStorageProcessor", "Lio/scanbot/sdk/persistence/page/DocumentPageStorageProcessor;", "documentPageStorage", "Lio/scanbot/sdk/persistence/page/DocumentPageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/page/PageStorageSettings;", "provideDocumentStoreStrategy", "preferences", "provideJpegComposer", "provideMultipleDocumentsDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/MultipleDocumentsDraftExtractor;", "provideOcrComposer", "Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "provideOcrPdfGenerator", "composerCache", "provideOcrSettings", "providePdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "application", "Landroid/app/Application;", "providePdfPagesExtractor", "Lio/scanbot/sdk/docprocessing/PdfPagesExtractor;", "provideSimpleComposer", "provideTextPatternScanner", "Lio/scanbot/sdk/textpattern/TextPatternScanner;", "provideVinScanner", "Lio/scanbot/sdk/vin/VinScanner;", "providesBarcodeFileStorage", "Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "providesBitmapBinarizer", "Lio/scanbot/sdk/intelligence/ImageProcessorBitmapBinarizer;", "providesBlobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "blobsStorage", "Lio/scanbot/sdk/connectivity/BlobsStorage;", "assetManager", "Landroid/content/res/AssetManager;", "providesBlobManager", "blobFactory", "providesBlobStoreStrategy", "providesBlobsStorage", "providesCheckScanner", "Lio/scanbot/sdk/check/CheckScanner;", "providesComposerFactory", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "baseComposerFactory", "Ldagger/Lazy;", "p2ComposerFactory", "Lio/scanbot/sdk/process/compose/P2ComposerFactory;", "providesDocumentDraftExtractor", "combinedDocumentDraftExtractor", "multipleDocumentsDraftExtractor", "providesDocumentProcessor", "composerFactory", "documentProcessorMonitor", "Lio/scanbot/sdk/docprocessing/ProcessorMonitor;", "Lio/scanbot/sdk/entity/Document;", "providesDocumentProcessorMonitor", "providesDocumentQualityAnalyzer", "Lio/scanbot/sdk/process/DocumentQualityAnalyzer;", "providesDocumentScanner", "Lio/scanbot/sdk/document/DocumentScanner;", "providesDraftPageProcessor", "Lio/scanbot/sdk/docprocessing/legacy/DraftPageProcessor;", "draftPageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageFileStorage;", "documentScanner", "providesDraftPageStorageProcessor", "draftPageStorage", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageStorage;", "mainPageStorage", "Lio/scanbot/sdk/persistence/page/legacy/LegacyPageStorage;", "imageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "providesHICScanner", "Lio/scanbot/sdk/hicscanner/HealthInsuranceCardScanner;", "providesMRZScanner", "Lio/scanbot/sdk/mrz/MrzScanner;", "providesMedicalCertificateScanner", "Lio/scanbot/sdk/mc/MedicalCertificateScanner;", "providesPageProcessor", "Lio/scanbot/sdk/docprocessing/legacy/PageProcessor;", "providesPageStorageProcessor", "pageStorage", "providesSapManager", "providesTiffWriter", "Lio/scanbot/sdk/tiff/TiffGenerator;", "scanbotBarcodeDocumentParser", "Lio/scanbot/sdk/barcode/document/BarcodeDocumentParser;", "scanbotBarcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "Companion", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nScanbotSdkModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSdkModule.kt\nio/scanbot/sdk/di/ScanbotSdkModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,675:1\n223#2,2:676\n*S KotlinDebug\n*F\n+ 1 ScanbotSdkModule.kt\nio/scanbot/sdk/di/ScanbotSdkModule\n*L\n650#1:676,2\n*E\n"})
public final class ScanbotSdkModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static DocumentDraftExtractor a;
    @Nullable
    private static OcrSettings b;
    @Nullable
    private static CameraUiSettings c;
    @NotNull
    private static DocumentScannerConfiguration d;
    @Nullable
    private static PdfImagesExtractorSettings e;

    static {
        d = new DocumentScannerConfiguration(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeFileStorage providesBarcodeFileStorage(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new BarcodeFileStorage((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobStoreStrategy providesBlobStoreStrategy(@NotNull Application application, @NotNull SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new BlobStoreStrategy((Application)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobsStorage providesBlobsStorage(@NotNull SharedPreferences preferences) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new BlobsStorage((SharedPreferences)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobFactory providesBlobFactory(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BlobsStorage blobsStorage, @NotNull AssetManager assetManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobsStorage");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        return new BlobFactory((BlobStoreStrategy)var1_1, (BlobsStorage)var2_2, (AssetManager)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobManager providesBlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)blobFactory, (String)"blobFactory");
        return new BlobManager((BlobStoreStrategy)var1_1, (AssetManager)var2_2, (BlobFactory)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ProcessorMonitor<Document> providesDocumentProcessorMonitor(@NotNull DocumentStoreStrategy documentStoreStrategy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        return new DocumentProcessorMonitor((DocumentStoreStrategy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentDraftExtractor providesDocumentDraftExtractor(@NotNull CombinedDocumentDraftExtractor combinedDocumentDraftExtractor, @NotNull MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"combinedDocumentDraftExtractor");
        Intrinsics.checkNotNullParameter((Object)multipleDocumentsDraftExtractor, (String)"multipleDocumentsDraftExtractor");
        ScanbotSdkModule scanbotSdkModule = a;
        if (scanbotSdkModule == null) {
            void var2_2;
            CompositeDraftExtractor compositeDraftExtractor;
            scanbotSdkModule = compositeDraftExtractor;
            compositeDraftExtractor = new CompositeDraftExtractor((CombinedDocumentDraftExtractor)var1_1, (MultipleDocumentsDraftExtractor)var2_2);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SapManager providesSapManager(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new SapProvider((Application)var1_1).get();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftDocumentProcessor providesDocumentProcessor(@NotNull SapManager sapManager, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull ComposerFactory composerFactory, @NotNull ProcessorMonitor<Document> documentProcessorMonitor) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"composerFactory");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"documentProcessorMonitor");
        if (!sapManager.checkLicenseStatus(SdkFeature.NoSdkFeature).booleanValue()) {
            DraftDocumentProcessor draftDocumentProcessor;
            this = draftDocumentProcessor;
            draftDocumentProcessor = new DraftDocumentProcessor(){

                @NotNull
                public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) {
                    File file;
                    File file2;
                    Intrinsics.checkNotNullParameter((Object)documentDraft, (String)"documentDraft");
                    void v0 = file2;
                    providesDocumentProcessor.1 this_ = v0.document;
                    file2 = file;
                    file = new File("/");
                    return new DocumentProcessingResult((Document)this_, v0.pages, file2);
                }
            };
        } else {
            DefaultDraftDocumentProcessor defaultDraftDocumentProcessor;
            this = defaultDraftDocumentProcessor;
            defaultDraftDocumentProcessor = new DefaultDraftDocumentProcessor((DocumentStoreStrategy)var2_2, (ComposerFactory)var3_3, (ProcessorMonitor)var4_4);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentApi provideDocumentApi(@NotNull DocumentStorage documentStorage, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new DocumentApi((DocumentStorage)var1_1, (PageFileStorage)var2_2, (FileIOProcessor)var3_3){
            final /* synthetic */ DocumentStorage a;
            final /* synthetic */ PageFileStorage b;
            final /* synthetic */ FileIOProcessor c;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
                this.c = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public io.scanbot.sdk.docprocessing.Document createDocument(int documentImageSizeLimit) {
                void var1_1;
                provideDocumentApi.1 v0 = this_;
                provideDocumentApi.1 this_ = v0.a;
                PageFileStorage pageFileStorage = v0.b;
                FileIOProcessor fileIOProcessor = v0.c;
                io.scanbot.sdk.docprocessing.Document document = new io.scanbot.sdk.docprocessing.Document((DocumentStorage)this_, pageFileStorage, fileIOProcessor, (int)var1_1);
                document.saveSync();
                return document;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public io.scanbot.sdk.docprocessing.Document loadDocument(@NotNull String documentId) {
                io.scanbot.sdk.docprocessing.Document document;
                void var1_2;
                void v0 = var1_2;
                Intrinsics.checkNotNullParameter((Object)v0, (String)"documentId");
                if (this_.isDocumentExist((String)v0)) {
                    io.scanbot.sdk.docprocessing.Document document2;
                    document = document2;
                    provideDocumentApi.1 v2 = this_;
                    provideDocumentApi.1 this_ = v2.a;
                    PageFileStorage pageFileStorage = v2.b;
                    FileIOProcessor fileIOProcessor = v2.c;
                    int n = io.scanbot.sdk.docprocessing.Document.Companion.getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT();
                    document2 = new io.scanbot.sdk.docprocessing.Document((DocumentStorage)this_, pageFileStorage, fileIOProcessor, (String)var1_2, false, n);
                } else {
                    document = null;
                }
                return document;
            }

            @NotNull
            public List<String> storedDocumentIds() {
                return this.a.getStoredDocuments();
            }

            /*
             * WARNING - void declaration
             */
            public boolean deleteDocument(@NotNull String uuid) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uuid");
                return this.a.delete((String)var1_1);
            }

            public boolean deleteAllDocuments() {
                return this.a.deleteAll();
            }

            /*
             * WARNING - void declaration
             */
            public boolean isDocumentExist(@NotNull String documentId) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentId");
                return this.storedDocumentIds().contains(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final SimpleComposer provideSimpleComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new SimpleComposer((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2, (FileIOProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ComposerCache provideComposerCache(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new InternalComposerCache((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final JpegComposer provideJpegComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        return new JpegComposer((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentStoreStrategy provideDocumentStoreStrategy(@NotNull Context context, @NotNull SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new DocumentStoreStrategy((Context)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrPdfGenerator provideOcrPdfGenerator(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull OcrPdfGenerator.BitmapBinarizer bitmapBinarizer, @NotNull FileIOProcessor fileIOProcessor, @NotNull ComposerCache composerCache) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)composerCache, (String)"composerCache");
        return new OcrPdfGenerator((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var3_3, (BlobStoreStrategy)var2_2, (OcrPdfGenerator.BitmapBinarizer)var4_4, (FileIOProcessor)var5_5, (ComposerCache)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrComposer provideOcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        return new OcrComposer((BlobManager)var1_1, (OcrPdfGenerator)var2_2, (SimpleComposer)var3_3, (SapManager)var4_4, (OcrSettings)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentScanner providesDocumentScanner(@NotNull SapManager sapManager) {
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.EdgeDetection)) {
            DefaultDocumentScanner defaultDocumentScanner;
            DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.DOCUMENT_SCANNER);
            this = defaultDocumentScanner;
            defaultDocumentScanner = new DefaultDocumentScanner(d);
        } else {
            void var1_1;
            StubDocumentScanner stubDocumentScanner;
            this = stubDocumentScanner;
            stubDocumentScanner = new StubDocumentScanner((SapManager)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeScanner scanbotBarcodeScanner(@NotNull SapManager sapManager) {
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            DefaultBarcodeScanner defaultBarcodeScanner;
            DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.BARCODE);
            this = defaultBarcodeScanner;
            defaultBarcodeScanner = new DefaultBarcodeScanner();
        } else {
            void var1_1;
            StubBarcodeScanner stubBarcodeScanner;
            this = stubBarcodeScanner;
            stubBarcodeScanner = new StubBarcodeScanner((SapManager)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeDocumentParser scanbotBarcodeDocumentParser(@NotNull SapManager sapManager) {
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            DefaultBarcodeDocumentParser defaultBarcodeDocumentParser;
            this = defaultBarcodeDocumentParser;
            defaultBarcodeDocumentParser = new DefaultBarcodeDocumentParser();
        } else {
            void var1_1;
            StubBarcodeDocumentParser stubBarcodeDocumentParser;
            this = stubBarcodeDocumentParser;
            stubBarcodeDocumentParser = new StubBarcodeDocumentParser((SapManager)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final CombinedDocumentDraftExtractor provideCombinedDocumentDraftExtractor(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SharedPreferences sharedPreferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        return new CombinedDocumentDraftExtractor((DocumentStoreStrategy)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final MultipleDocumentsDraftExtractor provideMultipleDocumentsDraftExtractor(@NotNull SharedPreferences sharedPreferences) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        return new MultipleDocumentsDraftExtractor((SharedPreferences)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BaseComposerFactory provideBaseComposerFactory(@NotNull SimpleComposer simpleComposer, @NotNull JpegComposer jpegComposer) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)jpegComposer, (String)"jpegComposer");
        return new BaseComposerFactory((SimpleComposer)var1_1, (JpegComposer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final Cleaner provideCleaner(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStorageProcessor pageStorageProcessor, @NotNull DraftPageStorageProcessor draftPageStorageProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorageProcessor");
        Intrinsics.checkNotNullParameter((Object)draftPageStorageProcessor, (String)"draftPageStorageProcessor");
        return new Cleaner((DocumentStoreStrategy)var1_1, (PageStorageProcessor)var2_2, (DraftPageStorageProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PdfGenerator pdfGenerator(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull DraftDocumentProcessor draftDocumentProcessor, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull Cleaner cleaner, @NotNull SapManager sapManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull BlobManager blobManager, @NotNull OcrSettings ocrSettings) {
        void var11_11;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentDraftExtractor");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"draftDocumentProcessor");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"cleaner");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var9_9, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var10_10, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        return new ScanbotPdfGenerator((Context)var1_1, (FileIOProcessor)var2_2, (OcrPdfGenerator)var9_9, (DocumentStoreStrategy)var5_5, (BlobManager)var10_10, (SimpleComposer)var6_6, (OcrSettings)var11_11, (SapManager)var8_8);
    }

    @Provides
    @Singleton
    @NotNull
    public final OcrSettings provideOcrSettings() {
        ScanbotSdkModule scanbotSdkModule = b;
        if (scanbotSdkModule == null) {
            scanbotSdkModule = new OcrSettings.Builder().build();
        }
        return scanbotSdkModule;
    }

    @Provides
    @NotNull
    public final OcrPdfGenerator.BitmapBinarizer providesBitmapBinarizer(@NotNull ImageProcessorBitmapBinarizer bitmapBinarizer) {
        ImageProcessorBitmapBinarizer imageProcessorBitmapBinarizer = bitmapBinarizer;
        Intrinsics.checkNotNullParameter((Object)imageProcessorBitmapBinarizer, (String)"bitmapBinarizer");
        return imageProcessorBitmapBinarizer;
    }

    @Provides
    @NotNull
    public final DocumentQualityAnalyzer providesDocumentQualityAnalyzer(@NotNull SapManager sapManager) {
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.ImageProcessing)) {
            DefaultDocumentQualityAnalyzer defaultDocumentQualityAnalyzer;
            DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.DQA);
            this = defaultDocumentQualityAnalyzer;
            defaultDocumentQualityAnalyzer = new DefaultDocumentQualityAnalyzer();
        } else {
            StubDocumentQualityAnalyzer stubDocumentQualityAnalyzer;
            this = stubDocumentQualityAnalyzer;
            stubDocumentQualityAnalyzer = new StubDocumentQualityAnalyzer();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final TiffGenerator providesTiffWriter(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new TiffGenerator((Context)var1_1, (FileIOProcessor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftPageProcessor providesDraftPageProcessor(@NotNull FileIOProcessor fileIOProcessor, @NotNull DraftPageFileStorage draftPageFileStorage, @NotNull DocumentScanner documentScanner) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"draftPageFileStorage");
        Intrinsics.checkNotNullParameter((Object)documentScanner, (String)"documentScanner");
        return new DraftPageProcessor((FileIOProcessor)var1_1, (DraftPageFileStorage)var2_2, (DocumentScanner)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PageProcessor providesPageProcessor(@NotNull FileIOProcessor fileIOProcessor, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull DocumentScanner documentScanner) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)documentScanner, (String)"documentScanner");
        return new PageProcessor((FileIOProcessor)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2, (DocumentScanner)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PageStorageProcessor providesPageStorageProcessor(@NotNull DocumentScanner documentScanner, @NotNull LegacyPageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentScanner");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)imageFileIOProcessor, (String)"imageFileIOProcessor");
        return new PageStorageProcessor((DocumentScanner)var1_1, (LegacyPageStorage)var2_2, (PageStorageSettings)var3_3, (ImageFileIOProcessor)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftPageStorageProcessor providesDraftPageStorageProcessor(@NotNull DocumentScanner documentScanner, @NotNull DraftPageStorage draftPageStorage, @NotNull LegacyPageStorage mainPageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentScanner");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"draftPageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"mainPageStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)imageFileIOProcessor, (String)"imageFileIOProcessor");
        return new DraftPageStorageProcessor((DocumentScanner)var1_1, (DraftPageStorage)var2_2, (LegacyPageStorage)var3_3, (PageStorageSettings)var4_4, (ImageFileIOProcessor)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentPageStorageProcessor provideDocumentPageStorageProcessor(@NotNull DocumentPageStorage documentPageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentPageStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new DocumentPageStorageProcessor((DocumentPageStorage)var1_1, (PageStorageSettings)var2_2, (ImageFileIOProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ComposerFactory providesComposerFactory(@NotNull SapManager sapManager, @NotNull Lazy<BaseComposerFactory> baseComposerFactory, @NotNull Lazy<P2ComposerFactory> p2ComposerFactory) {
        ComposerFactory composerFactory;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"baseComposerFactory");
        Intrinsics.checkNotNullParameter(p2ComposerFactory, (String)"p2ComposerFactory");
        if (DependencyCheckUtils.INSTANCE.isSdkP2() && var1_1.checkLicenseStatusSilently(SdkFeature.OCR)) {
            void var3_3;
            Object object = var3_3.get();
            Intrinsics.checkNotNull((Object)object);
            composerFactory = (ComposerFactory)object;
        } else {
            Object object = var2_2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            composerFactory = (ComposerFactory)object;
        }
        return composerFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrEngine ocrEngine(@NotNull Context context, @NotNull SapManager sapManager, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfGenerator.BitmapBinarizer bitmapBinarizer, @NotNull BlobManager blobManager) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        if (DependencyCheckUtils.INSTANCE.isSdkP2() && var2_2.checkLicenseStatusSilently(SdkFeature.OCR)) {
            ScanbotOcrEngine scanbotOcrEngine;
            this = scanbotOcrEngine;
            scanbotOcrEngine = new ScanbotOcrEngine((Context)var1_1, (BlobManager)var8_8, (SapManager)var2_2, (BlobStoreStrategy)var3_3, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var4_4, (FileIOProcessor)var5_5, (OcrSettings)var6_6, (OcrPdfGenerator.BitmapBinarizer)var7_7);
        } else {
            ScanbotOcrEngine scanbotOcrEngine;
            this = scanbotOcrEngine;
            scanbotOcrEngine = new ScanbotOcrEngine((Context)var1_1, (BlobManager)var8_8, (SapManager)var2_2, (BlobStoreStrategy)var3_3, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var4_4, (FileIOProcessor)var5_5, (OcrSettings)var6_6, (OcrPdfGenerator.BitmapBinarizer)var7_7);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final TextPatternScanner provideTextPatternScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP2() && var1_1.checkLicenseStatusSilently(SdkFeature.TextLineRecognition)) {
            DefaultTextPatternScanner defaultTextPatternScanner;
            ScanbotSdkModule scanbotSdkModule2 = scanbotSdkModule;
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.COMMON_OCR);
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.TEXT_PATTERN);
            scanbotSdkModule = defaultTextPatternScanner;
            defaultTextPatternScanner = new DefaultTextPatternScanner();
        } else {
            StubTextPatternScanner stubTextPatternScanner;
            scanbotSdkModule = stubTextPatternScanner;
            stubTextPatternScanner = new StubTextPatternScanner();
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final VinScanner provideVinScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP2() && var1_1.checkLicenseStatusSilently(SdkFeature.TextLineRecognition)) {
            DefaultVinScanner defaultVinScanner;
            ScanbotSdkModule scanbotSdkModule2 = scanbotSdkModule;
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.COMMON_OCR);
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.TEXT_PATTERN);
            scanbotSdkModule = defaultVinScanner;
            defaultVinScanner = new DefaultVinScanner();
        } else {
            StubVinScanner stubVinScanner;
            scanbotSdkModule = stubVinScanner;
            stubVinScanner = new StubVinScanner();
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final MrzScanner providesMRZScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP2() && var1_1.checkLicenseStatusSilently(SdkFeature.MRZRecognition)) {
            DefaultMrzScanner defaultMrzScanner;
            scanbotSdkModule.checkDependency(BundleDependencyCheck.MRZ);
            scanbotSdkModule = defaultMrzScanner;
            defaultMrzScanner = new DefaultMrzScanner();
        } else {
            StubMrzScanner stubMrzScanner;
            scanbotSdkModule = stubMrzScanner;
            stubMrzScanner = new StubMrzScanner((SapManager)var1_1);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final HealthInsuranceCardScanner providesHICScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP3() && var1_1.checkLicenseStatusSilently(SdkFeature.EHICRecognition)) {
            DefaultHealthInsuranceCardScanner defaultHealthInsuranceCardScanner;
            scanbotSdkModule.checkDependency(BundleDependencyCheck.EHIC);
            scanbotSdkModule = defaultHealthInsuranceCardScanner;
            defaultHealthInsuranceCardScanner = new DefaultHealthInsuranceCardScanner();
        } else {
            StubHealthInsuranceCardScanner stubHealthInsuranceCardScanner;
            scanbotSdkModule = stubHealthInsuranceCardScanner;
            stubHealthInsuranceCardScanner = new StubHealthInsuranceCardScanner((SapManager)var1_1);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final MedicalCertificateScanner providesMedicalCertificateScanner(@NotNull SapManager sapManager, @NotNull BlobManager blobManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP4() && var1_1.checkLicenseStatusSilently(SdkFeature.MedicalCertRecognition)) {
            void var2_2;
            DefaultMedicalCertificateScanner defaultMedicalCertificateScanner;
            scanbotSdkModule.checkDependency(BundleDependencyCheck.MC);
            scanbotSdkModule = defaultMedicalCertificateScanner;
            defaultMedicalCertificateScanner = new DefaultMedicalCertificateScanner((BlobManager)var2_2);
        } else {
            StubMedicalCertificateScanner stubMedicalCertificateScanner;
            scanbotSdkModule = stubMedicalCertificateScanner;
            stubMedicalCertificateScanner = new StubMedicalCertificateScanner((SapManager)var1_1);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final CheckScanner providesCheckScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP4() && var1_1.checkLicenseStatusSilently(SdkFeature.Check)) {
            DefaultCheckScanner defaultCheckScanner;
            scanbotSdkModule.checkDependency(BundleDependencyCheck.CHECK);
            scanbotSdkModule = defaultCheckScanner;
            defaultCheckScanner = new DefaultCheckScanner();
        } else {
            StubCheckScanner stubCheckScanner;
            scanbotSdkModule = stubCheckScanner;
            stubCheckScanner = new StubCheckScanner((SapManager)var1_1);
        }
        return scanbotSdkModule;
    }

    @Provides
    @NotNull
    public final DocumentDataExtractor provideDocumentDataExtractor(@NotNull SapManager sapManager) {
        StubDocumentDataExtractor stubDocumentDataExtractor;
        DependencyCheckUtils dependencyCheckUtils;
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        boolean bl = sapManager2.checkLicenseStatusSilently(SdkFeature.IdCardScanning) || dependencyCheckUtils.checkLicenseStatusSilently(SdkFeature.FeatureDriverLicenseRecognition) || dependencyCheckUtils.checkLicenseStatusSilently(SdkFeature.EHICRecognition);
        dependencyCheckUtils = DependencyCheckUtils.INSTANCE;
        if (dependencyCheckUtils.isSdkP3() && bl) {
            DefaultDocumentDataExtractor defaultDocumentDataExtractor;
            DependencyCheckUtils dependencyCheckUtils2 = dependencyCheckUtils;
            dependencyCheckUtils2.checkDependency((RequiredDependency)BundleDependencyCheck.DOCUMENT_DATA);
            dependencyCheckUtils2.checkDependency((RequiredDependency)BundleDependencyCheck.COMMON_OCR);
            stubDocumentDataExtractor = defaultDocumentDataExtractor;
            defaultDocumentDataExtractor = new DefaultDocumentDataExtractor();
        } else {
            StubDocumentDataExtractor stubDocumentDataExtractor2;
            stubDocumentDataExtractor = stubDocumentDataExtractor2;
            stubDocumentDataExtractor2 = new StubDocumentDataExtractor();
        }
        return stubDocumentDataExtractor;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final CreditCardScanner provideCreditCardScanner(@NotNull SapManager sapManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        ScanbotSdkModule scanbotSdkModule = DependencyCheckUtils.INSTANCE;
        if (scanbotSdkModule.isSdkP3() && var1_1.checkLicenseStatusSilently(SdkFeature.CreditCardRecognition)) {
            DefaultCreditCardScanner defaultCreditCardScanner;
            ScanbotSdkModule scanbotSdkModule2 = scanbotSdkModule;
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.COMMON_OCR);
            scanbotSdkModule2.checkDependency(BundleDependencyCheck.CREDIT_CARD);
            scanbotSdkModule = defaultCreditCardScanner;
            defaultCreditCardScanner = new DefaultCreditCardScanner();
        } else {
            StubCreditCardScanner stubCreditCardScanner;
            scanbotSdkModule = stubCreditCardScanner;
            stubCreditCardScanner = new StubCreditCardScanner((SapManager)var1_1);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfImagesExtractor providePdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfImagesExtractor defaultPdfImagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = e;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var2_12;
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor;
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.PDFIUM_PAGES);
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor2 = pdfiumPdfImagesExtractor;
                pdfiumPdfImagesExtractor = new PdfiumPdfImagesExtractor((FileIOProcessor)var1_11, (Context)var2_12);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfImagesExtractor defaultPdfImagesExtractor2 = defaultPdfImagesExtractor;
        defaultPdfImagesExtractor = new DefaultPdfImagesExtractor((FileIOProcessor)var1_11);
        return var0_10;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfPagesExtractor providePdfPagesExtractor(@NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfPagesExtractor defaultPdfPagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var2_12;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var2_12, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = e;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var3_13;
                PdfiumPdfPagesExtractor pdfiumPdfPagesExtractor;
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.PDFIUM_PAGES);
                PdfiumPdfPagesExtractor pdfiumPdfPagesExtractor2 = pdfiumPdfPagesExtractor;
                pdfiumPdfPagesExtractor = new PdfiumPdfPagesExtractor((io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var1_11, (FileIOProcessor)var2_12, (Context)var3_13);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfPagesExtractor defaultPdfPagesExtractor2 = defaultPdfPagesExtractor;
        defaultPdfPagesExtractor = new DefaultPdfPagesExtractor((io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var1_11, (FileIOProcessor)var2_12);
        return var0_10;
    }

    @Provides
    @NotNull
    public final CameraUiSettings provideCameraUiSettings() {
        ScanbotSdkModule scanbotSdkModule = c;
        if (scanbotSdkModule == null) {
            CameraUiSettings cameraUiSettings;
            scanbotSdkModule = cameraUiSettings;
            cameraUiSettings = new CameraUiSettings(true);
        }
        return scanbotSdkModule;
    }

    @Provides
    @IntoSet
    @NotNull
    public final ResultRepository<Object> provideBarcodeScannerUiResultInternalRepository(@NotNull Set<ResultStorage<Object>> storages) {
        Set<ResultStorage<Object>> set = storages;
        Intrinsics.checkNotNullParameter(set, (String)"storages");
        for (Object e2 : set) {
            ResultStorage resultStorage = (ResultStorage)e2;
            if (!Intrinsics.areEqual((Object)resultStorage.getAcceptedType(), BarcodeScannerUiResultInternal.class)) continue;
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.result.ResultStorage<io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal>");
            return new BarcodeScannerUiResultInternalRepository(resultStorage);
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Provides
    @Singleton
    @IntoSet
    @NotNull
    public final ResultStorage<Object> provideBarcodeScannerUiResultInternalLruStorage() {
        return new BarcodeScannerUiResultInternalLruStorage();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lio/scanbot/sdk/di/ScanbotSdkModule$Companion;", "", "()V", "cameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "getCameraUiSettings", "()Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "setCameraUiSettings", "(Lio/scanbot/sdk/ui/camera/CameraUiSettings;)V", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "getDocumentDraftExtractor", "()Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "setDocumentDraftExtractor", "(Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;)V", "documentScannerConfiguration", "Lio/scanbot/sdk/document/DocumentScannerConfiguration;", "getDocumentScannerConfiguration", "()Lio/scanbot/sdk/document/DocumentScannerConfiguration;", "setDocumentScannerConfiguration", "(Lio/scanbot/sdk/document/DocumentScannerConfiguration;)V", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "getOcrSettings", "()Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "setOcrSettings", "(Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "getPdfImagesExtractorSettings", "()Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "setPdfImagesExtractorSettings", "(Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;)V", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Nullable
        public final DocumentDraftExtractor getDocumentDraftExtractor() {
            return a;
        }

        public final void setDocumentDraftExtractor(@Nullable DocumentDraftExtractor documentDraftExtractor) {
            a = documentDraftExtractor;
        }

        @Nullable
        public final OcrSettings getOcrSettings() {
            return b;
        }

        public final void setOcrSettings(@Nullable OcrSettings ocrSettings) {
            b = ocrSettings;
        }

        @Nullable
        public final CameraUiSettings getCameraUiSettings() {
            return c;
        }

        public final void setCameraUiSettings(@Nullable CameraUiSettings cameraUiSettings) {
            c = cameraUiSettings;
        }

        @NotNull
        public final DocumentScannerConfiguration getDocumentScannerConfiguration() {
            return d;
        }

        public final void setDocumentScannerConfiguration(@NotNull DocumentScannerConfiguration documentScannerConfiguration) {
            DocumentScannerConfiguration documentScannerConfiguration2 = documentScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)documentScannerConfiguration2, (String)"<set-?>");
            d = documentScannerConfiguration2;
        }

        @Nullable
        public final PdfImagesExtractorSettings getPdfImagesExtractorSettings() {
            return e;
        }

        public final void setPdfImagesExtractorSettings(@Nullable PdfImagesExtractorSettings pdfImagesExtractorSettings) {
            e = pdfImagesExtractorSettings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PdfImagesExtractor.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PdfImagesExtractor.Type.PDFIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PdfImagesExtractor.Type.ANDROID_PDF_WRITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

