/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.dispose;

import com.github.rjeschke.neetutils.dispose.Disposable;
import com.github.rjeschke.neetutils.dispose.ReferenceList;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class Disposer
extends WeakReference<Object> {
    private final Disposable disposable;
    private final ReferenceList.Node<Disposer> disposer;
    private volatile boolean disposed = false;
    static final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    static final ReferenceList<Disposer> disposers = new ReferenceList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disposer(Object referent, Disposable disposable) {
        super(referent, refQueue);
        this.disposable = disposable;
        ReferenceList<Disposer> referenceList = disposers;
        synchronized (referenceList) {
            this.disposer = disposers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.disposed) {
            ReferenceList<Disposer> referenceList = disposers;
            synchronized (referenceList) {
                disposers.remove(this.disposer);
            }
            this.disposed = true;
            this.disposable.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    static {
        Thread thread = new Thread(new Cleaner());
        thread.setName("neetutils-Disposer");
        thread.setDaemon(true);
        thread.start();
    }

    private static final class Cleaner
    implements Runnable {
        @Override
        public void run() {
            ReferenceQueue<Object> refQueue = Disposer.refQueue;
            while (true) {
                try {
                    while (true) {
                        ((Disposer)refQueue.remove()).dispose();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

