/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.deser.XmlReadContext;
import com.fasterxml.jackson.dataformat.xml.deser.XmlTokenStream;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FromXmlParser
extends ParserMinimalBase {
    public static final String DEFAULT_UNNAMED_TEXT_PROPERTY = "";
    protected String _cfgNameForTextElement = "";
    protected int _formatFeatures;
    protected ObjectCodec _objectCodec;
    protected boolean _closed;
    protected final IOContext _ioContext;
    protected XmlReadContext _parsingContext;
    protected final XmlTokenStream _xmlTokens;
    protected boolean _mayBeLeaf;
    protected JsonToken _nextToken;
    protected String _currText;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;

    public FromXmlParser(IOContext ctxt, int genericParserFeatures, int xmlFeatures, ObjectCodec codec, XMLStreamReader xmlReader) throws IOException {
        super(genericParserFeatures);
        this._formatFeatures = xmlFeatures;
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._parsingContext = XmlReadContext.createRootContext(-1, -1);
        this._xmlTokens = new XmlTokenStream(xmlReader, ctxt.getSourceReference(), this._formatFeatures);
        if (this._xmlTokens.hasXsiNil()) {
            this._nextToken = JsonToken.VALUE_NULL;
        } else if (this._xmlTokens.getCurrentToken() == 1) {
            this._nextToken = JsonToken.START_OBJECT;
        } else {
            this._reportError("Internal problem: invalid starting state (%d)", this._xmlTokens.getCurrentToken());
        }
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public void setXMLTextElementName(String name2) {
        this._cfgNameForTextElement = name2;
    }

    @Override
    public boolean requiresCustomCodec() {
        return true;
    }

    public FromXmlParser enable(Feature f) {
        this._formatFeatures |= f.getMask();
        this._xmlTokens.setFormatFeatures(this._formatFeatures);
        return this;
    }

    public FromXmlParser disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        this._xmlTokens.setFormatFeatures(this._formatFeatures);
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public FromXmlParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int values2, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values2 & mask;
        return this;
    }

    public XMLStreamReader getStaxReader() {
        return this._xmlTokens.getXmlReader();
    }

    public void addVirtualWrapping(Set<String> namesToWrap) {
        String name2;
        if (!this._parsingContext.inRoot() && !this._parsingContext.getParent().inRoot() && (name2 = this._xmlTokens.getLocalName()) != null && namesToWrap.contains(name2)) {
            this._xmlTokens.repeatStartElement();
        }
        this._parsingContext.setNamesToWrap(namesToWrap);
    }

    @Override
    public String getCurrentName() throws IOException {
        String name2;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            XmlReadContext parent = this._parsingContext.getParent();
            name2 = parent.getCurrentName();
        } else {
            name2 = this._parsingContext.getCurrentName();
        }
        if (name2 == null) {
            throw new IllegalStateException("Missing name, in state: " + (Object)((Object)this._currToken));
        }
        return name2;
    }

    @Override
    public void overrideCurrentName(String name2) {
        XmlReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        ctxt.setCurrentName(name2);
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                    this._xmlTokens.closeCompletely();
                } else {
                    this._xmlTokens.close();
                }
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsParseException(e, this);
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public XmlReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return this._xmlTokens.getTokenLocation();
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return this._xmlTokens.getCurrentLocation();
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        JsonToken t = this._currToken;
        if (t == JsonToken.START_OBJECT) {
            this._currToken = JsonToken.START_ARRAY;
            this._parsingContext.convertToArray();
            this._nextToken = this._nextToken == JsonToken.END_OBJECT ? JsonToken.END_ARRAY : null;
            this._xmlTokens.skipAttributes();
            return true;
        }
        return t == JsonToken.START_ARRAY;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        int token;
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken t;
            this._currToken = t = this._nextToken;
            this._nextToken = null;
            switch (t) {
                case START_OBJECT: {
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    break;
                }
                case START_ARRAY: {
                    this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    this._parsingContext = this._parsingContext.getParent();
                    break;
                }
                case FIELD_NAME: {
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    break;
                }
            }
            return t;
        }
        try {
            token = this._xmlTokens.next();
        }
        catch (XMLStreamException e) {
            token = (Integer)StaxUtil.throwAsParseException(e, this);
        }
        while (token == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (this._parsingContext.inArray()) {
                try {
                    token = this._xmlTokens.next();
                }
                catch (XMLStreamException e) {
                    StaxUtil.throwAsParseException(e, this);
                }
                this._mayBeLeaf = true;
                continue;
            }
            String name2 = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(name2);
            if (this._parsingContext.shouldWrap(name2)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        block22: while (true) {
            switch (token) {
                case 2: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        if (this._parsingContext.inArray()) {
                            this._nextToken = JsonToken.END_OBJECT;
                            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                            this._currToken = JsonToken.START_OBJECT;
                            return this._currToken;
                        }
                        if (this._currToken != JsonToken.VALUE_NULL) {
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                    }
                    this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                    this._parsingContext = this._parsingContext.getParent();
                    return this._currToken;
                }
                case 3: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        this._nextToken = JsonToken.FIELD_NAME;
                        this._currText = this._xmlTokens.getText();
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                case 4: {
                    this._currText = this._xmlTokens.getText();
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currToken;
                }
                case 5: {
                    this._currText = this._xmlTokens.getText();
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        try {
                            this._xmlTokens.skipEndElement();
                        }
                        catch (XMLStreamException e) {
                            StaxUtil.throwAsParseException(e, this);
                        }
                        if (this._parsingContext.inArray() && this._isEmpty(this._currText)) {
                            this._nextToken = JsonToken.END_OBJECT;
                            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                            this._currToken = JsonToken.START_OBJECT;
                            return this._currToken;
                        }
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME && this._isEmpty(this._currText)) {
                        try {
                            token = this._xmlTokens.next();
                        }
                        catch (XMLStreamException e) {
                            StaxUtil.throwAsParseException(e, this);
                        }
                        continue block22;
                    }
                    this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                    this._nextToken = JsonToken.VALUE_STRING;
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                case 6: {
                    this._currToken = null;
                    return null;
                }
            }
            break;
        }
        return (JsonToken)((Object)this._internalErrorUnknownToken(token));
    }

    @Override
    public String nextTextValue() throws IOException {
        int token;
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken t;
            this._currToken = t = this._nextToken;
            this._nextToken = null;
            if (t == JsonToken.VALUE_STRING) {
                return this._currText;
            }
            this._updateState(t);
            return null;
        }
        try {
            token = this._xmlTokens.next();
        }
        catch (XMLStreamException e) {
            token = (Integer)StaxUtil.throwAsParseException(e, this);
        }
        while (token == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return null;
            }
            if (this._parsingContext.inArray()) {
                try {
                    token = this._xmlTokens.next();
                }
                catch (XMLStreamException e) {
                    StaxUtil.throwAsParseException(e, this);
                }
                this._mayBeLeaf = true;
                continue;
            }
            String name2 = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(name2);
            if (this._parsingContext.shouldWrap(name2)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return null;
        }
        switch (token) {
            case 2: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._currToken = JsonToken.VALUE_STRING;
                    this._currText = DEFAULT_UNNAMED_TEXT_PROPERTY;
                    return DEFAULT_UNNAMED_TEXT_PROPERTY;
                }
                this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                this._parsingContext = this._parsingContext.getParent();
                break;
            }
            case 3: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._nextToken = JsonToken.FIELD_NAME;
                    this._currText = this._xmlTokens.getText();
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    this._currToken = JsonToken.START_OBJECT;
                    break;
                }
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                this._currToken = JsonToken.FIELD_NAME;
                break;
            }
            case 4: {
                this._currToken = JsonToken.VALUE_STRING;
                this._currText = this._xmlTokens.getText();
                return this._currText;
            }
            case 5: {
                this._currText = this._xmlTokens.getText();
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    try {
                        this._xmlTokens.skipEndElement();
                    }
                    catch (XMLStreamException e) {
                        StaxUtil.throwAsParseException(e, this);
                    }
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currText;
                }
                this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                this._nextToken = JsonToken.VALUE_STRING;
                this._currToken = JsonToken.FIELD_NAME;
                break;
            }
            case 6: {
                this._currToken = null;
            }
            default: {
                return (String)this._internalErrorUnknownToken(token);
            }
        }
        return null;
    }

    private void _updateState(JsonToken t) {
        switch (t) {
            case START_OBJECT: {
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                break;
            }
            case START_ARRAY: {
                this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._parsingContext = this._parsingContext.getParent();
                break;
            }
            case FIELD_NAME: {
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                break;
            }
            default: {
                this._internalErrorUnknownToken((Object)t);
            }
        }
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
        }
        return this._currToken.asString();
    }

    @Override
    public final String getValueAsString() throws IOException {
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String defValue) throws IOException {
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        switch (t) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
            case START_OBJECT: {
                try {
                    String str = this._xmlTokens.convertToString();
                    if (str != null) {
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.VALUE_STRING;
                        this._nextToken = null;
                        try {
                            this._xmlTokens.skipEndElement();
                        }
                        catch (XMLStreamException e) {
                            StaxUtil.throwAsParseException(e, this);
                        }
                        this._currText = str;
                        return this._currText;
                    }
                }
                catch (XMLStreamException e) {
                    StaxUtil.throwAsParseException(e, this);
                }
                return null;
            }
        }
        if (this._currToken.isScalarValue()) {
            return this._currToken.asString();
        }
        return defValue;
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        String text = this.getText();
        return text == null ? null : text.toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public int getText(Writer writer) throws IOException {
        String str = this.getText();
        if (str == null) {
            return 0;
        }
        writer.write(str);
        return str.length();
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._binaryValue == null) {
            try {
                this._binaryValue = this._decodeBase64(b64variant);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + b64variant + "): " + iae.getMessage());
            }
        }
        return this._binaryValue;
    }

    protected byte[] _decodeBase64(Base64Variant b64variant) throws IOException {
        ByteArrayBuilder builder = this._getByteArrayBuilder();
        String str = this.getText();
        this._decodeBase64(str, builder, b64variant);
        return builder.toByteArray();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return null;
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return null;
    }

    @Override
    public double getDoubleValue() throws IOException {
        return 0.0;
    }

    @Override
    public float getFloatValue() throws IOException {
        return 0.0f;
    }

    @Override
    public int getIntValue() throws IOException {
        return 0;
    }

    @Override
    public long getLongValue() throws IOException {
        return 0L;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        return null;
    }

    @Override
    public Number getNumberValue() throws IOException {
        return null;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            String marker = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._parsingContext.getStartLocation(this._ioContext.getSourceReference())), null);
        }
    }

    protected void _releaseBuffers() throws IOException {
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected boolean _isEmpty(String str) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    private <T> T _internalErrorUnknownToken(Object token) {
        throw new IllegalStateException("Internal error: unrecognized XmlTokenStream token: " + token);
    }

    public static enum Feature implements FormatFeature
    {
        EMPTY_ELEMENT_AS_NULL(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int flags) {
            return (flags & this.getMask()) != 0;
        }
    }
}

