/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0018\u00010\tR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/LookaheadText;", "", "text", "", "(Ljava/lang/CharSequence;)V", "lines", "", "", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "getStartPosition", "()Lorg/intellij/markdown/parser/LookaheadText$Position;", "Position", "markdown"})
public final class LookaheadText {
    private final List<String> lines;
    @Nullable
    private final Position startPosition;
    private final CharSequence text;

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    public LookaheadText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.text = text;
        this.lines = StringsKt.split$default(this.text, new char[]{'\n'}, false, 0, 6, null);
        CharSequence charSequence = this.text;
        boolean bl = false;
        this.startPosition = charSequence.length() > 0 ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1, null) : null;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\r\u0010%\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010)\u001a\u00020\u0003H\u0016J\f\u0010*\u001a\b\u0018\u00010\u0000R\u00020+J\u0016\u0010,\u001a\b\u0018\u00010\u0000R\u00020+2\b\b\u0002\u0010-\u001a\u00020\u0003J\b\u0010.\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u001f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0013\u0010!\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000eR\u0011\u0010#\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012\u00a8\u0006/"}, d2={"Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "lineN", "", "localPos", "globalPos", "(Lorg/intellij/markdown/parser/LookaheadText;III)V", "char", "", "getChar", "()C", "currentLine", "", "getCurrentLine", "()Ljava/lang/String;", "currentLineFromPosition", "", "getCurrentLineFromPosition", "()Ljava/lang/CharSequence;", "nextLine", "getNextLine", "nextLineOffset", "getNextLineOffset", "()Ljava/lang/Integer;", "nextLineOrEofOffset", "getNextLineOrEofOffset", "()I", "offset", "getOffset", "offsetInCurrentLine", "getOffsetInCurrentLine", "originalText", "getOriginalText", "prevLine", "getPrevLine", "textFromPosition", "getTextFromPosition", "charsToNonWhitespace", "equals", "", "other", "hashCode", "nextLinePosition", "Lorg/intellij/markdown/parser/LookaheadText;", "nextPosition", "delta", "toString", "markdown"})
    public final class Position {
        @NotNull
        private final String currentLine;
        private final int lineN;
        private final int localPos;
        private final int globalPos;

        @NotNull
        public final CharSequence getOriginalText() {
            return LookaheadText.this.text;
        }

        @NotNull
        public final String getCurrentLine() {
            return this.currentLine;
        }

        @NotNull
        public String toString() {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Position: '");
            if (this.localPos == -1) {
                string = "\\n" + this.currentLine;
            } else {
                String string2 = this.currentLine;
                int n = this.localPos;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
            }
            return stringBuilder.append(string).append('\'').toString();
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        @Nullable
        public final Integer getNextLineOffset() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? Integer.valueOf(this.globalPos + (this.currentLine.length() - this.localPos)) : null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (this.currentLine.length() - this.localPos);
        }

        @NotNull
        public final CharSequence getTextFromPosition() {
            return LookaheadText.this.text.subSequence(this.globalPos, LookaheadText.this.text.length());
        }

        @NotNull
        public final CharSequence getCurrentLineFromPosition() {
            String string = this.currentLine;
            int n = this.getOffsetInCurrentLine();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            return string3;
        }

        @Nullable
        public final String getNextLine() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? (String)LookaheadText.this.lines.get(this.lineN + 1) : null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? (String)LookaheadText.this.lines.get(this.lineN - 1) : null;
        }

        public final char getChar() {
            return LookaheadText.this.text.charAt(this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (remaining != 0) {
                if (currentPosition.localPos + remaining < currentPosition.currentLine.length()) {
                    return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
                }
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = currentPosition.currentLine.length() - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return currentPosition;
        }

        public static /* synthetic */ Position nextPosition$default(Position position, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = n;
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.currentLine;
            int n = this.localPos;
            int n2 = 0;
            boolean bl = false;
            for (int offset = Math.max(n, n2); offset < line.length(); ++offset) {
                char c = line.charAt(offset);
                if (c == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(other.getClass()), Reflection.getOrCreateKotlinClass(this.getClass())) ^ true) {
                return false;
            }
            Position cfr_ignored_0 = (Position)other;
            return this.globalPos == ((Position)other).globalPos;
        }

        public int hashCode() {
            return this.globalPos;
        }

        public Position(int lineN, int localPos, int globalPos) {
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            this.currentLine = (String)LookaheadText.this.lines.get(this.lineN);
            Compat compat = Compat.INSTANCE;
            boolean condition$iv = this.localPos >= -1 && this.localPos < this.currentLine.length();
            boolean $i$f$assert = false;
            if (!condition$iv) {
                String string;
                String string2 = string = "";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
        }
    }
}

