package io.scanbot.dokka

import org.gradle.api.Project
import org.gradle.api.tasks.Input
import org.jetbrains.dokka.gradle.DokkaAndroidPlugin
import org.jetbrains.dokka.gradle.DokkaAndroidTask
import org.jetbrains.dokka.gradle.DokkaVersion
import org.jetbrains.dokka.gradle.SourceRoot
import java.io.File

open class DokkaScanbotPlugin : DokkaAndroidPlugin() {
    override fun apply(project: Project) {
        DokkaVersion.loadFrom(javaClass.getResourceAsStream("/META-INF/gradle-plugins/dokka-scanbot.properties"))
        project.tasks.create("dokka", DokkaScanbotTask::class.java).apply {
            moduleName = project.name
            outputDirectory = File(project.buildDir, "dokka").absolutePath
        }
    }
}

open class DokkaScanbotTask : DokkaAndroidTask() {

    @Input
    var whiteList: MutableList<String> = arrayListOf()

    override fun collectSuppressedFiles(sourceRoots: List<SourceRoot>): List<String> {
        val list = super.collectSuppressedFiles(sourceRoots).toMutableList()
        val generatedRoot = project.buildDir.resolve("generated").absoluteFile

        val filter = sourceRoots
                .map { File(it.path) }
                .filter { !it.startsWith(generatedRoot) }
                .flatMap { it.walk().toList() }
                .map { it.absolutePath }
                .filter { it.endsWith(".java") || it.endsWith(".kt") }
                .filter {
                    var found = false

                    for (s in whiteList) {
                        found = it.contains(s.trim())
                        if (found){
                            break
                        }
                    }

                    return@filter !found
                }

        list.addAll(
                filter
        )

        System.out.print("collectSuppressedFiles : " + list.toString())

        System.out.print("filter : " + filter.toString())

        System.out.print("whitelist : " + whiteList.toString())

        return list
    }

}