package io.scanbot.dynawrapper;


//float           BorderWidth;
//UI32            BorderColor;
//TBorderStyle    BorderStyle;
//UI32            BackColor;
//UI32            Handle;
//char*           AuthorA;
//UI16*           AuthorW;
//char*           ContentA;
//UI16*           ContentW;
//char*           NameA;
//UI16*           NameW;
//char*           SubjectA;
//UI16*           SubjectW;
//UI32            PageNum;
//THighlightMode  HighlightMode;
//// Page link annotations only
//SI32            DestPage;
//struct TPDFRect DestPos;
//TDestType       DestType;
//// File link or web link annotations
//// Instance pointer
//// Annotation handle
//char* DestFile;
//// The Icon type depends on the annotation type. If the annotation type // is atText the Icon is of type TAnnotIcon. If the annotation type is // atFileAttach then it is of type TFileAttachIcon. If the annotation // type is atStamp the Icon is the stamp type (TRubberStamp).
//// For any other annotation type this value is not set (-1).
//SI32 Icon;
//char* StampName;
//UI32 AnnotFlags;
//char* CreateDate;
//char* ModDate;
//// Grouped is meaningful only
//// true, the annotation is part of an annotation group. Properties like // Content, CreateDate, ModDate, BackColor, Subject, and Open must be // taken from the parent annotation.
//LBOOL Grouped;
//LBOOL Open; // If the annotation has a PopUp annotation.
//// Set only, if Icon == rsUserDefined
//// See TAnnotFlags for available flags
//// Optional Creation Date
//// Optional Modification Date
//if Parent != -1 and Type != atPopUp. If
//￼￼Function Reference Page 314 of 682
//￼￼￼// The Parent annotation handle is set if the annotation is a PopUp
//// Annotation or if this annotation represents a state of a base
//// annotation. In this case, the annotation type is always atText and // only the following members should be considered:
////    State      -> The current state
////    StateModel -> Marked, Review, and so on
////    CreateDate -> Creation Date
//// ModDate
//// Author
//// Content
//// Subject
//// The PopUp annotation of a text annotation which represent an // Annotation State must be ignored.
//-> Modification Date
//-> The user who has set the state
//-> Not displayed in Adobe's Acrobat...
//-> Not displayed in Adobe's Acrobat...
//SI32 Parent;
//SI32 PopUp; // Handle of the PopUp annotation if any char* State; // The state of the annotation
//char* StateModel; // State model (Marked, Review, ...)
//// FileAttach annotations only. This is a handle of an embedded file. // The embedded file can be accessed with GetEmbeddedFile().
//SI32 EmbeddedFile;
//char*           Subtype;
//LBOOL           MarkupAnnot;
//float           Opacity;
//// Set only, if Type == atUnknown
//// If true, the annotation is a markup
//// annotation. Markup annotations can be // flattened separately (FlattenAnnots()). // Opacity = 1.0 = Opaque,
//// Opacity < 1.0 = Transparent, Markup
//// annotations only
///* 24 reserved fields follow*/
//};
public class Annotation {
	
	public AnnotationType type = AnnotationType.Unknown;
	
	/**
	 * Marked as deleted?
	 */
	public boolean deleted = false;
	
	/**
	 * Bounding box in bottom-up coordinates
	 */
	public TPDFRect bbox;
	
	/**
	 * Page of the document annotation is made on
	 */
	public int pageNumber;
	
	/**
	 * Text content 
	 */
	public String textContent;
	
	/**
	 *  Opacity = 1.0 = Opaque,
	 *	Opacity < 1.0 = Transparent,
	 *  Markup annotations only
	 */
	public float opacity;
	
	public String author;
	public String name;
	public String subject;
	
	public Annotation(int pageNumber, AnnotationType type, boolean deleted){
		super();
		this.type = type;
		this.pageNumber = pageNumber;
		this.deleted = deleted;
	}
	
	
}
