package io.scanbot.dynawrapper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.Scroller;
import android.widget.TextView;

public class PDFView extends SurfaceView implements SurfaceHolder.Callback
{
	public enum TPageAction
	{
		paFirstPage,
		paNextPage,
		paPrevPage,
		paLastPage,
		paPageNum
	}

	boolean       m_Busy;
	int           m_CurrPage;
	int           m_PageCount;
	DynaPDF       m_PDF;
	Rect          m_RectDst;
	Rect          m_RectSrc;
	Scroller      m_Scroller;
	int           m_ScreenHeight;
	int           m_ScreenWidth;
	boolean       m_ScrollHorz;
	boolean       m_ScrollVert;
	SurfaceHolder m_SurfaceHolder;
	TextView      m_Text;
	RenderThread  m_Thread = null;
    float         m_x;
    float         m_y;
	PointF        m_ZoomMidpoint;

	public PDFView(Context context) throws Exception
	{
		super(context);
		m_SurfaceHolder = getHolder();
		m_PDF = new DynaPDF();
		m_SurfaceHolder.addCallback(this);
		m_Scroller = new Scroller(context);
		setFocusable(true);
	}

	public void onDestroy()
	{
		TerminateThread();
		if (m_PDF != null)
			m_PDF.onDestroy();
		m_PDF = null;
	}

	public int GetCurrPage()
	{
		return m_CurrPage;
	}

	public int GetPageCount()
	{
		return m_PageCount;
	}

	public int OpenFile(String FileName, int PwdType, String Password)
	{
        m_CurrPage   = 0;
        m_x          = 0.0f;
        m_y          = 0.0f;
        m_ScrollHorz = false;
        m_ScrollVert = false;
        TerminateThread();
		m_PageCount = m_PDF.openFile(FileName, PwdType, Password);
		if (m_PageCount < 0) m_PageCount = 0;
		return m_PageCount;
	}

	public void RenderPage(TPageAction Action, int PageNum)
	{
		switch(Action)
		{
			case paFirstPage: PageNum = 1; break;
			case paNextPage:  PageNum = m_CurrPage + 1; if (PageNum > m_PageCount) PageNum = m_PageCount; break;
			case paPrevPage:  PageNum = m_CurrPage - 1; if (PageNum < 1) PageNum = 1; break;
			case paLastPage:  PageNum = m_PageCount; break;
			case paPageNum:   if (PageNum < 1) PageNum = 1; else if (PageNum > m_PageCount) PageNum = m_PageCount; break;
		}
		if (m_CurrPage != PageNum)
		{
	        m_x = 0.0f;
	        m_y = 0.0f;
	        if (m_Busy) m_PDF.abort();
			m_Text.setText(PageNum + "/" + m_PageCount);
			m_CurrPage = PageNum;
			StartThread();
		}
	}

    @Override
    public void scrollBy(int x, int y)
    {
        if (m_ScrollVert)
        {
	        Canvas c = null;
	        Bitmap b = m_PDF.getBitmap();
        	m_y -= y;
	        if (m_ScrollHorz)
	        {
	        	m_x += x;
		        if (m_x > 0.0f) m_x = 0.0f;
		        if (m_x < m_ScreenWidth - b.getWidth()) m_x = m_ScreenWidth - b.getWidth();
	        }
	        if (m_y > 0.0f) m_y = 0.0f;
	        if (m_y < m_ScreenHeight - b.getHeight()) m_y = m_ScreenHeight - b.getHeight();
	        try
	        {
	            c = m_SurfaceHolder.lockCanvas();
	            c.drawRGB(255, 255, 255);
	            c.drawBitmap(b, m_x, m_y, null);
	        }finally
	        {
	            if (c != null) m_SurfaceHolder.unlockCanvasAndPost(c);
	        }
        }else if (m_ScrollHorz)
        {
        	m_x += x;
	        Canvas c = null;
	        Bitmap b = m_PDF.getBitmap();
	        if (m_x > 0.0f) m_x = 0.0f;
	        if (m_x < m_ScreenWidth - b.getWidth()) m_x = m_ScreenWidth - b.getWidth();
	        try
	        {
	            c = m_SurfaceHolder.lockCanvas();
	            c.drawRGB(255, 255, 255);
	            c.drawBitmap(b, m_x, m_y, null);
	        }finally
	        {
	            if (c != null) m_SurfaceHolder.unlockCanvasAndPost(c);
	        }
        }
    }

	public void SetTextView(TextView Text)
	{
		m_Text = Text;
	}

	public void StartThread()
	{
		if (m_Thread == null)
		{
			m_Thread = new RenderThread(this);
			m_Thread.start();
		}else
		{
			TerminateThread();
			m_Thread = new RenderThread(this);
			m_Thread.start();
		}
	}

	public void surfaceChanged(SurfaceHolder holder, int format, int width, int height)
	{
		m_ScreenWidth   = width;
		m_ScreenHeight  = height;
		m_SurfaceHolder = holder;
	}

	public void surfaceCreated(SurfaceHolder holder)
	{
		// Note that this call is just for the demo because we open the PDF file already
		// in the constructor of the activity. Normally, you would call OpenFile() and then
		// RenderPage() to render the first page in the file...
		RenderPage(TPageAction.paFirstPage, 1);
	}

	public void surfaceDestroyed(SurfaceHolder arg0)
	{
		TerminateThread();
	}

	public void TerminateThread()
	{
		if (m_Thread != null)
		{
			while (m_Thread.isAlive())
			{
				try
				{
					if (m_Busy) m_PDF.abort();
					m_Thread.join();
				}catch(Exception e)
				{
				}
			}
		}
	}

	/* ---------------------------------------------------------------------------------------------------------------------------------- */

	class RenderThread extends Thread implements Runnable
	{
		PDFView m_PDFView;

		RenderThread(PDFView View)
		{
			m_PDFView = View;
		}

		public void run()
		{
			m_Busy = true;
			if (m_PDF.renderPage(m_CurrPage, m_ScreenWidth, m_ScreenHeight))
			{
				Canvas c = null;
				try
				{
					c = m_SurfaceHolder.lockCanvas();
					Bitmap b = m_PDF.getBitmap();
                    c.drawRGB(255, 255, 255);
					c.drawBitmap(b, m_x, m_y, null);
					m_ScrollHorz = b.getWidth()  > m_ScreenWidth;
					m_ScrollVert = b.getHeight() > m_ScreenHeight;
				}finally
				{
					if (c != null) m_SurfaceHolder.unlockCanvasAndPost(c);
				}
			}
			m_Busy = false;
		}
	}
}
