/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.dynawrapper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.Scroller;
import android.widget.TextView;
import io.scanbot.dynawrapper.DynaPDF;

public class PDFView
extends SurfaceView
implements SurfaceHolder.Callback {
    boolean m_Busy;
    int m_CurrPage;
    int m_PageCount;
    DynaPDF m_PDF;
    Rect m_RectDst;
    Rect m_RectSrc;
    Scroller m_Scroller;
    int m_ScreenHeight;
    int m_ScreenWidth;
    boolean m_ScrollHorz;
    boolean m_ScrollVert;
    SurfaceHolder m_SurfaceHolder = this.getHolder();
    TextView m_Text;
    RenderThread m_Thread = null;
    float m_x;
    float m_y;
    PointF m_ZoomMidpoint;

    public PDFView(Context context) throws Exception {
        super(context);
        this.m_PDF = new DynaPDF();
        this.m_SurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.m_Scroller = new Scroller(context);
        this.setFocusable(true);
    }

    public void onDestroy() {
        this.TerminateThread();
        if (this.m_PDF != null) {
            this.m_PDF.onDestroy();
        }
        this.m_PDF = null;
    }

    public int GetCurrPage() {
        return this.m_CurrPage;
    }

    public int GetPageCount() {
        return this.m_PageCount;
    }

    public int OpenFile(String FileName, int PwdType, String Password) {
        this.m_CurrPage = 0;
        this.m_x = 0.0f;
        this.m_y = 0.0f;
        this.m_ScrollHorz = false;
        this.m_ScrollVert = false;
        this.TerminateThread();
        this.m_PageCount = this.m_PDF.openFile(FileName, PwdType, Password);
        if (this.m_PageCount < 0) {
            this.m_PageCount = 0;
        }
        return this.m_PageCount;
    }

    public void RenderPage(TPageAction Action, int PageNum) {
        switch (Action) {
            case paFirstPage: {
                PageNum = 1;
                break;
            }
            case paNextPage: {
                PageNum = this.m_CurrPage + 1;
                if (PageNum <= this.m_PageCount) break;
                PageNum = this.m_PageCount;
                break;
            }
            case paPrevPage: {
                PageNum = this.m_CurrPage - 1;
                if (PageNum >= 1) break;
                PageNum = 1;
                break;
            }
            case paLastPage: {
                PageNum = this.m_PageCount;
                break;
            }
            case paPageNum: {
                if (PageNum < 1) {
                    PageNum = 1;
                    break;
                }
                if (PageNum <= this.m_PageCount) break;
                PageNum = this.m_PageCount;
            }
        }
        if (this.m_CurrPage != PageNum) {
            this.m_x = 0.0f;
            this.m_y = 0.0f;
            if (this.m_Busy) {
                this.m_PDF.abort();
            }
            this.m_Text.setText((CharSequence)(PageNum + "/" + this.m_PageCount));
            this.m_CurrPage = PageNum;
            this.StartThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollBy(int x, int y) {
        if (this.m_ScrollVert) {
            Canvas c = null;
            Bitmap b = this.m_PDF.getBitmap();
            this.m_y -= (float)y;
            if (this.m_ScrollHorz) {
                this.m_x += (float)x;
                if (this.m_x > 0.0f) {
                    this.m_x = 0.0f;
                }
                if (this.m_x < (float)(this.m_ScreenWidth - b.getWidth())) {
                    this.m_x = this.m_ScreenWidth - b.getWidth();
                }
            }
            if (this.m_y > 0.0f) {
                this.m_y = 0.0f;
            }
            if (this.m_y < (float)(this.m_ScreenHeight - b.getHeight())) {
                this.m_y = this.m_ScreenHeight - b.getHeight();
            }
            try {
                c = this.m_SurfaceHolder.lockCanvas();
                c.drawRGB(255, 255, 255);
                c.drawBitmap(b, this.m_x, this.m_y, null);
            }
            finally {
                if (c != null) {
                    this.m_SurfaceHolder.unlockCanvasAndPost(c);
                }
            }
        }
        if (this.m_ScrollHorz) {
            this.m_x += (float)x;
            Canvas c = null;
            Bitmap b = this.m_PDF.getBitmap();
            if (this.m_x > 0.0f) {
                this.m_x = 0.0f;
            }
            if (this.m_x < (float)(this.m_ScreenWidth - b.getWidth())) {
                this.m_x = this.m_ScreenWidth - b.getWidth();
            }
            try {
                c = this.m_SurfaceHolder.lockCanvas();
                c.drawRGB(255, 255, 255);
                c.drawBitmap(b, this.m_x, this.m_y, null);
            }
            finally {
                if (c != null) {
                    this.m_SurfaceHolder.unlockCanvasAndPost(c);
                }
            }
        }
    }

    public void SetTextView(TextView Text) {
        this.m_Text = Text;
    }

    public void StartThread() {
        if (this.m_Thread == null) {
            this.m_Thread = new RenderThread(this);
            this.m_Thread.start();
        } else {
            this.TerminateThread();
            this.m_Thread = new RenderThread(this);
            this.m_Thread.start();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.m_ScreenWidth = width;
        this.m_ScreenHeight = height;
        this.m_SurfaceHolder = holder;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.RenderPage(TPageAction.paFirstPage, 1);
    }

    public void surfaceDestroyed(SurfaceHolder arg0) {
        this.TerminateThread();
    }

    public void TerminateThread() {
        if (this.m_Thread != null) {
            while (this.m_Thread.isAlive()) {
                try {
                    if (this.m_Busy) {
                        this.m_PDF.abort();
                    }
                    this.m_Thread.join();
                }
                catch (Exception exception) {}
            }
        }
    }

    class RenderThread
    extends Thread
    implements Runnable {
        PDFView m_PDFView;

        RenderThread(PDFView View) {
            this.m_PDFView = View;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PDFView.this.m_Busy = true;
            if (PDFView.this.m_PDF.renderPage(PDFView.this.m_CurrPage, PDFView.this.m_ScreenWidth, PDFView.this.m_ScreenHeight)) {
                Canvas c = null;
                try {
                    c = PDFView.this.m_SurfaceHolder.lockCanvas();
                    Bitmap b = PDFView.this.m_PDF.getBitmap();
                    c.drawRGB(255, 255, 255);
                    c.drawBitmap(b, PDFView.this.m_x, PDFView.this.m_y, null);
                    PDFView.this.m_ScrollHorz = b.getWidth() > PDFView.this.m_ScreenWidth;
                    PDFView.this.m_ScrollVert = b.getHeight() > PDFView.this.m_ScreenHeight;
                }
                finally {
                    if (c != null) {
                        PDFView.this.m_SurfaceHolder.unlockCanvasAndPost(c);
                    }
                }
            }
            PDFView.this.m_Busy = false;
        }
    }

    public static enum TPageAction {
        paFirstPage,
        paNextPage,
        paPrevPage,
        paLastPage,
        paPageNum;

    }
}

