/*
 * Decompiled with CFR 0.152.
 */
package net.doo.iqm.sdk;

import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.iqm.sdk.MetricResult;

public abstract class ImageQualityMetricSDK {
    public abstract MetricResult measure(byte[] var1);

    public static native ImageQualityMetricSDK create();

    private static final class CppProxy
    extends ImageQualityMetricSDK {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public MetricResult measure(byte[] image) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_measure(this.nativeRef, image);
        }

        private native MetricResult native_measure(long var1, byte[] var3);
    }
}

