package io.scanbot.tools.utils.kotlin

/** Capitalizes the first character of the string. */
fun String.capitalize() = replaceFirstChar { if (it.isLowerCase()) it.titlecase() else it.toString() }

/** Decapitalizes the first character of the string. */
fun String.decapitalize() = replaceFirstChar { if (it.isUpperCase()) it.lowercase() else it.toString() }

/** The name stands for i(gnoreCase)Contains. The same as [CharSequence.contains] but with `ignoreCase = true` already there. */
fun CharSequence.iContains(other: CharSequence): Boolean = contains(other, ignoreCase = true)
/** The name stands for i(gnoreCase)EndsWith. The same as [CharSequence.endsWith] but with `ignoreCase = true` already there. */
fun CharSequence.iEndsWith(suffix: CharSequence): Boolean = endsWith(suffix, ignoreCase = true)
/** The name stands for i(gnoreCase)Equals. The same as [String.equals] but with `ignoreCase = true` already there. */
fun String?.iEquals(other: String?): Boolean = equals(other, ignoreCase = true)
