/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sap;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class SapManager {
    public void install(Context context, byte[] license) {
        this.install((Object)context, license);
    }

    public boolean isLicenseActive() {
        return this.active();
    }

    public boolean isFeatureEnabled(int item) {
        return this.enabled(item);
    }

    static boolean verifySignature(byte[] publicKey, byte[] data, byte[] signature) {
        int startOffset = "-----BEGIN PUBLIC KEY-----\n".length();
        int endOffset = "-----END PUBLIC KEY-----\n".length();
        byte[] derKey = Arrays.copyOfRange(publicKey, startOffset, publicKey.length - endOffset);
        data = Arrays.copyOf(data, data.length + 1);
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode((byte[])derKey, (int)0));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(keySpec);
            Signature signatureAlg = Signature.getInstance("SHA512withRSA");
            signatureAlg.initVerify(key);
            signatureAlg.update(data);
            return signatureAlg.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            Log.e((String)"Scanbot SDK", (String)"License is not valid");
            return false;
        }
    }

    private native boolean active();

    private native boolean enabled(int var1);

    private native void install(Object var1, byte[] var2);

    static {
        System.loadLibrary("sap");
    }
}

