/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tools.mediafpsplayer;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import io.scanbot.tools.mediafpsplayer.VideoFrame;
import io.scanbot.tools.mediafpsplayer.VideoProcessor;
import io.scanbot.tools.utils.ImageUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\u00020\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0013"}, d2={"Lio/scanbot/tools/mediafpsplayer/VideoProcessorV2;", "Lio/scanbot/tools/mediafpsplayer/VideoProcessor;", "file", "Ljava/io/File;", "fps", "", "(Ljava/io/File;D)V", "currentTime", "", "duration", "Lkotlin/time/Duration;", "J", "oneFrameTimeStep", "orientation", "", "player", "Landroid/media/MediaMetadataRetriever;", "nextFrame", "Lio/scanbot/tools/mediafpsplayer/VideoFrame;", "media-fps-player_release"})
public final class VideoProcessorV2
implements VideoProcessor {
    @NotNull
    private final MediaMetadataRetriever player;
    private final long duration;
    private final long oneFrameTimeStep;
    private final int orientation;
    private long currentTime;

    public VideoProcessorV2(@NotNull File file, double fps) {
        String rawDuration;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.player = new MediaMetadataRetriever();
        this.oneFrameTimeStep = (long)((double)TimeUnit.MICROSECONDS.convert(1L, TimeUnit.SECONDS) / fps);
        this.player.setDataSource(file.getPath());
        String string = rawDuration = this.player.extractMetadata(9);
        Intrinsics.checkNotNull((Object)string);
        this.duration = DurationKt.toDuration((long)Long.parseLong(string), (DurationUnit)DurationUnit.MILLISECONDS);
        String string2 = this.player.extractMetadata(24);
        this.orientation = string2 != null ? Integer.parseInt(string2) : 0;
    }

    @Override
    @Nullable
    public VideoFrame nextFrame() {
        if (this.currentTime > Duration.getInWholeMicroseconds-impl((long)this.duration)) {
            return null;
        }
        Bitmap bitmap = this.player.getFrameAtTime(this.currentTime, 3);
        if (bitmap == null) {
            return null;
        }
        Bitmap bmFrame = bitmap;
        this.currentTime += this.oneFrameTimeStep;
        int width = bmFrame.getWidth();
        int height = bmFrame.getHeight();
        byte[] yuv = ImageUtils.INSTANCE.convertBitmapToYuv(bmFrame, width, height);
        return new VideoFrame(yuv, width, height, this.orientation);
    }

    @Override
    public void release() {
        VideoProcessor.DefaultImpls.release(this);
    }
}

