package io.scanbot.tools.mediafpsplayer

import io.scanbot.sdk.image.ImageRef

interface FrameExtractorListener {

    fun onFrameExtractorInit(
        filePath: String,
        totalDuration: Long,
        oneFrameTimeStep: Long,
        totalFrames: Int,
        videoOrientation: Int,
    ) {}

    fun onFrameExtractionStart(frameIndex: Int, total: Int) {}

    fun onFrameExtractedDebug(debugFrameImgRef: ImageRef) {}

    fun onFrameExtractionEnd(frameIndex: Int, total: Int) {}

    fun onFrameExtractionException(message: String, cause: Exception? = null) {}

    fun onNoMoreFrames(reason: String) {}
}
