/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.resync;

import io.scanbot.resync.BaselineCreationCondition;
import io.scanbot.resync.BaselineFactory;
import io.scanbot.resync.EventCountingBaselineCreationCondition;
import io.scanbot.resync.EventReader;
import io.scanbot.resync.EventStorage;
import io.scanbot.resync.LocalClock;
import io.scanbot.resync.MergeFunction;
import io.scanbot.resync.MergeIntegrator;
import io.scanbot.resync.Merger;
import io.scanbot.resync.OperationExecutor;
import io.scanbot.resync.Puller;
import io.scanbot.resync.Pusher;
import io.scanbot.resync.Transactor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/resync/Resync;", "", "puller", "Lio/scanbot/resync/Puller;", "pusher", "Lio/scanbot/resync/Pusher;", "localClock", "Lio/scanbot/resync/LocalClock;", "transactor", "Lio/scanbot/resync/Transactor;", "(Lio/scanbot/resync/Puller;Lio/scanbot/resync/Pusher;Lio/scanbot/resync/LocalClock;Lio/scanbot/resync/Transactor;)V", "sync", "", "Factory", "library-compileKotlin"})
public final class Resync {
    private final Puller puller;
    private final Pusher pusher;
    private final LocalClock localClock;
    private final Transactor transactor;
    public static final Factory Factory = new Factory(null);

    public final void sync() {
        long timeOfLastSync = this.localClock.timeOfLastSync();
        long timeOfSyncStart = this.localClock.currentSystemTime();
        this.puller.pullStateFrom(timeOfLastSync);
        this.pusher.pushEventsFrom(timeOfLastSync);
        this.localClock.updateLastSyncTime(timeOfSyncStart);
    }

    @NotNull
    public final Transactor transactor() {
        return this.transactor;
    }

    public Resync(@NotNull Puller puller, @NotNull Pusher pusher, @NotNull LocalClock localClock, @NotNull Transactor transactor) {
        Intrinsics.checkParameterIsNotNull((Object)puller, (String)"puller");
        Intrinsics.checkParameterIsNotNull((Object)pusher, (String)"pusher");
        Intrinsics.checkParameterIsNotNull((Object)localClock, (String)"localClock");
        Intrinsics.checkParameterIsNotNull((Object)transactor, (String)"transactor");
        this.puller = puller;
        this.pusher = pusher;
        this.localClock = localClock;
        this.transactor = transactor;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lio/scanbot/resync/Resync$Factory;", "", "()V", "create", "Lio/scanbot/resync/Resync;", "localEventStorage", "Lio/scanbot/resync/EventStorage;", "remoteEventStorage", "localClock", "Lio/scanbot/resync/LocalClock;", "operationExecutor", "Lio/scanbot/resync/OperationExecutor;", "conflictResolver", "Lio/scanbot/resync/MergeFunction;", "clientName", "", "baselineEventCount", "", "library-compileKotlin"})
    public static final class Factory {
        @NotNull
        public final Resync create(@NotNull EventStorage localEventStorage, @NotNull EventStorage remoteEventStorage, @NotNull LocalClock localClock, @NotNull OperationExecutor operationExecutor, @NotNull MergeFunction conflictResolver, @NotNull String clientName, int baselineEventCount) {
            Intrinsics.checkParameterIsNotNull((Object)localEventStorage, (String)"localEventStorage");
            Intrinsics.checkParameterIsNotNull((Object)remoteEventStorage, (String)"remoteEventStorage");
            Intrinsics.checkParameterIsNotNull((Object)localClock, (String)"localClock");
            Intrinsics.checkParameterIsNotNull((Object)operationExecutor, (String)"operationExecutor");
            Intrinsics.checkParameterIsNotNull((Object)conflictResolver, (String)"conflictResolver");
            Intrinsics.checkParameterIsNotNull((Object)clientName, (String)"clientName");
            Merger merger = new Merger(conflictResolver);
            Object object = clientName;
            Object object2 = localEventStorage;
            LocalClock localClock2 = localClock;
            Transactor transactor = new Transactor((EventStorage)object2, localClock2, (String)object);
            object = transactor;
            object2 = localClock;
            Puller puller = new Puller(new EventReader(localEventStorage), new EventReader(remoteEventStorage), merger, new MergeIntegrator(operationExecutor, (Transactor)object, (LocalClock)object2));
            int n = baselineEventCount;
            object2 = remoteEventStorage;
            BaselineCreationCondition baselineCreationCondition = new EventCountingBaselineCreationCondition(n, (EventStorage)object2);
            object2 = new BaselineFactory(new EventReader(remoteEventStorage), merger);
            return new Resync(puller, new Pusher(localEventStorage, remoteEventStorage, baselineCreationCondition, (BaselineFactory)object2), localClock, transactor);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

