/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.resync;

import io.scanbot.resync.EventStorage;
import io.scanbot.resync.model.Baseline;
import io.scanbot.resync.model.BaselineKt;
import io.scanbot.resync.model.Event;
import io.scanbot.resync.model.StateTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/resync/EventReader;", "", "storage", "Lio/scanbot/resync/EventStorage;", "(Lio/scanbot/resync/EventStorage;)V", "eventsSinceLastBaseline", "", "Lio/scanbot/resync/model/Event;", "baseline", "Lio/scanbot/resync/model/Baseline;", "timestamp", "", "readEventsSince", "library-compileKotlin"})
public class EventReader {
    private final EventStorage storage;

    @NotNull
    public List<Event> readEventsSince(long timestamp) {
        Baseline baseline = this.storage.getLatestBaselineSince(timestamp);
        return CollectionsKt.plus((Collection)BaselineKt.asEvents(baseline), (Iterable)this.eventsSinceLastBaseline(baseline, timestamp));
    }

    private final List<Event> eventsSinceLastBaseline(Baseline baseline, long timestamp) {
        Object object = baseline;
        return this.storage.getEventsSince(object != null && (object = ((Baseline)object).getTime()) != null ? ((StateTime)object).getTimestamp() : timestamp);
    }

    public EventReader(@NotNull EventStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        this.storage = storage;
    }
}

