/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.resync;

import io.scanbot.resync.BaselineCreationCondition;
import io.scanbot.resync.BaselineFactory;
import io.scanbot.resync.EventStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/scanbot/resync/Pusher;", "", "localStorage", "Lio/scanbot/resync/EventStorage;", "remoteStorage", "baselineCreationCondition", "Lio/scanbot/resync/BaselineCreationCondition;", "baselineFactory", "Lio/scanbot/resync/BaselineFactory;", "(Lio/scanbot/resync/EventStorage;Lio/scanbot/resync/EventStorage;Lio/scanbot/resync/BaselineCreationCondition;Lio/scanbot/resync/BaselineFactory;)V", "pushBaselineIfNeeded", "", "pushEventsFrom", "timestamp", "", "pushLocalEventsToRemote", "library"})
public class Pusher {
    private final EventStorage localStorage;
    private final EventStorage remoteStorage;
    private final BaselineCreationCondition baselineCreationCondition;
    private final BaselineFactory baselineFactory;

    public void pushEventsFrom(long timestamp) {
        this.pushLocalEventsToRemote(timestamp);
        this.pushBaselineIfNeeded();
    }

    private final void pushLocalEventsToRemote(long timestamp) {
        this.remoteStorage.saveEvents(this.localStorage.getEventsSince(timestamp));
    }

    private final void pushBaselineIfNeeded() {
        if (this.baselineCreationCondition.shouldCreateBaseline()) {
            this.remoteStorage.saveBaseline(this.baselineFactory.createBaseline());
        }
    }

    public Pusher(@NotNull EventStorage localStorage, @NotNull EventStorage remoteStorage, @NotNull BaselineCreationCondition baselineCreationCondition, @NotNull BaselineFactory baselineFactory) {
        Intrinsics.checkParameterIsNotNull((Object)localStorage, (String)"localStorage");
        Intrinsics.checkParameterIsNotNull((Object)remoteStorage, (String)"remoteStorage");
        Intrinsics.checkParameterIsNotNull((Object)baselineCreationCondition, (String)"baselineCreationCondition");
        Intrinsics.checkParameterIsNotNull((Object)baselineFactory, (String)"baselineFactory");
        this.localStorage = localStorage;
        this.remoteStorage = remoteStorage;
        this.baselineCreationCondition = baselineCreationCondition;
        this.baselineFactory = baselineFactory;
    }
}

