/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.barcode_scanner.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.ui.barcode_scanner.di.components.BarcodeCameraComponent;
import io.scanbot.sdk.ui.barcode_scanner.di.components.BarcodeScannerSDKUIComponent;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.BarcodeCameraFragment;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import javax.inject.Provider;

public final class DaggerBarcodeCameraComponent
implements BarcodeCameraComponent {
    private BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerBarcodeCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.barcodeScannerSDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodeTakenPictureUseCase getSaveBarcodeTakenPictureUseCase() {
        return new SaveBarcodeTakenPictureUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.barcodeScannerSDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private SaveBarcodePreviewFrameUseCase getSaveBarcodePreviewFrameUseCase() {
        return new SaveBarcodePreviewFrameUseCase((BarcodeFileStorage)Preconditions.checkNotNull((Object)this.barcodeScannerSDKUIComponent.barcodeFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private BarcodeCameraPresenter getBarcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveBarcodeTakenPictureUseCase(), this.getSaveBarcodePreviewFrameUseCase(), (Navigator)this.providesNavigatorProvider.get());
    }

    private void initialize(Builder builder) {
        this.barcodeScannerSDKUIComponent = builder.barcodeScannerSDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
    }

    @Override
    public void inject(BarcodeCameraFragment barcodeCameraFragment) {
        this.injectBarcodeCameraFragment(barcodeCameraFragment);
    }

    private BarcodeCameraFragment injectBarcodeCameraFragment(BarcodeCameraFragment instance) {
        BaseBarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseBarcodeCameraFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseBarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter((BaseBarcodeCameraFragment)instance, (BarcodeCameraPresenter)this.getBarcodeCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent;

        private Builder() {
        }

        public BarcodeCameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.barcodeScannerSDKUIComponent == null) {
                throw new IllegalStateException(BarcodeScannerSDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerBarcodeCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder barcodeScannerSDKUIComponent(BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent) {
            this.barcodeScannerSDKUIComponent = (BarcodeScannerSDKUIComponent)Preconditions.checkNotNull((Object)barcodeScannerSDKUIComponent);
            return this;
        }
    }
}

