/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDK;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.util.log.DebugLog;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.log.StubLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDKInitializer;", "", "()V", "licenseErrorHandler", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "licenseSet", "", "logger", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "setLogger", "(Lio/scanbot/sdk/util/log/Logger;)V", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "initialize", "Lio/scanbot/sap/SdkLicenseInfo;", "application", "Landroid/app/Application;", "licenceErrorHandler", "license", "", "loadNativeLibraries", "", "prepareBlobs", "sdkFilesDirectory", "Ljava/io/File;", "withLogging", "Companion", "PrepareBarcodeBlobsTask", "scanbot-barcode-scanner-sdk_release"})
public final class ScanbotBarcodeScannerSDKInitializer {
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean licenseSet;
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    private static boolean initialized;
    public static final Companion Companion;

    protected final boolean getUseLog() {
        return this.useLog;
    }

    protected final void setUseLog(boolean bl) {
        this.useLog = bl;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public final ScanbotBarcodeScannerSDKInitializer withLogging(boolean useLog) {
        if (useLog) {
            Log.w((String)"Scanbot Barcode SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = useLog;
        if (!useLog) {
            this.logger = (Logger)new StubLogger();
        }
        return this;
    }

    @NotNull
    public final ScanbotBarcodeScannerSDKInitializer license(@NotNull Application application, @NotNull String license) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
        preferences.edit().putString("SCANBOT_SDK_LICENSE_KEY", license).apply();
        this.licenseSet = true;
        return this;
    }

    @NotNull
    public final ScanbotBarcodeScannerSDKInitializer licenceErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler licenseErrorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)licenseErrorHandler, (String)"licenseErrorHandler");
        this.licenseErrorHandler = licenseErrorHandler;
        return this;
    }

    @NotNull
    public final SdkLicenseInfo initialize(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Logger logger = this.logger;
        if (logger == null) {
            logger = this.useLog ? (Logger)new DebugLog((Context)application) : (Logger)new StubLogger();
        }
        LoggerProvider.setLogger((Logger)logger);
        if (!this.licenseSet) {
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
            preferences.edit().remove("SCANBOT_SDK_LICENSE_KEY").apply();
        }
        this.loadNativeLibraries();
        SapSingleton.initializeSapManager((Context)((Context)application));
        SapManager sapManager = SapSingleton.getInstance();
        if (this.licenseErrorHandler != null) {
            sapManager.setLicenceErrorHandler(this.licenseErrorHandler);
        }
        initialized = true;
        this.prepareBlobs(application);
        SdkLicenseInfo licenseStatus = sapManager.getLicenseStatus();
        String message = "ScanbotBarcodeScannerSDK license status : " + licenseStatus.getStatus().name();
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", message);
        SdkLicenseInfo sdkLicenseInfo = licenseStatus;
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkLicenseInfo, (String)"licenseStatus");
        return sdkLicenseInfo;
    }

    private final void loadNativeLibraries() {
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdkbarcode");
    }

    private final void prepareBlobs(Application application) {
        new PrepareBarcodeBlobsTask(application).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
    }

    @NotNull
    public final ScanbotBarcodeScannerSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)sdkFilesDirectory, (String)"sdkFilesDirectory");
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)application));
        preferences.edit().putString("CUSTOM_SDK_FILES_PATH", sdkFilesDirectory.getPath()).apply();
        return this;
    }

    @NotNull
    public final ScanbotBarcodeScannerSDKInitializer logger(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J'\u0010\b\u001a\u0004\u0018\u00010\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\n\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDKInitializer$PrepareBarcodeBlobsTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "application", "Landroid/app/Application;", "(Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDKInitializer;Landroid/app/Application;)V", "getApplication", "()Landroid/app/Application;", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Void;", "fetchBlobs", "", "blobs", "", "Lio/scanbot/sdk/entity/Blob;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "scanbot-barcode-scanner-sdk_release"})
    public final class PrepareBarcodeBlobsTask
    extends AsyncTask<Void, Void, Void> {
        @NotNull
        private final Application application;

        @Nullable
        protected Void doInBackground(Void ... params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            ScanbotBarcodeScannerSDK scanbotSDK = new ScanbotBarcodeScannerSDK(this.application);
            BlobManager blobManager = scanbotSDK.blobManager();
            BlobFactory blobFactory = scanbotSDK.blobFactory();
            Logger logger = LoggerProvider.getLogger();
            boolean bl = false;
            Collection blobs = new ArrayList();
            try {
                blobs.addAll(blobFactory.getBlobsForType(BlobType.BARCODE_SCANNER_MODEL));
            }
            catch (IOException e) {
                logger.logException((Throwable)e);
                logger.e("PrepareBlobsTask", "Could not fetch Barcode Scanner Model blob!");
            }
            this.fetchBlobs(blobs, blobManager);
            return null;
        }

        private final void fetchBlobs(Collection<Blob> blobs, BlobManager blobManager) {
            Logger logger = LoggerProvider.getLogger();
            for (Blob blob : blobs) {
                try {
                    blobManager.fetch(blob);
                }
                catch (IOException e) {
                    logger.logException((Throwable)e);
                    logger.e("PrepareBarcodeBlobsTask", "Could not fetch blob! /n Blob local path: " + blob.getLocalPath() + " /n Blob remote path: " + blob.getRemotePath());
                }
            }
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public PrepareBarcodeBlobsTask(Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            this.application = application;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDKInitializer$Companion;", "", "()V", "initialized", "", "isInitialized", "scanbot-barcode-scanner-sdk_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

