/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import dagger.Module;
import dagger.Provides;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import java.io.IOException;
import javax.inject.Singleton;

@Module
public class ScanbotBarcodeScannerSDKModule {
    @Provides
    @Singleton
    public SapManager providesSapManager(Application application) {
        return new SapProvider(application).get();
    }

    @Provides
    public BlobStoreStrategy providesBlobStoreStrategy(Application application, SharedPreferences sharedPreferences) {
        return new BlobStoreStrategy(application, sharedPreferences);
    }

    @Provides
    public BlobsStorage providesBlobsStorage(SharedPreferences sharedPreferences) {
        return new BlobsStorage(sharedPreferences);
    }

    @Provides
    public BlobFactory providesBlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        return new BlobFactory(blobStoreStrategy, blobsStorage, assetManager);
    }

    @Provides
    public BlobManager providesBlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        return new BlobManager(blobStoreStrategy, assetManager, blobFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Provides
    @Singleton
    public ScanbotBarcodeDetector scanbotBarcodeDetector(SapManager sapManager, BlobManager blobManager) {
        if (!sapManager.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            return new StubScanbotBarcodeDetector(sapManager);
        }
        try {
            if (!blobManager.getBarcodeDetectionModelFile().exists()) {
                blobManager.forceFetch(BlobType.BARCODE_DETECTION_MODEL);
            }
            if (blobManager.getBarcodeBinarizationModelFile().exists()) return new DefaultScanbotBarcodeDetector(blobManager);
            blobManager.forceFetch(BlobType.BARCODE_BINARIZATION_MODEL);
            return new DefaultScanbotBarcodeDetector(blobManager);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't get the barcode detector models.");
        }
    }

    @Provides
    public BarcodeFileStorage providesBarcodeFileStorage(Application application) {
        return new BarcodeFileStorage(application);
    }
}

