/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Build;
import dagger.Module;
import dagger.Provides;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.exceptions.crypto.EncryptionInitException;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.fileio.DefaultFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.EncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import javax.inject.Singleton;

@Module
public class ScanbotBarcodeScannerSDKModule {
    private static FileStorageSettings a = new FileStorageSettings.Builder().useFileEncryption(false).build();

    public static void setFileStorageSettings(FileStorageSettings customStorageSettings) {
        a = customStorageSettings;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public SapManager providesSapManager(Application application) {
        void var1_1;
        return new SapProvider((Application)var1_1).get();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public BlobStoreStrategy providesBlobStoreStrategy(Application application, SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        return new BlobStoreStrategy((Application)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public BlobsStorage providesBlobsStorage(SharedPreferences preferences) {
        void var1_1;
        return new BlobsStorage((SharedPreferences)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public BlobFactory providesBlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BlobFactory((BlobStoreStrategy)var1_1, (BlobsStorage)var2_2, (AssetManager)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public BlobManager providesBlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BlobManager((BlobStoreStrategy)var1_1, (AssetManager)var2_2, (BlobFactory)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public ScanbotBarcodeDetector scanbotBarcodeDetector(SapManager sapManager) {
        void var1_1;
        if (sapManager.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            return new DefaultScanbotBarcodeDetector();
        }
        return new StubScanbotBarcodeDetector((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public BarcodeFileStorage providesBarcodeFileStorage(Application application) {
        void var1_1;
        return new BarcodeFileStorage((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public FileIOProcessor provideFileIOProcessor(Application application) {
        void var1_1;
        if (a.getEncryptionEnabled()) {
            if (a.getCustomFileIOProcessor() != null) {
                return a.getCustomFileIOProcessor();
            }
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    return new EncryptedFileIOProcessor((Context)var1_1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new EncryptionInitException("Could not initialize an encrypted image storage! Please, check that you added dependency on io.scanbot:sdk-crypto-persistence:VERSION");
                }
            }
            throw new EncryptionInitException("Could not initialize an encrypted image storage! An encryption feature is supported only with minSdkVersion 24+.");
        }
        return new DefaultFileIOProcessor((Context)var1_1);
    }

    @Provides
    public ImageFileIOProcessor provideImageFileIOProcessor(FileIOProcessor fileIOProcessor) {
        return fileIOProcessor;
    }
}

