/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.Context;
import dagger.Module;
import dagger.Provides;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.document.BarcodeDocumentParser;
import io.scanbot.sdk.barcode.document.DefaultBarcodeDocumentParser;
import io.scanbot.sdk.barcode.document.StubBarcodeDocumentParser;
import io.scanbot.sdk.barcode_scanner.di.DependenciesCheckUtils;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.exceptions.crypto.EncryptionInitException;
import io.scanbot.sdk.pdf.DefaultPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.pdf.PdfiumPdfImagesExtractor;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.fileio.DefaultFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.EncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0007\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule;", "", "()V", "provideCameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "provideFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "application", "Landroid/app/Application;", "provideImageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "fileIOProcessor", "providePdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "providesBarcodeFileStorage", "Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "providesSapManager", "Lio/scanbot/sap/SapManager;", "scanbotBarcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "sapManager", "scanbotBarcodeDocumentParser", "Lio/scanbot/sdk/barcode/document/BarcodeDocumentParser;", "Companion", "scanbot-barcode-scanner-sdk_release"})
public final class ScanbotBarcodeScannerSDKModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static FileStorageSettings a = new FileStorageSettings.Builder().useFileEncryption(false).build();
    @Nullable
    public static CameraUiSettings b;
    @Nullable
    public static PdfImagesExtractorSettings c;

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SapManager providesSapManager(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        SapManager sapManager = new SapProvider((Application)var1_1).get();
        Intrinsics.checkNotNullExpressionValue((Object)sapManager, (String)"SapProvider(application).get()");
        return sapManager;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ScanbotBarcodeDetector scanbotBarcodeDetector(@NotNull SapManager sapManager) {
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule;
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector;
            scanbotBarcodeScannerSDKModule = defaultScanbotBarcodeDetector;
            defaultScanbotBarcodeDetector = new DefaultScanbotBarcodeDetector();
        } else {
            void var1_1;
            StubScanbotBarcodeDetector stubScanbotBarcodeDetector;
            scanbotBarcodeScannerSDKModule = stubScanbotBarcodeDetector;
            stubScanbotBarcodeDetector = new StubScanbotBarcodeDetector((SapManager)var1_1);
        }
        return scanbotBarcodeScannerSDKModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeDocumentParser scanbotBarcodeDocumentParser(@NotNull SapManager sapManager) {
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule;
        SapManager sapManager2 = sapManager;
        Intrinsics.checkNotNullParameter((Object)sapManager2, (String)"sapManager");
        if (sapManager2.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            DefaultBarcodeDocumentParser defaultBarcodeDocumentParser;
            scanbotBarcodeScannerSDKModule = defaultBarcodeDocumentParser;
            defaultBarcodeDocumentParser = new DefaultBarcodeDocumentParser();
        } else {
            void var1_1;
            StubBarcodeDocumentParser stubBarcodeDocumentParser;
            scanbotBarcodeScannerSDKModule = stubBarcodeDocumentParser;
            stubBarcodeDocumentParser = new StubBarcodeDocumentParser((SapManager)var1_1);
        }
        return scanbotBarcodeScannerSDKModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeFileStorage providesBarcodeFileStorage(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new BarcodeFileStorage((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final FileIOProcessor provideFileIOProcessor(@NotNull Application application) {
        void var1_1;
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (a.getEncryptionEnabled()) {
            EncryptedFileIOProcessor encryptedFileIOProcessor;
            if (a.getCustomFileIOProcessor() != null) {
                FileIOProcessor fileIOProcessor = a.getCustomFileIOProcessor();
                Intrinsics.checkNotNull((Object)fileIOProcessor);
                return fileIOProcessor;
            }
            scanbotBarcodeScannerSDKModule = encryptedFileIOProcessor;
            try {
                encryptedFileIOProcessor = new EncryptedFileIOProcessor((Context)var1_1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new EncryptionInitException("Could not initialize an encrypted image storage! Please, check that you added dependency on io.scanbot:sdk-crypto-persistence:VERSION");
            }
        } else {
            DefaultFileIOProcessor defaultFileIOProcessor;
            scanbotBarcodeScannerSDKModule = defaultFileIOProcessor;
            defaultFileIOProcessor = new DefaultFileIOProcessor((Context)var1_1);
        }
        return scanbotBarcodeScannerSDKModule;
    }

    @Provides
    @NotNull
    public final ImageFileIOProcessor provideImageFileIOProcessor(@NotNull FileIOProcessor fileIOProcessor) {
        FileIOProcessor fileIOProcessor2 = fileIOProcessor;
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor2, (String)"fileIOProcessor");
        return fileIOProcessor2;
    }

    @Provides
    @NotNull
    public final CameraUiSettings provideCameraUiSettings() {
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule = b;
        if (scanbotBarcodeScannerSDKModule == null) {
            CameraUiSettings cameraUiSettings;
            scanbotBarcodeScannerSDKModule = cameraUiSettings;
            cameraUiSettings = new CameraUiSettings(true);
        }
        return scanbotBarcodeScannerSDKModule;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfImagesExtractor providePdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfImagesExtractor defaultPdfImagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = c;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var2_12;
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor;
                DependenciesCheckUtils.Companion.checkDependency$scanbot_barcode_scanner_sdk_release(DependenciesCheckUtils.RequiredDependency.Pdfium.INSTANCE);
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor2 = pdfiumPdfImagesExtractor;
                pdfiumPdfImagesExtractor = new PdfiumPdfImagesExtractor((FileIOProcessor)var1_11, (Context)var2_12);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfImagesExtractor defaultPdfImagesExtractor2 = defaultPdfImagesExtractor;
        defaultPdfImagesExtractor = new DefaultPdfImagesExtractor((FileIOProcessor)var1_11);
        return var0_10;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule$Companion;", "", "()V", "cameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "getCameraUiSettings", "()Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "setCameraUiSettings", "(Lio/scanbot/sdk/ui/camera/CameraUiSettings;)V", "fileStorageSettings", "Lio/scanbot/sdk/persistence/FileStorageSettings;", "getFileStorageSettings", "()Lio/scanbot/sdk/persistence/FileStorageSettings;", "setFileStorageSettings", "(Lio/scanbot/sdk/persistence/FileStorageSettings;)V", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "getPdfImagesExtractorSettings", "()Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "setPdfImagesExtractorSettings", "(Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;)V", "scanbot-barcode-scanner-sdk_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final FileStorageSettings getFileStorageSettings() {
            return a;
        }

        public final void setFileStorageSettings(@NotNull FileStorageSettings fileStorageSettings) {
            FileStorageSettings fileStorageSettings2 = fileStorageSettings;
            Intrinsics.checkNotNullParameter((Object)fileStorageSettings2, (String)"<set-?>");
            a = fileStorageSettings2;
        }

        @Nullable
        public final CameraUiSettings getCameraUiSettings() {
            return b;
        }

        public final void setCameraUiSettings(@Nullable CameraUiSettings cameraUiSettings) {
            b = cameraUiSettings;
        }

        @Nullable
        public final PdfImagesExtractorSettings getPdfImagesExtractorSettings() {
            return c;
        }

        public final void setPdfImagesExtractorSettings(@Nullable PdfImagesExtractorSettings pdfImagesExtractorSettings) {
            c = pdfImagesExtractorSettings;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PdfImagesExtractor.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PdfImagesExtractor.Type.PDFIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PdfImagesExtractor.Type.ANDROID_PDF_WRITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

