/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.Context;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.BarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.BarcodeScannerFactory;
import io.scanbot.sdk.barcode.IBarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.IBarcodeScannerFactory;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalLruStorage;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalRepository;
import io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal;
import io.scanbot.sdk.barcode_scanner.di.BarcodeDependencyCheck;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.di.DependencyCheckUtils;
import io.scanbot.sdk.di.RequiredDependency;
import io.scanbot.sdk.exceptions.crypto.EncryptionInitException;
import io.scanbot.sdk.pdf.DefaultPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.pdf.PdfiumPdfImagesExtractor;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.fileio.DefaultFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.EncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.result.ResultStorage;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0007J'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0017\u0010\u0007\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\b\u00a2\u0006\u0002\b\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule;", "", "()V", "provideBarcodeScannerUiResultInternalLruStorage", "Lio/scanbot/sdk/ui/result/ResultStorage;", "provideBarcodeScannerUiResultInternalRepository", "Lio/scanbot/sdk/ui/result/ResultRepository;", "storages", "", "Lkotlin/jvm/JvmSuppressWildcards;", "provideFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "application", "Landroid/app/Application;", "provideImageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "fileIOProcessor", "providePdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "providesBarcodeFileStorage", "Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "providesSapManager", "Lio/scanbot/sap/SapManager;", "scanbotBarcodeDocumentParser", "Lio/scanbot/sdk/barcode/IBarcodeDocumentParserFactory;", "scanbotBarcodeScanner", "Lio/scanbot/sdk/barcode/IBarcodeScannerFactory;", "Companion", "scanbot-barcode-scanner-sdk_release"})
@SourceDebugExtension(value={"SMAP\nScanbotBarcodeScannerSDKModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotBarcodeScannerSDKModule.kt\nio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n223#2,2:121\n*S KotlinDebug\n*F\n+ 1 ScanbotBarcodeScannerSDKModule.kt\nio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule\n*L\n101#1:121,2\n*E\n"})
public final class ScanbotBarcodeScannerSDKModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static FileStorageSettings a = new FileStorageSettings.Builder().useFileEncryption(false).build();
    @Nullable
    public static PdfImagesExtractorSettings b;

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SapManager providesSapManager(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        SapManager sapManager = new SapProvider((Application)var1_1).get();
        Intrinsics.checkNotNullExpressionValue((Object)sapManager, (String)"get(...)");
        return sapManager;
    }

    @Provides
    @NotNull
    public final IBarcodeScannerFactory scanbotBarcodeScanner() {
        return new BarcodeScannerFactory();
    }

    @Provides
    @NotNull
    public final IBarcodeDocumentParserFactory scanbotBarcodeDocumentParser() {
        return new BarcodeDocumentParserFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeFileStorage providesBarcodeFileStorage(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new BarcodeFileStorage((Application)var1_1);
    }

    @Provides
    @Singleton
    @NotNull
    public final FileIOProcessor provideFileIOProcessor(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        if (a.getEncryptionEnabled()) {
            EncryptedFileIOProcessor encryptedFileIOProcessor;
            if (a.getCustomFileIOProcessor() != null) {
                FileIOProcessor fileIOProcessor = a.getCustomFileIOProcessor();
                Intrinsics.checkNotNull((Object)fileIOProcessor);
                return fileIOProcessor;
            }
            this = encryptedFileIOProcessor;
            try {
                encryptedFileIOProcessor = new EncryptedFileIOProcessor((Context)var1_1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new EncryptionInitException("Could not initialize an encrypted image storage! Please, check that you added dependency on io.scanbot:sdk-crypto-persistence:VERSION");
            }
        } else {
            DefaultFileIOProcessor defaultFileIOProcessor;
            this = defaultFileIOProcessor;
            defaultFileIOProcessor = new DefaultFileIOProcessor((Context)var1_1);
        }
        return this;
    }

    @Provides
    @NotNull
    public final ImageFileIOProcessor provideImageFileIOProcessor(@NotNull FileIOProcessor fileIOProcessor) {
        FileIOProcessor fileIOProcessor2 = fileIOProcessor;
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor2, (String)"fileIOProcessor");
        return fileIOProcessor2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfImagesExtractor providePdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfImagesExtractor defaultPdfImagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = b;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var2_12;
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor;
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BarcodeDependencyCheck.PDFIUM_IMAGES);
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor2 = pdfiumPdfImagesExtractor;
                pdfiumPdfImagesExtractor = new PdfiumPdfImagesExtractor((FileIOProcessor)var1_11, (Context)var2_12);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfImagesExtractor defaultPdfImagesExtractor2 = defaultPdfImagesExtractor;
        defaultPdfImagesExtractor = new DefaultPdfImagesExtractor((FileIOProcessor)var1_11);
        return var0_10;
    }

    @Provides
    @IntoSet
    @NotNull
    public final ResultRepository<Object> provideBarcodeScannerUiResultInternalRepository(@NotNull Set<ResultStorage<Object>> storages) {
        Set<ResultStorage<Object>> set = storages;
        Intrinsics.checkNotNullParameter(set, (String)"storages");
        for (Object e : set) {
            ResultStorage resultStorage = (ResultStorage)e;
            if (!Intrinsics.areEqual((Object)resultStorage.getAcceptedType(), BarcodeScannerUiResultInternal.class)) continue;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.result.ResultStorage<io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal>");
            return new BarcodeScannerUiResultInternalRepository(resultStorage);
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Provides
    @Singleton
    @IntoSet
    @NotNull
    public final ResultStorage<Object> provideBarcodeScannerUiResultInternalLruStorage() {
        return new BarcodeScannerUiResultInternalLruStorage();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule$Companion;", "", "()V", "fileStorageSettings", "Lio/scanbot/sdk/persistence/FileStorageSettings;", "getFileStorageSettings", "()Lio/scanbot/sdk/persistence/FileStorageSettings;", "setFileStorageSettings", "(Lio/scanbot/sdk/persistence/FileStorageSettings;)V", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "getPdfImagesExtractorSettings", "()Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "setPdfImagesExtractorSettings", "(Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;)V", "scanbot-barcode-scanner-sdk_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final FileStorageSettings getFileStorageSettings() {
            return a;
        }

        public final void setFileStorageSettings(@NotNull FileStorageSettings fileStorageSettings) {
            FileStorageSettings fileStorageSettings2 = fileStorageSettings;
            Intrinsics.checkNotNullParameter((Object)fileStorageSettings2, (String)"<set-?>");
            a = fileStorageSettings2;
        }

        @Nullable
        public final PdfImagesExtractorSettings getPdfImagesExtractorSettings() {
            return b;
        }

        public final void setPdfImagesExtractorSettings(@Nullable PdfImagesExtractorSettings pdfImagesExtractorSettings) {
            b = pdfImagesExtractorSettings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PdfImagesExtractor.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PdfImagesExtractor.Type.PDFIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PdfImagesExtractor.Type.ANDROID_PDF_WRITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

