/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeDetectorFrameHandler;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\b\u0016\u0018\u0000 >2\u00020\u0001:\u0006;<=>?@B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0004J\u0012\u00103\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u0002002\b\u00108\u001a\u0004\u0018\u00010\u000bJ\u000e\u00109\u001a\u0002002\u0006\u0010:\u001a\u000205R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006A"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;", "", "cameraView", "Lnet/doo/snap/camera/ScanbotCameraView;", "barcodeDetectorFrameHandler", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "(Lnet/doo/snap/camera/ScanbotCameraView;Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;)V", "frameHandler", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler;", "(Lnet/doo/snap/camera/ScanbotCameraView;Lnet/doo/snap/camera/PreviewBuffer$FrameHandler;)V", "autoSnappingCallback", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "autosnappingShoot", "Ljava/lang/Runnable;", "getCameraView", "()Lnet/doo/snap/camera/ScanbotCameraView;", "captureInterval", "Ljava/util/concurrent/atomic/AtomicLong;", "getCaptureInterval", "()Ljava/util/concurrent/atomic/AtomicLong;", "capturing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getCapturing", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setCapturing", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "isAutosnappingShooting", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "lastCapture", "", "getLastCapture", "()J", "setLastCapture", "(J)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lnet/doo/snap/util/log/Logger;", "mainThreadHandler", "Landroid/os/Handler;", "getMainThreadHandler", "()Landroid/os/Handler;", "barcodesDetected", "", "result", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "checkDetectedBarcodesAndSnap", "clamp", "", "value", "setAutoSnappingCallback", "callback", "setSensitivity", "sensitivity", "AutoSnappingCallback", "CameraStateCallbackImpl", "CameraTakePictureCallbackImpl", "Companion", "DetectionHandler", "PictureCallbackImpl", "sdk-barcode_release"})
public class BarcodeAutoSnappingController {
    @NotNull
    private final AtomicLong captureInterval;
    private final Logger logger;
    private long lastCapture;
    @NotNull
    private AtomicBoolean capturing;
    @NotNull
    private final Handler mainThreadHandler;
    private boolean isEnabled;
    private final AtomicBoolean isAutosnappingShooting;
    private AutoSnappingCallback autoSnappingCallback;
    private final Runnable autosnappingShoot;
    @NotNull
    private final ScanbotCameraView cameraView;
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final AtomicLong getCaptureInterval() {
        return this.captureInterval;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final long getLastCapture() {
        return this.lastCapture;
    }

    protected final void setLastCapture(long l) {
        this.lastCapture = l;
    }

    @NotNull
    protected final AtomicBoolean getCapturing() {
        return this.capturing;
    }

    protected final void setCapturing(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkParameterIsNotNull((Object)atomicBoolean, (String)"<set-?>");
        this.capturing = atomicBoolean;
    }

    @NotNull
    protected final Handler getMainThreadHandler() {
        return this.mainThreadHandler;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    protected final void barcodesDetected(@Nullable BarcodeScanningResult result) {
        if (!this.isAutosnappingShooting.get()) {
            this.checkDetectedBarcodesAndSnap(result);
        }
    }

    private final void checkDetectedBarcodesAndSnap(BarcodeScanningResult result) {
        if (result != null) {
            Collection collection = result.getBarcodeItems();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.isAutosnappingShooting.set(true);
                this.mainThreadHandler.post(this.autosnappingShoot);
            }
        }
    }

    public final void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float threshold = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(threshold * (float)MAXIMUM_CAPTURE_INTERVAL));
    }

    private final float clamp(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public final void setAutoSnappingCallback(@Nullable AutoSnappingCallback callback) {
        this.logger.logMethod();
        AutoSnappingCallback autoSnappingCallback = callback;
        if (autoSnappingCallback == null) {
            autoSnappingCallback = AutoSnappingCallback.Companion.getNULL();
        }
        this.autoSnappingCallback = autoSnappingCallback;
    }

    @NotNull
    protected final ScanbotCameraView getCameraView() {
        return this.cameraView;
    }

    protected BarcodeAutoSnappingController(@NotNull ScanbotCameraView cameraView, @NotNull PreviewBuffer.FrameHandler frameHandler) {
        Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
        Intrinsics.checkParameterIsNotNull((Object)frameHandler, (String)"frameHandler");
        this.cameraView = cameraView;
        this.captureInterval = new AtomicLong(DEFAULT_CAPTURE_INTERVAL_MS);
        this.logger = LoggerProvider.getLogger();
        this.capturing = new AtomicBoolean(false);
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isEnabled = true;
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = AutoSnappingCallback.Companion.getNULL();
        this.autosnappingShoot = new Runnable(this){
            final /* synthetic */ BarcodeAutoSnappingController this$0;

            public final void run() {
                if (this.this$0.isEnabled()) {
                    if (!BarcodeAutoSnappingController.access$getAutoSnappingCallback$p(this.this$0).onAutoSnapping()) {
                        if (Build.VERSION.SDK_INT >= 24) {
                            this.this$0.getCameraView().takePicture(false);
                        } else {
                            this.this$0.getCameraView().takePicture(true);
                        }
                    }
                } else {
                    BarcodeAutoSnappingController.access$isAutosnappingShooting$p(this.this$0).set(false);
                }
            }
            {
                this.this$0 = barcodeAutoSnappingController;
            }
        };
        this.cameraView.getPreviewBuffer().addFrameHandler(frameHandler);
        this.cameraView.addPictureCallback((PictureCallback)new PictureCallbackImpl());
        this.cameraView.addCameraStateCallback((CameraStateCallback)new CameraStateCallbackImpl());
        this.cameraView.addTakePictureCallback((CameraTakePictureCallback)new CameraTakePictureCallbackImpl());
    }

    public BarcodeAutoSnappingController(@NotNull ScanbotCameraView cameraView, @NotNull BarcodeDetectorFrameHandler barcodeDetectorFrameHandler) {
        Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
        Intrinsics.checkParameterIsNotNull((Object)barcodeDetectorFrameHandler, (String)"barcodeDetectorFrameHandler");
        this(cameraView, (PreviewBuffer.FrameHandler)barcodeDetectorFrameHandler);
        barcodeDetectorFrameHandler.addResultHandler(new DetectionHandler());
    }

    static {
        DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
        MAXIMUM_CAPTURE_INTERVAL = 3000L;
    }

    public static final /* synthetic */ AutoSnappingCallback access$getAutoSnappingCallback$p(BarcodeAutoSnappingController $this) {
        return $this.autoSnappingCallback;
    }

    public static final /* synthetic */ void access$setAutoSnappingCallback$p(BarcodeAutoSnappingController $this, AutoSnappingCallback autoSnappingCallback) {
        $this.autoSnappingCallback = autoSnappingCallback;
    }

    @JvmStatic
    @NotNull
    public static final BarcodeAutoSnappingController attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotBarcodeDetector barcodeDetector) {
        return Companion.attach(cameraView, barcodeDetector);
    }

    @JvmStatic
    @NotNull
    public static final BarcodeAutoSnappingController attach(@NotNull ScanbotCameraView cameraView, @NotNull BarcodeDetectorFrameHandler barcodeDetectorFrameHandler) {
        return Companion.attach(cameraView, barcodeDetectorFrameHandler);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "", "onAutoSnapping", "", "Companion", "sdk-barcode_release"})
    public static interface AutoSnappingCallback {
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean onAutoSnapping();

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback$Companion;", "", "()V", "NULL", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "getNULL", "()Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "sdk-barcode_release"})
        public static final class Companion {
            @NotNull
            private static final AutoSnappingCallback NULL;
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final AutoSnappingCallback getNULL() {
                return NULL;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                NULL = new AutoSnappingCallback(){

                    public boolean onAutoSnapping() {
                        return false;
                    }
                };
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$DetectionHandler;", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "(Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;)V", "handle", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "postBarcodesDetected", "", "barcodeScanningResult", "sdk-barcode_release"})
    private final class DetectionHandler
    implements BarcodeDetectorFrameHandler.ResultHandler {
        public boolean handle(@NotNull FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> result) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            BarcodeAutoSnappingController.this.getLogger().logMethod();
            if (result instanceof FrameHandlerResult.Success) {
                BarcodeScanningResult barcodeScanningResult = (BarcodeScanningResult)((FrameHandlerResult.Success)result).getValue();
                if (BarcodeAutoSnappingController.this.getCapturing().get() && SystemClock.elapsedRealtime() - BarcodeAutoSnappingController.this.getLastCapture() > BarcodeAutoSnappingController.this.getCaptureInterval().get()) {
                    if (BarcodeAutoSnappingController.this.getLastCapture() != 0L) {
                        this.postBarcodesDetected(barcodeScanningResult);
                    }
                    BarcodeAutoSnappingController.this.setLastCapture(SystemClock.elapsedRealtime());
                }
            }
            return false;
        }

        private final void postBarcodesDetected(BarcodeScanningResult barcodeScanningResult) {
            BarcodeAutoSnappingController.this.getMainThreadHandler().post(new Runnable(this, barcodeScanningResult){
                final /* synthetic */ DetectionHandler this$0;
                final /* synthetic */ BarcodeScanningResult $barcodeScanningResult;

                public final void run() {
                    this.this$0.BarcodeAutoSnappingController.this.barcodesDetected(this.$barcodeScanningResult);
                }
                {
                    this.this$0 = detectionHandler;
                    this.$barcodeScanningResult = barcodeScanningResult;
                }
            });
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$PictureCallbackImpl;", "Lnet/doo/snap/camera/PictureCallback;", "(Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;)V", "onPictureTaken", "", "image", "", "imageOrientation", "", "sdk-barcode_release"})
    private final class PictureCallbackImpl
    implements PictureCallback {
        public void onPictureTaken(@NotNull byte[] image, int imageOrientation) {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            BarcodeAutoSnappingController.this.getMainThreadHandler().removeCallbacksAndMessages(null);
            BarcodeAutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$CameraStateCallbackImpl;", "Lnet/doo/snap/camera/CameraStateCallback;", "(Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;)V", "onPause", "", "onResume", "sdk-barcode_release"})
    private final class CameraStateCallbackImpl
    implements CameraStateCallback {
        public void onResume() {
            BarcodeAutoSnappingController.this.getCapturing().set(true);
        }

        public void onPause() {
            BarcodeAutoSnappingController.this.isAutosnappingShooting.set(false);
            BarcodeAutoSnappingController.this.getCapturing().set(false);
            BarcodeAutoSnappingController.this.setLastCapture(0L);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$CameraTakePictureCallbackImpl;", "Lnet/doo/snap/camera/CameraTakePictureCallback;", "(Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;)V", "onTakePictureCancelled", "", "onTakePictureRequested", "sdk-barcode_release"})
    private final class CameraTakePictureCallbackImpl
    implements CameraTakePictureCallback {
        public void onTakePictureRequested() {
        }

        public void onTakePictureCancelled() {
            BarcodeAutoSnappingController.this.getMainThreadHandler().removeCallbacksAndMessages(null);
            BarcodeAutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$Companion;", "", "()V", "DEFAULT_CAPTURE_INTERVAL_MS", "", "MAXIMUM_CAPTURE_INTERVAL", "attach", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;", "cameraView", "Lnet/doo/snap/camera/ScanbotCameraView;", "barcodeDetectorFrameHandler", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "sdk-barcode_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BarcodeAutoSnappingController attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotBarcodeDetector barcodeDetector) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)barcodeDetector, (String)"barcodeDetector");
            BarcodeDetectorFrameHandler frameHandler = new BarcodeDetectorFrameHandler(barcodeDetector);
            return this.attach(cameraView, frameHandler);
        }

        @JvmStatic
        @NotNull
        public final BarcodeAutoSnappingController attach(@NotNull ScanbotCameraView cameraView, @NotNull BarcodeDetectorFrameHandler barcodeDetectorFrameHandler) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)barcodeDetectorFrameHandler, (String)"barcodeDetectorFrameHandler");
            return new BarcodeAutoSnappingController(cameraView, barcodeDetectorFrameHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

