/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 /2\u00020\u0001:\u0002/0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J#\u0010\"\u001a\u00020\u00112\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020&0$H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0011J\u0014\u0010*\u001a\u00020\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "(Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;)V", "getBarcodeDetector$sdk_barcode_release", "()Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectionIntervalInMs", "", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "intervalEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getIntervalEnabled$sdk_barcode_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "kotlin.jvm.PlatformType", "sapManager", "Lio/scanbot/sap/SapManager;", "getSapManager$sdk_barcode_release", "()Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "notifyHandlers$sdk_barcode_release", "removeResultHandler", "saveCameraPreviewFrame", "setBarcodeFormatsFilter", "barcodeFormats", "", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "setDetectionInterval", "Companion", "ResultHandler", "sdk-barcode_release"})
public class BarcodeDetectorFrameHandler
implements FrameHandler {
    private final LinkedHashSet<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    private final Logger logger;
    private boolean isEnabled;
    @NotNull
    private final AtomicBoolean intervalEnabled;
    private long detectionIntervalInMs;
    @NotNull
    private final ScanbotBarcodeDetector barcodeDetector;
    private static final int DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS = 10000;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SapManager getSapManager$sdk_barcode_release() {
        return this.sapManager;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final AtomicBoolean getIntervalEnabled$sdk_barcode_release() {
        return this.intervalEnabled;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        BarcodeScanningResult result;
        BarcodeScanningResult barcodeScanningResult;
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled || !this.intervalEnabled.get()) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            this.notifyHandlers$sdk_barcode_release((FrameHandlerResult<BarcodeScanningResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
            return false;
        }
        if (previewFrame.finderRect == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
            barcodeScanningResult = this.barcodeDetector.detectFromNv21(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
            barcodeScanningResult = result = this.barcodeDetector.detectFromNv21(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation, previewFrame.finderRect);
        }
        if (result != null) {
            this.intervalEnabled.set(false);
            new Timer().schedule(new TimerTask(this){
                final /* synthetic */ BarcodeDetectorFrameHandler this$0;

                public void run() {
                    this.this$0.getIntervalEnabled$sdk_barcode_release().set(true);
                }
                {
                    this.this$0 = $outer;
                }
            }, this.detectionIntervalInMs);
        }
        return this.notifyHandlers$sdk_barcode_release((FrameHandlerResult<BarcodeScanningResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)result)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            bl2 = this.handlers.remove(handler);
        }
    }

    public final void setDetectionInterval(long detectionIntervalInMs) {
        this.detectionIntervalInMs = detectionIntervalInMs;
        this.intervalEnabled.set(true);
    }

    public final void saveCameraPreviewFrame(boolean saveCameraPreviewFrame) {
        this.barcodeDetector.saveCameraPreviewFrame(saveCameraPreviewFrame);
    }

    public final void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        this.barcodeDetector.setBarcodeFormatsFilter(barcodeFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean notifyHandlers$sdk_barcode_release(@NotNull FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        boolean handled = false;
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (linkedHashSet) {
            boolean bl3 = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    @NotNull
    public final ScanbotBarcodeDetector getBarcodeDetector$sdk_barcode_release() {
        return this.barcodeDetector;
    }

    public BarcodeDetectorFrameHandler(@NotNull ScanbotBarcodeDetector barcodeDetector) {
        Intrinsics.checkParameterIsNotNull((Object)barcodeDetector, (String)"barcodeDetector");
        this.barcodeDetector = barcodeDetector;
        this.handlers = new LinkedHashSet();
        SapManager sapManager = SapSingleton.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
        this.intervalEnabled = new AtomicBoolean(true);
        this.detectionIntervalInMs = 10000;
    }

    @JvmStatic
    @NotNull
    public static final BarcodeDetectorFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ScanbotBarcodeDetector barcodeDetector) {
        return Companion.attach(cameraView, barcodeDetector);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-barcode_release"})
    public static interface ResultHandler
    extends BaseResultHandler<BarcodeScanningResult, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$Companion;", "", "()V", "DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS", "", "attach", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "sdk-barcode_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BarcodeDetectorFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ScanbotBarcodeDetector barcodeDetector) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)barcodeDetector, (String)"barcodeDetector");
            BarcodeDetectorFrameHandler frameHandler = new BarcodeDetectorFrameHandler(barcodeDetector);
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

